/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.types.impl.DatatypeOpenMethod;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeOpenClass
extends ADynamicClass {
    private final Logger log = LoggerFactory.getLogger(DatatypeOpenClass.class);
    private IOpenClass superClass;
    private final String javaName;
    private final String packageName;
    private byte[] bytecode;
    private volatile Map<String, IOpenField> fields = null;
    private static final IOpenMethod toString;
    private static final IOpenMethod equals;
    private static final IOpenMethod hashCode;
    private static final MethodKey toStringKey;
    private static final MethodKey equalsKey;
    private static final MethodKey hashCodeKey;

    public DatatypeOpenClass(String name, String packageName) {
        super(name, null);
        this.javaName = StringUtils.isBlank((CharSequence)packageName) ? name : packageName + '.' + name;
        this.packageName = packageName;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public IOpenClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(IOpenClass superClass) {
        this.superClass = superClass;
    }

    public Iterable<IOpenClass> superClasses() {
        if (this.superClass != null) {
            return Collections.singletonList(this.superClass);
        }
        return Collections.emptyList();
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isArray() {
        return false;
    }

    protected LinkedHashMap<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new LinkedHashMap();
        }
        return (LinkedHashMap)this.fieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IOpenField> getFields() {
        Map<String, IOpenField> localFields = this.fields;
        if (localFields == null) {
            DatatypeOpenClass datatypeOpenClass = this;
            synchronized (datatypeOpenClass) {
                localFields = this.fields;
                if (localFields == null) {
                    this.fields = localFields = this.initializeFields();
                }
            }
        }
        return Collections.unmodifiableMap(localFields);
    }

    private Map<String, IOpenField> initializeFields() {
        LinkedHashMap<String, IOpenField> fields = new LinkedHashMap<String, IOpenField>();
        Iterable<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClass : superClasses) {
            fields.putAll(superClass.getFields());
        }
        fields.putAll(this.fieldMap());
        return fields;
    }

    public Map<String, IOpenField> getDeclaredFields() {
        return (Map)((HashMap)this.fieldMap()).clone();
    }

    public Object newInstance(IRuntimeEnv env) {
        Object instance = null;
        try {
            instance = this.getInstanceClass().newInstance();
        }
        catch (InstantiationException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        catch (Throwable e) {
            this.log.error("{}", (Object)this, (Object)e);
        }
        return instance;
    }

    public IOpenClass getComponentClass() {
        if (this.isArray()) {
            return JavaOpenClass.getOpenClass(this.getInstanceClass().getComponentType());
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.superClass, this.javaName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DatatypeOpenClass other = (DatatypeOpenClass)((Object)obj);
        return Objects.equals(this.superClass, other.getSuperClass()) && Objects.equals(this.getMetaInfo(), other.getMetaInfo()) && Objects.equals(this.javaName, other.getJavaName());
    }

    public String toString() {
        return this.javaName;
    }

    private IOpenMethod wrapDatatypeOpenMethod(IOpenMethod method) {
        if (method instanceof JavaOpenMethod) {
            JavaOpenMethod javaOpenMethod = (JavaOpenMethod)method;
            Method javaMethod = javaOpenMethod.getJavaMethod();
            for (IOpenField field : ((LinkedHashMap)this.fieldMap()).values()) {
                if (!(field instanceof DatatypeOpenField)) continue;
                DatatypeOpenField datatypeOpenField = (DatatypeOpenField)field;
                if (datatypeOpenField.getGetter().equals(javaMethod)) {
                    return new DatatypeOpenMethod(javaOpenMethod, (IOpenClass)this, javaOpenMethod.getParameterTypes(), field.getType());
                }
                if (!datatypeOpenField.getSetter().equals(javaMethod)) continue;
                IOpenClass[] parameterTypes = new IOpenClass[]{field.getType()};
                return new DatatypeOpenMethod(javaOpenMethod, (IOpenClass)this, parameterTypes, javaOpenMethod.getType());
            }
        }
        return method;
    }

    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        Map methods = super.initMethodMap();
        HashMap<MethodKey, IOpenMethod> methodMap = new HashMap<MethodKey, IOpenMethod>();
        for (Map.Entry m : methods.entrySet()) {
            IOpenMethod m1 = this.wrapDatatypeOpenMethod((IOpenMethod)m.getValue());
            if (m1 != m.getValue()) {
                methodMap.put(new MethodKey(m1), m1);
                continue;
            }
            methodMap.put((MethodKey)m.getKey(), (IOpenMethod)m.getValue());
        }
        methodMap.put(toStringKey, toString);
        methodMap.put(equalsKey, equals);
        methodMap.put(hashCodeKey, hashCode);
        return methodMap;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    static {
        try {
            toString = new JavaOpenMethod(Object.class.getMethod("toString", new Class[0]));
            equals = new JavaOpenMethod(Object.class.getMethod("equals", Object.class));
            hashCode = new JavaOpenMethod(Object.class.getMethod("hashCode", new Class[0]));
            toStringKey = new MethodKey(toString);
            equalsKey = new MethodKey(equals);
            hashCodeKey = new MethodKey(hashCode);
        }
        catch (NoSuchMethodException nsme) {
            throw RuntimeExceptionWrapper.wrap((Throwable)nsme);
        }
    }
}

