/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.List;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.ColumnMatchBoundNode;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.SubValue;
import org.openl.rules.cmatch.TableRow;
import org.openl.rules.cmatch.algorithm.ArgumentsHelper;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AMethodMetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public class ColumnMatchMetaInfoReader
extends AMethodMetaInfoReader<ColumnMatchBoundNode> {
    public ColumnMatchMetaInfoReader(ColumnMatchBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    protected CellMetaInfo getBodyMetaInfo(int row, int col) {
        if (this.isSpecialRow(row)) {
            return this.checkSpecialRowMetaInfo(row, col);
        }
        return this.checkValueMetaInfo(row, col);
    }

    private boolean isSpecialRow(int rowNum) {
        ColumnMatch columnMatch = ((ColumnMatchBoundNode)((Object)this.getBoundNode())).getColumnMatch();
        IGrid grid = columnMatch.getSyntaxNode().getTableBody().getSource().getGrid();
        int firstNameRowNum = this.getSpecialRowCount(columnMatch);
        IGridRegion firstNameRegion = columnMatch.getRows().get(firstNameRowNum).get("names")[0].getGridRegion();
        ICell cell = grid.getCell(firstNameRegion.getLeft(), firstNameRegion.getTop());
        return rowNum < cell.getAbsoluteRow();
    }

    private CellMetaInfo checkSpecialRowMetaInfo(int rowNum, int colNum) {
        TableRow row0;
        ColumnMatch columnMatch = ((ColumnMatchBoundNode)((Object)this.getBoundNode())).getColumnMatch();
        CellMetaInfo metaInfo = this.searchMetaInfo(columnMatch, rowNum, colNum, (row0 = columnMatch.getRows().get(0)).get("values"), columnMatch.getReturnValues());
        if (metaInfo != NOT_FOUND) {
            return metaInfo;
        }
        if (this.getSpecialRowCount(columnMatch) > 1) {
            TableRow totalScoreRow = columnMatch.getRows().get(1);
            MatchNode totalScore = columnMatch.getTotalScore();
            metaInfo = this.searchMetaInfo(columnMatch, rowNum, colNum, totalScoreRow.get("values"), totalScore.getCheckValues());
            if (metaInfo != NOT_FOUND) {
                return metaInfo;
            }
            TableRow scoreRow = columnMatch.getRows().get(2);
            metaInfo = this.searchMetaInfo(columnMatch, rowNum, colNum, scoreRow.get("values"), this.asObjects(columnMatch.getColumnScores()));
            if (metaInfo != NOT_FOUND) {
                return metaInfo;
            }
        }
        return null;
    }

    private Object[] asObjects(int[] columnScores) {
        Object[] objects = new Object[columnScores.length];
        for (int i = 0; i < columnScores.length; ++i) {
            objects[i] = columnScores[i];
        }
        return objects;
    }

    private CellMetaInfo searchMetaInfo(ColumnMatch columnMatch, int rowNum, int colNum, SubValue[] subValues, Object[] values) {
        IGrid grid = columnMatch.getSyntaxNode().getTableBody().getSource().getGrid();
        for (int sv = 0; sv < subValues.length; ++sv) {
            SubValue subValue = subValues[sv];
            IGridRegion region = subValue.getGridRegion();
            ICell cell = grid.getCell(region.getLeft(), region.getTop());
            if (!this.isNeededCell(cell, rowNum, colNum)) continue;
            Object value = values[sv];
            return value == null ? null : new CellMetaInfo((IOpenClass)JavaOpenClass.getOpenClass(value.getClass()), false);
        }
        return NOT_FOUND;
    }

    private CellMetaInfo checkValueMetaInfo(int rowNum, int colNum) {
        ColumnMatch columnMatch = ((ColumnMatchBoundNode)((Object)this.getBoundNode())).getColumnMatch();
        IGrid grid = columnMatch.getSyntaxNode().getTableBody().getSource().getGrid();
        List<TableRow> rows = columnMatch.getRows();
        for (int i = this.getSpecialRowCount(columnMatch); i < rows.size(); ++i) {
            TableRow row = rows.get(i);
            IGridRegion region = row.get("names")[0].getGridRegion();
            ICell cell = grid.getCell(region.getLeft(), region.getTop());
            if (cell.getAbsoluteRow() != rowNum) continue;
            if (this.isNeededCell(cell, rowNum, colNum)) {
                ArgumentsHelper argumentsHelper = new ArgumentsHelper(columnMatch.getHeader().getSignature());
                DomainOpenClass domainOpenClass = argumentsHelper.generateDomainClassByArgNames();
                return new CellMetaInfo((IOpenClass)domainOpenClass, false);
            }
            SubValue[] subValues = row.get("values");
            for (int sv = 0; sv < subValues.length; ++sv) {
                SubValue subValue = subValues[sv];
                region = subValue.getGridRegion();
                cell = grid.getCell(region.getLeft(), region.getTop());
                if (!this.isNeededCell(cell, rowNum, colNum)) continue;
                Object[] checkValues = this.getCheckValues(columnMatch, i);
                Object value = checkValues == null ? null : checkValues[sv];
                return value == null ? null : new CellMetaInfo((IOpenClass)JavaOpenClass.getOpenClass(value.getClass()), false);
            }
        }
        return null;
    }

    private Object[] getCheckValues(ColumnMatch columnMatch, int rowIndex) {
        MatchNode checkTree = columnMatch.getCheckTree();
        if (checkTree == null) {
            return null;
        }
        List<MatchNode> children = checkTree.getChildren();
        return this.getObjects(children, rowIndex);
    }

    private Object[] getObjects(List<MatchNode> children, int rowIndex) {
        for (MatchNode child : children) {
            if (child.getRowIndex() == rowIndex) {
                return child.getCheckValues();
            }
            Object[] objects = this.getObjects(child.getChildren(), rowIndex);
            if (objects == null) continue;
            return objects;
        }
        return null;
    }

    private int getSpecialRowCount(ColumnMatch columnMatch) {
        IOpenSourceCodeModule alg = columnMatch.getAlgorithm();
        String nameOfAlgorithm = alg != null ? alg.getCode() : null;
        return "WEIGHTED".equals(nameOfAlgorithm) ? 3 : 1;
    }
}

