/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.Collections;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableMetaInfoReader
extends BaseMetaInfoReader<DataTableBoundNode> {
    private final Logger log = LoggerFactory.getLogger(DataTableMetaInfoReader.class);

    public DataTableMetaInfoReader(DataTableBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    protected TableSyntaxNode getTableSyntaxNode() {
        return ((DataTableBoundNode)((Object)this.getBoundNode())).getTableSyntaxNode();
    }

    @Override
    protected CellMetaInfo getHeaderMetaInfo() {
        ILogicalTable table = this.getTableSyntaxNode().getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), null);
        DataTableBoundNode boundNode = (DataTableBoundNode)((Object)this.getBoundNode());
        if (boundNode.getField() == null) {
            return null;
        }
        IMetaInfo typeMeta = boundNode.getType().getMetaInfo();
        if (typeMeta != null) {
            try {
                IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
                return RuleRowHelper.createCellMetaInfo(parsedHeader[1], typeMeta, NodeType.DATATYPE);
            }
            catch (OpenLCompilationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    protected CellMetaInfo getBodyMetaInfo(int row, int col) {
        try {
            ITable table = ((DataTableBoundNode)((Object)this.getBoundNode())).getTable();
            if (table == null) {
                return null;
            }
            if (this.isDescription(table, row, col)) {
                return this.getDescriptionMetaInfo(table, row, col);
            }
            if (table.getNumberOfRows() > 0 && table.getNumberOfColumns() > 0) {
                return this.getDataMetaInfo(table, row, col);
            }
            return null;
        }
        catch (SyntaxNodeException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean isDescription(ITable table, int row, int col) {
        if (table.getNumberOfRows() == 0) {
            return true;
        }
        ICell firstDataCell = table.getRowTable(0).getCell(0, 0);
        if (table.getData().isNormalOrientation()) {
            return row < firstDataCell.getAbsoluteRow();
        }
        return col < firstDataCell.getAbsoluteColumn();
    }

    private CellMetaInfo getDescriptionMetaInfo(ITable table, int row, int col) {
        int numberOfColumns = table.getNumberOfColumns();
        for (int i = 0; i < numberOfColumns; ++i) {
            ColumnDescriptor descriptor = table.getColumnDescriptor(i);
            CellMetaInfo metaInfo = this.checkForeignKeyInHeader(descriptor, row, col);
            if (metaInfo == NOT_FOUND) continue;
            return metaInfo;
        }
        return null;
    }

    private CellMetaInfo checkForeignKeyInHeader(ColumnDescriptor descriptor, int row, int col) {
        ForeignKeyColumnDescriptor foreignDescriptor;
        CellKey cellKey;
        if (descriptor instanceof ForeignKeyColumnDescriptor && this.isNeededCell(cellKey = (foreignDescriptor = (ForeignKeyColumnDescriptor)descriptor).getForeignKeyCellCoordinate(), row, col)) {
            IdentifierNode foreignKeyTable;
            IDataBase db;
            ITable foreignTable;
            if (foreignDescriptor.isReference() && (foreignTable = (db = ((DataTableBoundNode)((Object)this.getBoundNode())).getDataBase()).getTable((foreignKeyTable = foreignDescriptor.getForeignKeyTable()).getIdentifier())) != null) {
                SimpleNodeUsage nodeUsage = new SimpleNodeUsage(foreignKeyTable, foreignTable.getTableSyntaxNode().getHeaderLineValue().getValue(), foreignTable.getTableSyntaxNode().getUri(), NodeType.DATA);
                return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
            }
            return null;
        }
        return NOT_FOUND;
    }

    private CellMetaInfo getDataMetaInfo(ITable table, int row, int col) throws SyntaxNodeException {
        ILogicalTable data = table.getData();
        boolean normalOrientation = data.isNormalOrientation();
        ICell firstCell = table.getRowTable(0).getCell(0, 0);
        int logicalCol = normalOrientation ? col - firstCell.getAbsoluteColumn() : row - firstCell.getAbsoluteRow();
        for (int i = 0; i < table.getNumberOfColumns(); ++i) {
            IOpenClass columnType;
            ColumnDescriptor descriptor;
            ICell cell = data.getCell(i, 0);
            int logicalColStart = cell.getColumn();
            int logicalWidth = data.getColumnWidth(i);
            if (logicalColStart > logicalCol || logicalCol >= logicalColStart + logicalWidth || (descriptor = table.getColumnDescriptor(i)) == null) continue;
            if (descriptor instanceof ForeignKeyColumnDescriptor) {
                IDataBase db = ((DataTableBoundNode)((Object)this.getBoundNode())).getDataBase();
                columnType = ((ForeignKeyColumnDescriptor)descriptor).getDomainClassForForeignTable(db);
            } else {
                IOpenClass iOpenClass = columnType = descriptor.isConstructor() ? table.getDataModel().getType() : descriptor.getType();
            }
            if (columnType == null) {
                return null;
            }
            if (!descriptor.isValuesAnArray()) {
                return new CellMetaInfo(columnType, false);
            }
            if (descriptor instanceof ForeignKeyColumnDescriptor) {
                return new CellMetaInfo(columnType, logicalWidth == 1);
            }
            IOpenClass elemType = columnType.getAggregateInfo().getComponentType(columnType);
            return new CellMetaInfo(elemType, logicalWidth == 1);
        }
        return null;
    }
}

