/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AMethodMetaInfoReader;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;

public class SpreadsheetMetaInfoReader
extends AMethodMetaInfoReader<SpreadsheetBoundNode> {
    private Map<CellKey, CellMetaInfo> headerMetaInfo = new HashMap<CellKey, CellMetaInfo>();

    public SpreadsheetMetaInfoReader(SpreadsheetBoundNode boundNode) {
        super(boundNode);
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        SpreadsheetCell[][] cells = ((SpreadsheetBoundNode)((Object)this.getBoundNode())).getCells();
        if (cells == null) {
            return null;
        }
        ICell firstCell = cells[0][0].getSourceCell();
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (r < 0 || c < 0) {
            return this.headerMetaInfo.get(CellKey.CellKeyFactory.getCellKey(col, row));
        }
        SpreadsheetCell spreadsheetCell = this.findCell(cells, row, col);
        if (spreadsheetCell == null) {
            return null;
        }
        ICell sourceCell = spreadsheetCell.getSourceCell();
        IOpenClass type = spreadsheetCell.getType();
        String stringValue = sourceCell.getStringValue();
        if (stringValue != null) {
            ArrayList<NodeUsage> nodeUsages = null;
            if (stringValue.startsWith("=") || stringValue.startsWith("{") && stringValue.endsWith("}")) {
                IOpenMethod method;
                nodeUsages = new ArrayList<NodeUsage>();
                int from = stringValue.indexOf(61);
                if (from >= 0) {
                    String description = "Cell type: " + type.getDisplayName(0);
                    nodeUsages.add(new SimpleNodeUsage(from, from, description, null, NodeType.OTHER));
                }
                if ((method = spreadsheetCell.getMethod()) instanceof CompositeMethod) {
                    int startIndex = from + 1;
                    List<NodeUsage> parsedNodeUsages = OpenLCellExpressionsCompiler.getNodeUsages((CompositeMethod)method, stringValue.substring(startIndex), startIndex);
                    nodeUsages.addAll(parsedNodeUsages);
                }
            }
            boolean isRet = false;
            if (((SpreadsheetBoundNode)((Object)this.getBoundNode())).getComponentsBuilder().isExistsReturnHeader()) {
                isRet = ((SpreadsheetBoundNode)((Object)this.getBoundNode())).getComponentsBuilder().getReturnHeaderDefinition().isReturnCell(spreadsheetCell);
            }
            return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages, isRet);
        }
        return null;
    }

    public void addHeaderMetaInfo(int row, int col, CellMetaInfo metaInfo) {
        this.headerMetaInfo.put(CellKey.CellKeyFactory.getCellKey(col, row), metaInfo);
    }

    private SpreadsheetCell findCell(SpreadsheetCell[][] cells, int row, int col) {
        SpreadsheetCell spreadsheetCell;
        ICell sourceCell;
        ICell firstCell = cells[0][0].getSourceCell();
        int r = row - firstCell.getAbsoluteRow();
        int c = col - firstCell.getAbsoluteColumn();
        if (r >= cells.length) {
            r = cells.length - 1;
        }
        if (c >= cells[0].length) {
            c = cells[0].length - 1;
        }
        if ((sourceCell = (spreadsheetCell = cells[r][c]).getSourceCell()).getAbsoluteRow() == row && sourceCell.getAbsoluteColumn() == col) {
            return spreadsheetCell;
        }
        while (col < sourceCell.getAbsoluteColumn() && c > 0) {
            spreadsheetCell = cells[r][--c];
            sourceCell = spreadsheetCell.getSourceCell();
        }
        while (row < sourceCell.getAbsoluteRow() && r > 0) {
            spreadsheetCell = cells[--r][c];
            sourceCell = spreadsheetCell.getSourceCell();
        }
        if (sourceCell.getAbsoluteRow() == row && sourceCell.getAbsoluteColumn() == col) {
            return spreadsheetCell;
        }
        return null;
    }
}

