/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.HashSet;
import org.openl.rules.table.AGrid;
import org.openl.rules.table.CompositeCell;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;

public class CompositeGrid
extends AGrid {
    private IGridTable[] gridTables;
    private IGridRegion[] mappedRegions;
    private IGridRegion[] mergedRegions;
    private boolean vertical;
    private int width = 0;
    private int height = 0;

    public IGridTable[] getGridTables() {
        return this.gridTables;
    }

    public IGridRegion getMappedRegion(int i) {
        return this.mappedRegions[i];
    }

    public CompositeGrid(IGridTable[] tables, boolean vertical) {
        this.gridTables = tables;
        this.vertical = vertical;
        this.init();
    }

    public IGridTable asGridTable() {
        return new GridTable(0, 0, this.height - 1, this.width - 1, this);
    }

    @Override
    public ICell getCell(int column, int row) {
        ICell delegate;
        Transform t;
        if (!this.vertical) {
            t = this.transform(0, 0);
            if (t == null) {
                return null;
            }
            delegate = t.grid().getCell(t.getCol(), t.getRow());
            if (row < delegate.getHeight()) {
                IGridRegion reg = this.getRegionContaining(0, 0);
                GridRegion region = null;
                region = reg != null ? new GridRegion(reg.getTop(), reg.getLeft(), reg.getBottom(), reg.getLeft() + this.getWidth() - 1) : new GridRegion(row, column, row, column + this.getWidth() - 1);
                return new CompositeCell(column, row, region, delegate);
            }
            Transform t1 = this.transform(0, delegate.getHeight());
            if (t1 != null) {
                Transform t2;
                ICell delegate1 = t1.grid().getCell(t1.getCol(), t1.getRow());
                if (row < delegate.getHeight() + delegate1.getHeight() && "properties".equals(delegate1.getStringValue()) && (t2 = this.transform(delegate1.getWidth(), row)) != null) {
                    ICell delegate2 = t2.grid().getCell(t2.getCol(), t2.getRow());
                    Transform t3 = this.transform(delegate1.getWidth() + delegate2.getWidth(), row);
                    if (t3 != null) {
                        ICell delegate3 = t3.grid().getCell(t3.getCol(), t3.getRow());
                        if (column >= delegate1.getWidth() + delegate2.getWidth()) {
                            IGridRegion reg = this.getRegionContaining(delegate1.getWidth() + delegate2.getWidth(), row);
                            GridRegion region = null;
                            region = reg != null ? new GridRegion(reg.getTop(), reg.getLeft(), reg.getBottom(), reg.getLeft() + this.getWidth() - 1 - (delegate1.getWidth() + delegate2.getWidth())) : new GridRegion(row, column, row, column + this.getWidth() - 1 - (delegate1.getWidth() + delegate2.getWidth()));
                            return new CompositeCell(column, row, region, delegate3);
                        }
                    }
                }
            }
        }
        if ((t = this.transform(column, row)) == null) {
            return null;
        }
        delegate = t.grid().getCell(t.getCol(), t.getRow());
        return new CompositeCell(column, row, this.getRegionContaining(column, row), delegate);
    }

    @Override
    public int getColumnWidth(int col) {
        Transform t = this.transform(col, 0);
        return t == null ? 100 : t.grid().getColumnWidth(t.getCol());
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxColumnIndex(int row) {
        return this.width - 1;
    }

    @Override
    public int getMaxRowIndex() {
        return this.height - 1;
    }

    @Override
    public IGridRegion getMergedRegion(int i) {
        return this.mergedRegions[i];
    }

    @Override
    public int getMinColumnIndex(int row) {
        return 0;
    }

    @Override
    public int getMinRowIndex() {
        return 0;
    }

    @Override
    public int getNumberOfMergedRegions() {
        return this.mergedRegions.length;
    }

    @Override
    public String getRangeUri(int colStart, int rowStart, int colEnd, int rowEnd) {
        Transform t1 = this.transform(colStart, rowStart);
        Transform t2 = this.transform(colEnd, rowEnd);
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1.grid() != t2.grid()) {
            for (int j = 0; j < this.gridTables.length; ++j) {
                if (this.gridTables[j].getGrid() != t2.grid()) continue;
                IGridRegion region = this.gridTables[j].getRegion();
                return t2.grid().getRangeUri(region.getLeft(), region.getTop(), region.getRight(), region.getBottom());
            }
        }
        return t1.grid().getRangeUri(t1.getCol(), t1.getRow(), t2.getCol(), t2.getRow());
    }

    @Override
    public String getUri() {
        Transform t = this.transform(0, 0);
        return t == null ? null : t.grid().getUri();
    }

    public int getWidth() {
        return this.width;
    }

    private void init() {
        this.initWidthAndHeight();
        this.initMappedRegions();
        this.initMergedRegions();
    }

    private void initMergedRegions() {
        ArrayList<GridRegion> mergedRegionsList = new ArrayList<GridRegion>();
        HashSet<IGrid> gridSet = this.getGridSet();
        for (IGrid grid : gridSet) {
            for (int i = 0; i < grid.getNumberOfMergedRegions(); ++i) {
                IGridRegion mergedRegion = grid.getMergedRegion(i);
                for (int j = 0; j < this.gridTables.length; ++j) {
                    IGridRegion tableRegion;
                    IGridRegion intersection;
                    if (this.gridTables[j].getGrid() != grid || (intersection = IGridRegion.Tool.intersect(mergedRegion, tableRegion = this.gridTables[j].getRegion())) == null) continue;
                    int dx = this.mappedRegions[j].getLeft() - tableRegion.getLeft();
                    int dy = this.mappedRegions[j].getTop() - tableRegion.getTop();
                    GridRegion moved = IGridRegion.Tool.move(intersection, dx, dy);
                    mergedRegionsList.add(moved);
                }
            }
        }
        this.mergedRegions = mergedRegionsList.toArray(new IGridRegion[0]);
    }

    private HashSet<IGrid> getGridSet() {
        HashSet<IGrid> gridSet = new HashSet<IGrid>();
        for (int i = 0; i < this.gridTables.length; ++i) {
            gridSet.add(this.gridTables[i].getGrid());
        }
        return gridSet;
    }

    private void initMappedRegions() {
        this.mappedRegions = new GridRegion[this.gridTables.length];
        int w = 0;
        int h = 0;
        for (int i = 0; i < this.gridTables.length; ++i) {
            int last;
            IGridRegion reg = this.gridTables[i].getRegion();
            GridRegion mapped = null;
            int n = last = i == this.gridTables.length - 1 ? 1 : 0;
            if (this.vertical) {
                int rh = IGridRegion.Tool.height(reg);
                mapped = new GridRegion(h, 0, h + rh - 1 + last, this.width);
                h += rh;
            } else {
                int rw = IGridRegion.Tool.width(reg);
                mapped = new GridRegion(0, w, this.height, w + rw - 1 + last);
                w += rw;
            }
            this.mappedRegions[i] = mapped;
        }
    }

    private void initWidthAndHeight() {
        for (int i = 0; i < this.gridTables.length; ++i) {
            IGridRegion reg = this.gridTables[i].getRegion();
            if (this.vertical) {
                this.height += IGridRegion.Tool.height(reg);
                this.width = Math.max(this.width, IGridRegion.Tool.width(reg));
                continue;
            }
            this.width += IGridRegion.Tool.width(reg);
            this.height = Math.max(this.height, IGridRegion.Tool.height(reg));
        }
    }

    @Override
    public boolean isEmpty(int col, int row) {
        Transform t = this.transform(col, row);
        return t == null || t.grid().isEmpty(t.getCol(), t.getRow());
    }

    private Transform transform(int col, int row) {
        for (int i = 0; i < this.mappedRegions.length; ++i) {
            if (!IGridRegion.Tool.contains(this.mappedRegions[i], col, row)) continue;
            IGridRegion reg = this.gridTables[i].getRegion();
            int transformedCol = reg.getLeft() + col - this.mappedRegions[i].getLeft();
            int transformedRow = reg.getTop() + row - this.mappedRegions[i].getTop();
            return new Transform(this.gridTables[i].getGrid(), transformedCol, transformedRow);
        }
        return null;
    }

    private static class Transform {
        private IGrid grid;
        private int col;
        private int row;

        public Transform(IGrid grid, int col, int row) {
            this.grid = grid;
            this.col = col;
            this.row = row;
        }

        public IGrid grid() {
            return this.grid;
        }

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }
    }
}

