/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.table.GridTable;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.RegionsPool;

public class GridSplitter {
    private List<IGridTable> tables = new ArrayList<IGridTable>();
    private RegionsPool pool = new RegionsPool(null);
    private IGrid grid;

    public GridSplitter(IGrid grid) {
        this.grid = grid;
    }

    boolean cellIsUsed(int col, int row) {
        return this.pool.getRegionContaining(col, row) != null;
    }

    boolean containsCell(int column, int row) {
        IGridRegion region;
        if (!this.grid.isEmpty(column, row)) {
            return true;
        }
        return this.grid.isPartOfTheMergedRegion(column, row) && !this.grid.isEmpty((region = this.grid.getRegionContaining(column, row)).getLeft(), region.getTop());
    }

    boolean containsRow(int scol, int ecol, int row) {
        for (int col = scol; col < ecol; ++col) {
            if (!this.containsCell(col, row)) continue;
            return true;
        }
        return false;
    }

    void defineTableBoundaries(int col, int row, int endX) {
        int stX = col;
        int x = endX;
        while (this.containsCell(x, row)) {
            ++x;
        }
        int y = row;
        while (this.containsRow(col, x, y)) {
            int newX = this.expandLeft(y, stX);
            if (newX < stX) {
                this.defineTableBoundaries(newX, row, x);
                return;
            }
            int newEndX = this.expandRight(y, x);
            if (newEndX > x) {
                this.defineTableBoundaries(stX, row, newEndX);
                return;
            }
            ++y;
        }
        GridTable table = new GridTable(row, stX, y - 1, x - 1, this.grid);
        this.tables.add(table);
        this.pool.add(table.getRegion());
    }

    private int expandLeft(int y, int stX) {
        int x = stX;
        while (x > 0) {
            if (!this.containsCell(x - 1, y)) {
                return x;
            }
            --x;
        }
        return 0;
    }

    private int expandRight(int y, int x) {
        while (this.containsCell(x, y)) {
            ++x;
        }
        return x;
    }

    public IGridTable[] split() {
        int nrows = this.grid.getMaxRowIndex() + 1;
        for (int row = this.grid.getMinRowIndex(); row < nrows; ++row) {
            int ncells = this.grid.getMaxColumnIndex(row) + 1;
            if (ncells == 0) continue;
            for (int col = this.grid.getMinColumnIndex(row); col < ncells; ++col) {
                if (this.cellIsUsed(col, row) || this.grid.isEmpty(col, row)) continue;
                this.defineTableBoundaries(col, row, col);
            }
        }
        return this.tables.toArray(new IGridTable[0]);
    }
}

