/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.GridTool;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.actions.GridRegionAction;
import org.openl.rules.table.actions.IUndoableGridTableAction;
import org.openl.rules.table.actions.UndoableInsertAction;

public class UndoableInsertRowsAction
extends UndoableInsertAction {
    private int nRows;
    private int beforeRow;
    private int col;

    public UndoableInsertRowsAction(int nRows, int beforeRow, int col, MetaInfoWriter metaInfoWriter) {
        super(metaInfoWriter);
        this.nRows = nRows;
        this.beforeRow = beforeRow;
        this.col = col;
    }

    public static boolean canInsertRows(IGridTable table, int nRows) {
        IGridTable[] allGridTables;
        IGridRegion region = UndoableInsertRowsAction.getOriginalRegion(table);
        GridRegion newRegion = new GridRegion(region.getBottom() + 1, region.getLeft() - 1, region.getBottom() + 1 + nRows, region.getRight() + 1);
        for (IGridTable allGridTable : allGridTables = table.getGrid().getTables()) {
            if (table.getUri().equals(allGridTable.getUri()) || !IGridRegion.Tool.intersects(newRegion, allGridTable.getRegion())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canPerformAction(IGridTable table) {
        return UndoableInsertRowsAction.canInsertRows(table, this.getNumberToInsert(table));
    }

    @Override
    protected GridRegionAction getGridRegionAction(IGridRegion gridRegion, int numberToInsert) {
        return new GridRegionAction(gridRegion, false, true, GridRegionAction.ActionType.EXPAND, numberToInsert);
    }

    @Override
    protected int getNumberToInsert(IGridTable table) {
        int cellHeight = UndoableInsertRowsAction.getOriginalTable(table).getCell(this.col, this.beforeRow).getHeight();
        int rowsToInsert = this.nRows;
        if (cellHeight > 1) {
            rowsToInsert += cellHeight - 1;
        }
        return rowsToInsert;
    }

    @Override
    protected IUndoableGridTableAction performAction(int numberToInsert, IGridRegion fullTableRegion, IGridTable table) {
        return GridTool.insertRows(numberToInsert, this.beforeRow, fullTableRegion, table.getGrid(), this.metaInfoWriter);
    }
}

