/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import org.openl.domain.EnumDomain;
import org.openl.domain.IDomain;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;

public class UndoableSetValueAction
extends AUndoableCellAction {
    private Object newValue;

    public UndoableSetValueAction(int col, int row, Object value, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.newValue = value;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICell cell = grid.getCell(this.getCol(), this.getRow());
        this.setPrevValue(cell.getObjectValue());
        this.setPrevFormula(cell.getFormula());
        this.setPrevMetaInfo(this.metaInfoWriter.getMetaInfo(this.getRow(), this.getCol()));
        grid.setCellValue(this.getCol(), this.getRow(), this.newValue);
        CellMetaInfo newMetaInfo = this.getNewMetaInfo(this.newValue);
        if (newMetaInfo != null) {
            this.metaInfoWriter.setMetaInfo(this.getRow(), this.getCol(), newMetaInfo);
        }
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        if (StringUtils.isNotBlank((CharSequence)this.getPrevFormula())) {
            grid.setCellFormula(this.getCol(), this.getRow(), this.getPrevFormula());
        } else {
            grid.setCellValue(this.getCol(), this.getRow(), this.getPrevValue());
        }
        this.metaInfoWriter.setMetaInfo(this.getRow(), this.getCol(), this.getPrevMetaInfo());
    }

    private CellMetaInfo getNewMetaInfo(Object value) {
        IOpenClass dataType;
        if (value == null) {
            return null;
        }
        CellMetaInfo prevMetaInfo = this.getPrevMetaInfo();
        JavaOpenClass newType = JavaOpenClass.getOpenClass(value.getClass());
        if (prevMetaInfo != null && prevMetaInfo.getDataType() != null && prevMetaInfo.getDataType().equals(newType)) {
            return this.removeNodeUsage(prevMetaInfo);
        }
        IOpenClass iOpenClass = dataType = prevMetaInfo == null ? null : prevMetaInfo.getDataType();
        if (dataType != null) {
            boolean keepOldMetaInfo;
            IDomain domain = dataType.getDomain();
            boolean bl = keepOldMetaInfo = domain instanceof EnumDomain || ClassUtils.isAssignable((Class)dataType.getInstanceClass(), INumberRange.class);
            if (keepOldMetaInfo) {
                return this.removeNodeUsage(prevMetaInfo);
            }
        }
        boolean multiValue = false;
        if (newType.getAggregateInfo().isAggregate((IOpenClass)newType)) {
            newType = newType.getAggregateInfo().getComponentType((IOpenClass)newType);
            multiValue = true;
        }
        return new CellMetaInfo((IOpenClass)newType, multiValue);
    }

    private CellMetaInfo removeNodeUsage(CellMetaInfo metaInfo) {
        return new CellMetaInfo(metaInfo.getDataType(), metaInfo.isMultiValue());
    }
}

