/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.constraints;

import org.openl.rules.table.constraints.AbstractConstraint;

public class LessThanConstraint
extends AbstractConstraint {
    public static final String CONSTRAINT_KEY = "<";
    public static final String CONSTRAINT_MATCH = "^\\s*([_a-zA-Z\\d\\$]+\\s*)?<\\s*[_a-zA-Z\\d\\$]+\\s*$";
    private Object[] params;

    public LessThanConstraint(String value) {
        super(value);
    }

    private Object[] parseParams() {
        String[] mathes = this.getValue().replaceAll("\\s", "").split(CONSTRAINT_KEY);
        if (mathes.length > 1) {
            return new String[]{mathes[1]};
        }
        return new String[0];
    }

    @Override
    public Object[] getParams() {
        if (this.params == null) {
            this.params = this.parseParams();
        }
        return this.params;
    }

    @Override
    public boolean check(Object ... valuesToCheck) {
        if (valuesToCheck.length > 1) {
            Object value1 = valuesToCheck[0];
            Object value2 = valuesToCheck[1];
            if (value1 instanceof Comparable && value2 instanceof Comparable) {
                int compareResult = ((Comparable)value1).compareTo(value2);
                return compareResult < 0;
            }
        }
        return false;
    }
}

