/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.util.Map;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.XlsSheetSourceCodeModule;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class PropertiesLoader {
    public static final String EXTERNAL_MODULE_PROPERTIES_KEY = "external-module-properties";
    private static final String PROPERTIES_SECTION_NAME = "Properties_Section";
    private OpenL openl;
    private RulesModuleBindingContext bindingContext;
    private XlsModuleOpenClass module;

    public PropertiesLoader(OpenL openl, RulesModuleBindingContext cxt, XlsModuleOpenClass module) {
        this.openl = openl;
        this.bindingContext = cxt;
        this.module = module;
    }

    private void loadPropertiesAsDataTable(TableSyntaxNode tableSyntaxNode) throws Exception {
        String propertySectionName = PROPERTIES_SECTION_NAME + tableSyntaxNode.getUri();
        DataNodeBinder dataNodeBinder = new DataNodeBinder();
        ITable propertyTable = this.module.getDataBase().registerTable(propertySectionName, tableSyntaxNode);
        JavaOpenClass propetiesClass = JavaOpenClass.getOpenClass(TableProperties.class);
        ILogicalTable propertiesSection = PropertiesHelper.getPropertiesTableSection(tableSyntaxNode.getTable());
        if (propertiesSection != null) {
            dataNodeBinder.processTable(this.module, propertyTable, propertiesSection, propertySectionName, (IOpenClass)propetiesClass, (IBindingContext)this.bindingContext, this.openl, false);
            TableProperties propertiesInstance = ((TableProperties[])propertyTable.getDataArray())[0];
            propertiesInstance.setPropertiesSection(propertiesSection);
            String tableType = tableSyntaxNode.getType();
            Set<String> propertyNamesToCheck = propertiesInstance.getTableProperties().keySet();
            PropertiesChecker.checkProperties((IBindingContext)this.bindingContext, propertyNamesToCheck, tableSyntaxNode, InheritanceLevel.TABLE);
            propertiesInstance.setCurrentTableType(tableType);
            tableSyntaxNode.setTableProperties(propertiesInstance);
        }
    }

    private void loadCategoryProperties(TableSyntaxNode tableSyntaxNode) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        String category = this.getCategory(tableSyntaxNode);
        TableSyntaxNode categoryPropertiesTsn = this.bindingContext.getTableSyntaxNode("Properties:Category:" + category);
        if (categoryPropertiesTsn != null) {
            ITableProperties categoryProperties = categoryPropertiesTsn.getTableProperties();
            tableProperties.setCategoryProperties(categoryProperties.getAllProperties());
            tableProperties.setCategoryPropertiesTableSyntaxNode(categoryPropertiesTsn);
        }
    }

    private String getCategory(TableSyntaxNode tsn) {
        ITableProperties tableProperties = tsn.getTableProperties();
        String category = tableProperties.getCategory();
        if (category != null) {
            return category;
        }
        return ((XlsSheetSourceCodeModule)tsn.getModule()).getSheetName();
    }

    private void loadModuleProperties(TableSyntaxNode tableSyntaxNode) {
        ITableProperties tableProperties = tableSyntaxNode.getTableProperties();
        TableSyntaxNode modulePropertiesTsn = this.bindingContext.getTableSyntaxNode("Properties:Module");
        if (tableProperties != null && modulePropertiesTsn != null) {
            ITableProperties moduleProperties = modulePropertiesTsn.getTableProperties();
            tableProperties.setModuleProperties(moduleProperties.getAllProperties());
            tableProperties.setModulePropertiesTableSyntaxNode(modulePropertiesTsn);
        }
    }

    public void loadDefaultProperties(TableSyntaxNode tableSyntaxNode) {
        if (tableSyntaxNode.getTableProperties() == null) {
            this.createTableProperties(tableSyntaxNode);
        }
        ITableProperties properties = tableSyntaxNode.getTableProperties();
        Map<String, Object> defaultProperties = TablePropertyDefinitionUtils.getPropertiesMapToBeSetByDefault();
        properties.setDefaultProperties(defaultProperties);
    }

    private void createTableProperties(TableSyntaxNode tableSyntaxNode) {
        TableProperties properties = new TableProperties();
        properties.setCurrentTableType(tableSyntaxNode.getType());
        tableSyntaxNode.setTableProperties(properties);
    }

    public void loadProperties(TableSyntaxNode tsn) throws Exception {
        String tableType = tsn.getType();
        if (!XlsNodeTypes.XLS_PROPERTIES.toString().equals(tableType)) {
            try {
                this.loadPropertiesAsDataTable(tsn);
                if (tsn.getTableProperties() == null) {
                    this.createTableProperties(tsn);
                }
            }
            catch (Exception ex) {
                this.createTableProperties(tsn);
                throw ex;
            }
            this.loadExternalProperties(tsn);
            this.loadCategoryProperties(tsn);
            this.loadModuleProperties(tsn);
            this.loadDefaultProperties(tsn);
        }
    }

    private void loadExternalProperties(TableSyntaxNode tsn) {
        Map externalParams;
        ITableProperties tableProperties = tsn.getTableProperties();
        TableSyntaxNode modulePropertiesTsn = this.bindingContext.getTableSyntaxNode("Properties:Module");
        ITableProperties moduleProperties = null;
        if (tableProperties != null && modulePropertiesTsn != null) {
            moduleProperties = modulePropertiesTsn.getTableProperties();
        }
        if ((externalParams = this.bindingContext.getExternalParams()) != null && externalParams.containsKey(EXTERNAL_MODULE_PROPERTIES_KEY) && externalParams.get(EXTERNAL_MODULE_PROPERTIES_KEY) instanceof ITableProperties) {
            if (tsn.getTableProperties() == null) {
                this.createTableProperties(tsn);
            }
            ITableProperties properties = tsn.getTableProperties();
            ITableProperties externalProperties = (ITableProperties)externalParams.get(EXTERNAL_MODULE_PROPERTIES_KEY);
            if (moduleProperties != null) {
                for (String key : externalProperties.getAllProperties().keySet()) {
                    if (!moduleProperties.getAllProperties().keySet().contains(key)) continue;
                    this.bindingContext.addMessage(OpenLMessagesUtils.newErrorMessage((String)("Property '" + key + "' has already defined via external properties! Remove it from module properties.")));
                }
            }
            properties.setExternalProperties(externalProperties.getAllProperties());
        }
    }
}

