/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openl.rules.enumeration.CaProvincesEnum;
import org.openl.rules.enumeration.CaRegionsEnum;
import org.openl.rules.enumeration.CountriesEnum;
import org.openl.rules.enumeration.CurrenciesEnum;
import org.openl.rules.enumeration.LanguagesEnum;
import org.openl.rules.enumeration.OriginsEnum;
import org.openl.rules.enumeration.RecalculateEnum;
import org.openl.rules.enumeration.RegionsEnum;
import org.openl.rules.enumeration.UsRegionsEnum;
import org.openl.rules.enumeration.UsStatesEnum;
import org.openl.rules.enumeration.ValidateDTEnum;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DynamicObject;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.EnumUtils;
import org.openl.util.StringUtils;

public class TableProperties
extends DynamicObject
implements ITableProperties {
    private String currentTableType;
    private ILogicalTable propertySection;
    private TableSyntaxNode modulePropertiesTableSyntaxNode;
    private TableSyntaxNode categoryPropertiesTableSyntaxNode;
    private Map<String, Object> categoryProperties = Collections.emptyMap();
    private Map<String, Object> externalModuleProperties = Collections.emptyMap();
    private Map<String, Object> moduleProperties = Collections.emptyMap();
    private Map<String, Object> defaultProperties = Collections.emptyMap();
    private Map<String, Object> allProperties = null;
    private Map<String, Object> allDimensionalProperties = null;

    private Map<String, Object> mergeLevelProperties(Map<String, Object> downLevelProperties, Map<String, Object> upLevelProperties) {
        Map<String, Object> resultProperties = downLevelProperties;
        for (Map.Entry<String, Object> upLevelProperty : upLevelProperties.entrySet()) {
            String upLevelPropertyName = upLevelProperty.getKey();
            Object upLevelPropertyValue = upLevelProperty.getValue();
            if (!PropertiesChecker.isPropertySuitableForTableType(upLevelPropertyName, this.currentTableType) || downLevelProperties.containsKey(upLevelPropertyName)) continue;
            resultProperties.put(upLevelPropertyName, upLevelPropertyValue);
        }
        return resultProperties;
    }

    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.getClass());
    }

    public void setType(IOpenClass type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    @Override
    public void setName(String name) {
        this.setFieldValue("name", name);
        this.reset();
    }

    @Override
    public String getCategory() {
        return (String)this.getPropertyValue("category");
    }

    @Override
    public void setCategory(String category) {
        this.setFieldValue("category", category);
        this.reset();
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("createdBy");
    }

    @Override
    public void setCreatedBy(String createdBy) {
        this.setFieldValue("createdBy", createdBy);
        this.reset();
    }

    @Override
    public Date getCreatedOn() {
        return (Date)this.getPropertyValue("createdOn");
    }

    @Override
    public void setCreatedOn(Date createdOn) {
        this.setFieldValue("createdOn", createdOn);
        this.reset();
    }

    @Override
    public String getModifiedBy() {
        return (String)this.getPropertyValue("modifiedBy");
    }

    @Override
    public void setModifiedBy(String modifiedBy) {
        this.setFieldValue("modifiedBy", modifiedBy);
        this.reset();
    }

    @Override
    public Date getModifiedOn() {
        return (Date)this.getPropertyValue("modifiedOn");
    }

    @Override
    public void setModifiedOn(Date modifiedOn) {
        this.setFieldValue("modifiedOn", modifiedOn);
        this.reset();
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("description");
    }

    @Override
    public void setDescription(String description) {
        this.setFieldValue("description", description);
        this.reset();
    }

    @Override
    public String[] getTags() {
        return (String[])this.getPropertyValue("tags");
    }

    @Override
    public void setTags(String ... tags) {
        this.setFieldValue("tags", tags);
        this.reset();
    }

    @Override
    public Date getEffectiveDate() {
        return (Date)this.getPropertyValue("effectiveDate");
    }

    @Override
    public void setEffectiveDate(Date effectiveDate) {
        this.setFieldValue("effectiveDate", effectiveDate);
        this.reset();
    }

    @Override
    public Date getExpirationDate() {
        return (Date)this.getPropertyValue("expirationDate");
    }

    @Override
    public void setExpirationDate(Date expirationDate) {
        this.setFieldValue("expirationDate", expirationDate);
        this.reset();
    }

    @Override
    public Date getStartRequestDate() {
        return (Date)this.getPropertyValue("startRequestDate");
    }

    @Override
    public void setStartRequestDate(Date startRequestDate) {
        this.setFieldValue("startRequestDate", startRequestDate);
        this.reset();
    }

    @Override
    public Date getEndRequestDate() {
        return (Date)this.getPropertyValue("endRequestDate");
    }

    @Override
    public void setEndRequestDate(Date endRequestDate) {
        this.setFieldValue("endRequestDate", endRequestDate);
        this.reset();
    }

    @Override
    public CaRegionsEnum[] getCaRegions() {
        return (CaRegionsEnum[])this.getPropertyValue("caRegions");
    }

    @Override
    public void setCaRegions(CaRegionsEnum ... caRegions) {
        this.setFieldValue("caRegions", caRegions);
        this.reset();
    }

    @Override
    public CaProvincesEnum[] getCaProvinces() {
        return (CaProvincesEnum[])this.getPropertyValue("caProvinces");
    }

    @Override
    public void setCaProvinces(CaProvincesEnum ... caProvinces) {
        this.setFieldValue("caProvinces", caProvinces);
        this.reset();
    }

    @Override
    public CountriesEnum[] getCountry() {
        return (CountriesEnum[])this.getPropertyValue("country");
    }

    @Override
    public void setCountry(CountriesEnum ... country) {
        this.setFieldValue("country", country);
        this.reset();
    }

    @Override
    public RegionsEnum[] getRegion() {
        return (RegionsEnum[])this.getPropertyValue("region");
    }

    @Override
    public void setRegion(RegionsEnum ... region) {
        this.setFieldValue("region", region);
        this.reset();
    }

    @Override
    public CurrenciesEnum[] getCurrency() {
        return (CurrenciesEnum[])this.getPropertyValue("currency");
    }

    @Override
    public void setCurrency(CurrenciesEnum ... currency) {
        this.setFieldValue("currency", currency);
        this.reset();
    }

    @Override
    public LanguagesEnum[] getLang() {
        return (LanguagesEnum[])this.getPropertyValue("lang");
    }

    @Override
    public void setLang(LanguagesEnum ... lang) {
        this.setFieldValue("lang", lang);
        this.reset();
    }

    @Override
    public String[] getLob() {
        return (String[])this.getPropertyValue("lob");
    }

    @Override
    public void setLob(String ... lob) {
        this.setFieldValue("lob", lob);
        this.reset();
    }

    @Override
    public OriginsEnum getOrigin() {
        return (OriginsEnum)((Object)this.getPropertyValue("origin"));
    }

    @Override
    public void setOrigin(OriginsEnum origin) {
        this.setFieldValue("origin", (Object)origin);
        this.reset();
    }

    @Override
    public UsRegionsEnum[] getUsregion() {
        return (UsRegionsEnum[])this.getPropertyValue("usregion");
    }

    @Override
    public void setUsregion(UsRegionsEnum ... usregion) {
        this.setFieldValue("usregion", usregion);
        this.reset();
    }

    @Override
    public UsStatesEnum[] getState() {
        return (UsStatesEnum[])this.getPropertyValue("state");
    }

    @Override
    public void setState(UsStatesEnum ... state) {
        this.setFieldValue("state", state);
        this.reset();
    }

    @Override
    public String getVersion() {
        return (String)this.getPropertyValue("version");
    }

    @Override
    public void setVersion(String version) {
        this.setFieldValue("version", version);
        this.reset();
    }

    @Override
    public Boolean getActive() {
        return (Boolean)this.getPropertyValue("active");
    }

    @Override
    public void setActive(Boolean active) {
        this.setFieldValue("active", active);
        this.reset();
    }

    @Override
    public String getId() {
        return (String)this.getPropertyValue("id");
    }

    @Override
    public void setId(String id) {
        this.setFieldValue("id", id);
        this.reset();
    }

    @Override
    public String getBuildPhase() {
        return (String)this.getPropertyValue("buildPhase");
    }

    @Override
    public void setBuildPhase(String buildPhase) {
        this.setFieldValue("buildPhase", buildPhase);
        this.reset();
    }

    @Override
    public ValidateDTEnum getValidateDT() {
        return (ValidateDTEnum)((Object)this.getPropertyValue("validateDT"));
    }

    @Override
    public void setValidateDT(ValidateDTEnum validateDT) {
        this.setFieldValue("validateDT", (Object)validateDT);
        this.reset();
    }

    @Override
    public Boolean getFailOnMiss() {
        return (Boolean)this.getPropertyValue("failOnMiss");
    }

    @Override
    public void setFailOnMiss(Boolean failOnMiss) {
        this.setFieldValue("failOnMiss", failOnMiss);
        this.reset();
    }

    @Override
    public String getScope() {
        return (String)this.getPropertyValue("scope");
    }

    @Override
    public void setScope(String scope) {
        this.setFieldValue("scope", scope);
        this.reset();
    }

    @Override
    public String getDatatypePackage() {
        return (String)this.getPropertyValue("datatypePackage");
    }

    @Override
    public void setDatatypePackage(String datatypePackage) {
        this.setFieldValue("datatypePackage", datatypePackage);
        this.reset();
    }

    @Override
    public Boolean getCacheable() {
        return (Boolean)this.getPropertyValue("cacheable");
    }

    @Override
    public void setCacheable(Boolean cacheable) {
        this.setFieldValue("cacheable", cacheable);
        this.reset();
    }

    @Override
    public RecalculateEnum getRecalculate() {
        return (RecalculateEnum)((Object)this.getPropertyValue("recalculate"));
    }

    @Override
    public void setRecalculate(RecalculateEnum recalculate) {
        this.setFieldValue("recalculate", (Object)recalculate);
        this.reset();
    }

    @Override
    public String getPrecision() {
        return (String)this.getPropertyValue("precision");
    }

    @Override
    public void setPrecision(String precision) {
        this.setFieldValue("precision", precision);
        this.reset();
    }

    @Override
    public Boolean getAutoType() {
        return (Boolean)this.getPropertyValue("autoType");
    }

    @Override
    public void setAutoType(Boolean autoType) {
        this.setFieldValue("autoType", autoType);
        this.reset();
    }

    @Override
    public Boolean getCalculateAllCells() {
        return (Boolean)this.getPropertyValue("calculateAllCells");
    }

    @Override
    public void setCalculateAllCells(Boolean calculateAllCells) {
        this.setFieldValue("calculateAllCells", calculateAllCells);
        this.reset();
    }

    @Override
    public Boolean getParallel() {
        return (Boolean)this.getPropertyValue("parallel");
    }

    @Override
    public void setParallel(Boolean parallel) {
        this.setFieldValue("parallel", parallel);
        this.reset();
    }

    @Override
    public String getNature() {
        return (String)this.getPropertyValue("nature");
    }

    @Override
    public void setNature(String nature) {
        this.setFieldValue("nature", nature);
        this.reset();
    }

    @Override
    public Object getPropertyValue(String key) {
        return this.getAllProperties().get(key);
    }

    @Override
    public String getPropertyValueAsString(String key) {
        String result = null;
        Object propValue = this.getPropertyValue(key);
        if (propValue != null) {
            if (propValue instanceof Date) {
                String format = TablePropertyDefinitionUtils.getPropertyByName(key).getFormat();
                if (format != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    result = dateFormat.format((Date)propValue);
                }
            } else if (EnumUtils.isEnum((Object)propValue)) {
                result = ((Enum)propValue).name();
            } else if (EnumUtils.isEnumArray((Object)propValue)) {
                Object[] enums = (Object[])propValue;
                if (!ArrayTool.isEmpty((Object[])enums)) {
                    Object[] names = EnumUtils.getNames((Object[])enums);
                    result = StringUtils.join((Object[])names, (String)",");
                } else {
                    result = "";
                }
            } else {
                Object[] array;
                result = propValue.getClass().isArray() ? (!ArrayTool.isEmpty((Object[])(array = (Object[])propValue)) ? StringUtils.join((Object[])array, (String)",") : "") : propValue.toString();
            }
        }
        return result;
    }

    @Override
    public InheritanceLevel getPropertyLevelDefinedOn(String propertyName) {
        InheritanceLevel result = null;
        if (this.getTableProperties().containsKey(propertyName)) {
            result = InheritanceLevel.TABLE;
        } else if (this.getCategoryProperties().containsKey(propertyName)) {
            result = InheritanceLevel.CATEGORY;
        } else if (this.getModuleProperties().containsKey(propertyName)) {
            result = InheritanceLevel.MODULE;
        } else if (this.getExternalProperties().containsKey(propertyName)) {
            result = InheritanceLevel.EXTERNAL;
        }
        return result;
    }

    @Override
    public boolean isPropertyAppliedByDefault(String propertyName) {
        boolean result = false;
        if (this.getPropertyLevelDefinedOn(propertyName) == null && this.defaultProperties.containsKey(propertyName)) {
            result = true;
        }
        return result;
    }

    @Override
    public ILogicalTable getPropertiesSection() {
        return this.propertySection;
    }

    @Override
    public void setPropertiesSection(ILogicalTable propertySection) {
        this.propertySection = propertySection;
    }

    @Override
    public TableSyntaxNode getModulePropertiesTableSyntaxNode() {
        return this.modulePropertiesTableSyntaxNode;
    }

    @Override
    public void setModulePropertiesTableSyntaxNode(TableSyntaxNode modulePropertiesTableSyntaxNode) {
        this.modulePropertiesTableSyntaxNode = modulePropertiesTableSyntaxNode;
    }

    @Override
    public TableSyntaxNode getCategoryPropertiesTableSyntaxNode() {
        return this.categoryPropertiesTableSyntaxNode;
    }

    @Override
    public void setCategoryPropertiesTableSyntaxNode(TableSyntaxNode categoryPropertiesTableSyntaxNode) {
        this.categoryPropertiesTableSyntaxNode = categoryPropertiesTableSyntaxNode;
    }

    @Override
    public TableSyntaxNode getInheritedPropertiesTableSyntaxNode(InheritanceLevel inheritanceLevel) {
        if (InheritanceLevel.MODULE.equals((Object)inheritanceLevel)) {
            return this.modulePropertiesTableSyntaxNode;
        }
        if (InheritanceLevel.CATEGORY.equals((Object)inheritanceLevel)) {
            return this.categoryPropertiesTableSyntaxNode;
        }
        return null;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        if (this.allProperties != null) {
            return this.allProperties;
        }
        Map<String, Object> tableAndCategoryProp = this.mergeLevelProperties(super.getFieldValues(), this.categoryProperties);
        Map<String, Object> tableAndCategoryAndModuleProp = this.mergeLevelProperties(tableAndCategoryProp, this.moduleProperties);
        Map<String, Object> tableAndCategoryAndModuleAndExteranlProp = this.mergeLevelProperties(tableAndCategoryAndModuleProp, this.externalModuleProperties);
        Map<String, Object> allTableProperties = this.mergeLevelProperties(tableAndCategoryAndModuleAndExteranlProp, this.defaultProperties);
        this.allProperties = Collections.unmodifiableMap(allTableProperties);
        return this.allProperties;
    }

    public void setFieldValue(String name, Object value) {
        super.setFieldValue(name, this.toPropertyValue(value));
    }

    private Object toPropertyValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            Object[] value1 = (Object[])((Object[])value).clone();
            Arrays.sort(value1);
            return value1;
        }
        if (value instanceof Date) {
            return ((Date)value).clone();
        }
        return value;
    }

    @Override
    public Map<String, Object> getTableProperties() {
        return super.getFieldValues();
    }

    @Override
    public Map<String, Object> getAllDimensionalProperties() {
        if (this.allDimensionalProperties == null) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            Map<String, Object> props = this.getAllProperties();
            for (Map.Entry<String, Object> property : props.entrySet()) {
                String propName = property.getKey();
                TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propName);
                if (!propertyDefinition.isDimensional()) continue;
                tmp.put(propName, property.getValue());
            }
            this.allDimensionalProperties = Collections.unmodifiableMap(tmp);
        }
        return this.allDimensionalProperties;
    }

    private void reset() {
        this.allProperties = null;
        this.allDimensionalProperties = null;
    }

    @Override
    public void setCategoryProperties(Map<String, Object> categoryProperties) {
        this.categoryProperties = categoryProperties == null ? Collections.emptyMap() : this.extractPropertiesMap(categoryProperties);
        this.reset();
    }

    @Override
    public Map<String, Object> getCategoryProperties() {
        return this.categoryProperties;
    }

    @Override
    public void setModuleProperties(Map<String, Object> moduleProperties) {
        this.moduleProperties = moduleProperties == null ? Collections.emptyMap() : this.extractPropertiesMap(moduleProperties);
        this.reset();
    }

    @Override
    public Map<String, Object> getModuleProperties() {
        return this.moduleProperties;
    }

    @Override
    public void setDefaultProperties(Map<String, Object> defaultProperties) {
        this.defaultProperties = defaultProperties == null ? Collections.emptyMap() : Collections.unmodifiableMap(defaultProperties);
        this.reset();
    }

    @Override
    public Map<String, Object> getDefaultProperties() {
        return this.defaultProperties;
    }

    @Override
    public void setCurrentTableType(String currentTableType) {
        this.currentTableType = currentTableType;
    }

    @Override
    public String getCurrentTableType() {
        return this.currentTableType;
    }

    @Override
    public Map<String, Object> getExternalProperties() {
        return this.externalModuleProperties;
    }

    @Override
    public void setExternalProperties(Map<String, Object> externalProperties) {
        this.externalModuleProperties = externalProperties == null ? Collections.emptyMap() : this.extractPropertiesMap(externalProperties);
        this.reset();
    }

    private Map<String, Object> extractPropertiesMap(Map<String, Object> externalProperties) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : externalProperties.entrySet()) {
            tmp.put(entry.getKey(), this.toPropertyValue(entry.getValue()));
        }
        return Collections.unmodifiableMap(tmp);
    }

    @Override
    public boolean isPropertiesEmpty() {
        Set<String> keys = this.getAllProperties().keySet();
        for (String key : keys) {
            if (this.getAllProperties().get(key) == null) continue;
            return false;
        }
        return true;
    }
}

