/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;
import org.openl.util.StringUtils;

public class DatatypeAliasTableBuilder
extends TableBuilder {
    public static final int MIN_WIDTH = 1;

    public DatatypeAliasTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    public void beginTable(int height) throws CreateTableException {
        super.beginTable(1, height);
    }

    public void writeHeader(String tableName, String aliasType, ICellStyle style) {
        String header = "Datatype";
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            header = header + " " + tableName;
        }
        if (StringUtils.isNotBlank((CharSequence)aliasType)) {
            header = header + " <" + aliasType + ">";
        }
        super.writeHeader(header, style);
    }

    public void writeHeader(String tableName, String aliasType) {
        this.writeHeader(tableName, aliasType, null);
    }

    @Override
    public void writeHeader(String header, ICellStyle style) {
        this.writeHeader(header, null, style);
    }

    public void writeValue(String value, ICellStyle cellStyle) {
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        this.writeCell(0, this.getCurrentRow(), 1, 1, value, cellStyle);
        this.incCurrentRow();
    }

    public void writeValue(String value) {
        this.writeValue(value, null);
    }
}

