/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls.builder;

import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.builder.CreateTableException;
import org.openl.rules.table.xls.builder.TableBuilder;

public class DecisionTableBuilder
extends TableBuilder {
    public static final int LOGIC_ELEMENT_HEIGHT = 4;
    private int elementColumn;

    public DecisionTableBuilder(XlsSheetGridModel gridModel) {
        super(gridModel);
    }

    @Override
    public void beginTable(int width, int height) throws CreateTableException {
        super.beginTable(width, height);
        this.elementColumn = 0;
    }

    @Override
    public void endTable() throws CreateTableException {
        if (this.elementColumn > 0) {
            this.incCurrentRow(4);
        }
        super.endTable();
    }

    public void writeElement(String title, String logic, String[] parameterNames, String[] parameterSignatures) {
        if (this.getTableRegion() == null) {
            throw new IllegalStateException("beginTable() has to be called");
        }
        if (parameterNames == null || parameterNames.length == 0) {
            throw new IllegalArgumentException("parameterNames must be not null array of positive length");
        }
        if (parameterSignatures == null || parameterSignatures.length == 0) {
            throw new IllegalArgumentException("parameterSignatures must be not null array of positive length");
        }
        if (parameterSignatures.length != parameterNames.length) {
            throw new IllegalArgumentException("numbers of parameter names and parameter signatures must be equal");
        }
        int elementWidth = parameterNames.length;
        if (this.elementColumn + elementWidth > this.getHeight()) {
            throw new IllegalStateException("total elements width is too big, expected height = " + this.getHeight());
        }
        this.writeCell(this.elementColumn, this.getCurrentRow(), elementWidth, 1, title);
        this.writeCell(this.elementColumn, this.getCurrentRow() + 1, elementWidth, 1, logic);
        for (int i = 0; i < elementWidth; ++i) {
            this.writeCell(this.elementColumn + i, this.getCurrentRow() + 2, 1, 1, parameterSignatures[i]);
            this.writeCell(this.elementColumn + i, this.getCurrentRow() + 3, 1, 1, parameterNames[i]);
        }
        this.elementColumn += elementWidth;
    }

    public void writeHeader(String signature) {
        String headerText = "Rules " + signature;
        super.writeHeader(headerText, null);
    }
}

