/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.lang.reflect.Constructor;
import java.util.List;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.AlgorithmOperationSource;
import org.openl.rules.tbasic.compile.ConversionRuleStep;
import org.openl.rules.tbasic.compile.ParameterConverterManager;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;

public class OperationFactory {
    private static final String OPERATIONS_PACKAGE = "org.openl.rules.tbasic.runtime.operations";
    private static final String OPERATION_SUFFIX = "Operation";
    private ParameterConverterManager parameterConverter;

    public OperationFactory(ParameterConverterManager parameterConverter) {
        this.parameterConverter = parameterConverter;
    }

    public RuntimeOperation createOperation(List<AlgorithmTreeNode> nodesToCompile, ConversionRuleStep conversionStep) throws Exception {
        Constructor<?> constructor = this.getOperationConstructor(conversionStep.getOperationType());
        Object[] params = new Object[constructor.getParameterTypes().length];
        if (constructor.getParameterTypes().length > 0) {
            params[0] = this.parameterConverter.convertParam(nodesToCompile, constructor.getParameterTypes()[0], conversionStep.getOperationParam1());
        }
        if (constructor.getParameterTypes().length > 1) {
            params[1] = this.parameterConverter.convertParam(nodesToCompile, constructor.getParameterTypes()[1], conversionStep.getOperationParam2());
        }
        RuntimeOperation emittedOperation = (RuntimeOperation)constructor.newInstance(params);
        AlgorithmOperationSource source = AlgorithmCompilerTool.getOperationSource(nodesToCompile, conversionStep.getOperationParam1());
        emittedOperation.setSourceCode(source);
        String nameForDebug = conversionStep.getNameForDebug();
        emittedOperation.setNameForDebug(nameForDebug);
        return emittedOperation;
    }

    private Constructor<?> getOperationConstructor(String operationType) throws ClassNotFoundException {
        String operationClassName = String.format("%s.%s%s", OPERATIONS_PACKAGE, operationType, OPERATION_SUFFIX);
        Class<?> clazz = Class.forName(operationClassName);
        return clazz.getConstructors()[0];
    }
}

