/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime;

import java.lang.reflect.InvocationTargetException;
import org.openl.rules.tbasic.runtime.OpenLAlgorithmExecutionException;
import org.openl.rules.tbasic.runtime.TBasicContextHolderEnv;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

class AlgorithmErrorHelper {
    private AlgorithmErrorHelper() {
    }

    public static OpenLAlgorithmExecutionException createExecutionException(String message, RuntimeOperation operation) {
        String sourceOperationUrl = operation.getSourceCode().getSourceUri();
        String errorMessage = String.format("Unexpected error appeared while executing TBasic component logic. It's unusal situation and the most propably something is wrong in component's internal logic, please contact developers. Error: %s at %s", message, sourceOperationUrl);
        return new OpenLAlgorithmExecutionException(errorMessage);
    }

    public static Object processError(Throwable error, TBasicContextHolderEnv environment) {
        IOpenClass algorithmType = environment.getTbasicTarget().getType();
        IOpenMethod errorMethod = algorithmType.getMethod("ON ERROR", new IOpenClass[0]);
        if (errorMethod != null) {
            IOpenField errorField = algorithmType.getField("ERROR");
            if (errorField != null) {
                Throwable err = ((InvocationTargetException)error.getCause().getCause()).getTargetException();
                errorField.set((Object)environment.getTbasicTarget(), (Object)err, (IRuntimeEnv)environment);
                IOpenField errorMessageField = algorithmType.getField("Error Message");
                errorMessageField.set((Object)environment.getTbasicTarget(), (Object)err.getMessage(), (IRuntimeEnv)environment);
            }
            return errorMethod.invoke((Object)environment.getTbasicTarget(), null, (IRuntimeEnv)environment);
        }
        throw RuntimeExceptionWrapper.wrap((Throwable)error);
    }
}

