/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.message.OpenLMessage;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ITable;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DataTableMetaInfoReader;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestMethodOpenClass;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;

public class TestMethodNodeBinder
extends DataNodeBinder {
    private static final int TESTED_METHOD_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;
    private static final AtomicInteger counter = new AtomicInteger();

    @Override
    protected ATableBoundNode makeNode(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, IBindingContext bindingContext) {
        TestMethodBoundNode boundNode = new TestMethodBoundNode(tableSyntaxNode, module);
        if (!bindingContext.isExecutionMode()) {
            tableSyntaxNode.setMetaInfoReader(new DataTableMetaInfoReader(boundNode));
        }
        return boundNode;
    }

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        if (bindingContext.isExecutionMode()) {
            return null;
        }
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        if (parsedHeader.length < 2) {
            throw SyntaxNodeExceptionUtils.createError((String)"Test table format: Test <methodname> <testname>", (IOpenSourceCodeModule)source);
        }
        String methodName = parsedHeader[1].getIdentifier();
        String tableName = parsedHeader.length == 2 ? methodName + "$" + parsedHeader[0].getIdentifier() + "$" + counter.getAndIncrement() : parsedHeader[2].getIdentifier();
        List testedMethods = CollectionUtils.findAll((Iterable)module.getMethods(), e -> methodName.equals(e.getName()));
        if (testedMethods.isEmpty()) {
            throw new MethodNotFoundException(methodName, new IOpenClass[0]);
        }
        OpenMethodHeader header = new OpenMethodHeader(tableName, (IOpenClass)JavaOpenClass.getOpenClass(TestUnitsResults.class), IMethodSignature.VOID, (IOpenClass)module);
        int i = 0;
        DataTableBoundNode bestCaseTestMethodBoundNode = null;
        IOpenMethod bestCaseOpenMethod = null;
        SyntaxNodeException[] bestCaseErrors = null;
        TestMethodOpenClass bestTestMethodOpenClass = null;
        ITable bestDataTable = null;
        boolean hasNoErrorBinding = false;
        SyntaxNodeException[] errors = tableSyntaxNode.getErrors();
        Collection bestMessages = null;
        SyntaxNodeException[] bestBindingContextErrors = null;
        for (IOpenMethod testedMethod : testedMethods) {
            tableSyntaxNode.clearErrors();
            if (errors != null) {
                for (SyntaxNodeException error : errors) {
                    tableSyntaxNode.addError(error);
                }
            }
            TestMethodBoundNode testMethodBoundNode = (TestMethodBoundNode)this.makeNode(tableSyntaxNode, module, bindingContext);
            TestSuiteMethod testSuite = new TestSuiteMethod(testedMethod, (IOpenMethodHeader)header, testMethodBoundNode);
            testMethodBoundNode.setTestSuite(testSuite);
            TestMethodOpenClass testMethodOpenClass = new TestMethodOpenClass(tableName, testedMethod);
            if (testMethodOpenClass.getInstanceClass() == null) {
                String message = String.format("Table '%s' was defined with errors", methodName);
                throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
            }
            try {
                bindingContext.pushErrors();
                bindingContext.pushMessages();
                ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, (IOpenClass)testMethodOpenClass, bindingContext, openl, false);
                testMethodBoundNode.setTable(dataTable);
                if (testMethodBoundNode.getTableSyntaxNode().hasErrors() && (bestCaseErrors == null || bestCaseErrors.length > testMethodBoundNode.getTableSyntaxNode().getErrors().length)) {
                    bestCaseErrors = testMethodBoundNode.getTableSyntaxNode().getErrors();
                    bestCaseTestMethodBoundNode = testMethodBoundNode;
                    bestCaseOpenMethod = testedMethod;
                    bestTestMethodOpenClass = testMethodOpenClass;
                    bestDataTable = dataTable;
                    bestMessages = bindingContext.getMessages();
                    bestBindingContextErrors = bindingContext.getErrors();
                    continue;
                }
                if (testMethodBoundNode.getTableSyntaxNode().hasErrors()) continue;
                if (hasNoErrorBinding) {
                    ArrayList<IOpenMethod> list = new ArrayList<IOpenMethod>();
                    list.add(testedMethod);
                    list.add(bestCaseOpenMethod);
                    throw new AmbiguousMethodException(tableName, IOpenClass.EMPTY, list);
                }
                bestCaseTestMethodBoundNode = testMethodBoundNode;
                bestCaseOpenMethod = testedMethod;
                bestTestMethodOpenClass = testMethodOpenClass;
                hasNoErrorBinding = true;
                bestDataTable = dataTable;
                bestMessages = bindingContext.getMessages();
                bestBindingContextErrors = bindingContext.getErrors();
                bestCaseErrors = new SyntaxNodeException[]{};
            }
            catch (AmbiguousMethodException e2) {
                throw e2;
            }
            catch (Exception e3) {
                if (i < testedMethods.size() - 1) continue;
                throw e3;
            }
            finally {
                bindingContext.popErrors();
                bindingContext.popMessages();
            }
        }
        if (bestCaseTestMethodBoundNode != null) {
            tableSyntaxNode.clearErrors();
            if (errors != null) {
                for (SyntaxNodeException error : errors) {
                    tableSyntaxNode.addError(error);
                }
            }
            bestCaseTestMethodBoundNode.setTable(bestDataTable);
            DataNodeBinder.putSubTableForBussinesView(tableSyntaxNode, bestTestMethodOpenClass);
            for (SyntaxNodeException error : bestCaseErrors) {
                tableSyntaxNode.addError(error);
            }
            for (OpenLMessage message : bestMessages) {
                bindingContext.addMessage(message);
            }
            for (SyntaxNodeException syntaxNodeException : bestBindingContextErrors) {
                bindingContext.addError(syntaxNodeException);
            }
            if (bindingContext.isExecutionMode() && ((TableSyntaxNode)bestCaseTestMethodBoundNode.getSyntaxNode()).hasErrors()) {
                return null;
            }
            return bestCaseTestMethodBoundNode;
        }
        String message = String.format("Table '%s' is not found", methodName);
        throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
    }

    @Override
    protected ColumnDescriptor[] makeDescriptors(ITable tableToProcess, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow, ILogicalTable horizDataTableBody, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows) throws Exception {
        return DataTableBindHelper.makeDescriptors(bindingContext, tableToProcess, tableType, openl, descriptorRows, dataWithTitleRows, DataTableBindHelper.hasForeignKeysRow(horizDataTableBody), hasColumnTitleRow, false);
    }
}

