/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.testmethod.ITestResultBuilder;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.TestDescription;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

public class TestRunner {
    private final ITestResultBuilder resultBuilder;

    public TestRunner(ITestResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITestUnit runTest(TestDescription test, Object target, IRuntimeEnv env, OpenLArgumentsCloner cloner, long ntimes) {
        long end;
        if (ntimes <= 0L) {
            return this.runTest(test, target, env, cloner, 1L);
        }
        Object res = null;
        Throwable exception = null;
        IRuntimeContext oldContext = env.getContext();
        long start = System.nanoTime();
        try {
            IRulesRuntimeContext context = test.getRuntimeContext(cloner);
            env.setContext((IRuntimeContext)context);
            Object[] args = test.getArguments(cloner);
            IOpenMethod testedMethod = test.getTestedMethod();
            start = System.nanoTime();
            int j = 0;
            while ((long)j < ntimes) {
                res = testedMethod.invoke(target, args, env);
                ++j;
            }
            end = System.nanoTime();
        }
        catch (Throwable t) {
            end = System.nanoTime();
            exception = t;
        }
        finally {
            env.setContext(oldContext);
        }
        long time = end - start;
        return this.resultBuilder.build(test, res, exception, time);
    }
}

