/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.openl.base.INamedThing;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestRunner;
import org.openl.rules.testmethod.TestSuiteExecutor;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.testmethod.TestUnit;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.rules.vm.SimpleRulesVM;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

public class TestSuite
implements INamedThing {
    public static String VIRTUAL_TEST_SUITE = "Virtual test suite";
    private TestSuiteMethod testSuiteMethod;
    private TestDescription[] tests;
    private TestRunner testRunner = new TestRunner(TestUnit.Builder.getInstance());
    private OpenLArgumentsCloner cloner = new OpenLArgumentsCloner();

    public TestSuite(TestSuiteMethod testSuiteMethod) {
        this.testSuiteMethod = testSuiteMethod;
        this.tests = testSuiteMethod.getTests();
    }

    public TestSuite(TestSuiteMethod testSuiteMethod, TestRunner testRunner) {
        this.testSuiteMethod = testSuiteMethod;
        this.tests = testSuiteMethod.getTests();
        this.testRunner = testRunner;
    }

    public TestSuite(TestSuiteMethod testSuiteMethod, int ... testIndices) {
        this.testSuiteMethod = testSuiteMethod;
        this.tests = new TestDescription[testIndices.length];
        for (int i = 0; i < testIndices.length; ++i) {
            this.tests[i] = testSuiteMethod.getTest(testIndices[i]);
        }
    }

    public TestSuite(TestDescription ... tests) {
        this.tests = tests;
    }

    public TestSuiteMethod getTestSuiteMethod() {
        return this.testSuiteMethod;
    }

    public TestDescription[] getTests() {
        return this.tests;
    }

    public TestDescription getTest(int testNumber) {
        return this.tests[testNumber];
    }

    public TestUnitsResults invokeParallel(TestSuiteExecutor testSuiteExecutor, IOpenClass openClass, long ntimes) {
        int THREAD_COUNT = testSuiteExecutor.getThreadCount();
        Executor threadPoolExecutor = testSuiteExecutor.getExecutor();
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        CountDownLatch countDownLatch = new CountDownLatch(THREAD_COUNT);
        ITestUnit[] testUnitResultsArray = new ITestUnit[this.getNumberOfTests()];
        int i22 = 0;
        while (i22 < THREAD_COUNT) {
            int numThread = i22++;
            Runnable runnable = () -> {
                try {
                    for (int j = 0; j < this.getNumberOfTests(); ++j) {
                        if (j % THREAD_COUNT != numThread) continue;
                        testUnitResultsArray[j] = this.executeTest(openClass, j, ntimes);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    countDownLatch.countDown();
                }
            };
            threadPoolExecutor.execute(runnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException i22) {
            // empty catch block
        }
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            testUnitResults.addTestUnit(testUnitResultsArray[i]);
        }
        return testUnitResults;
    }

    public TestUnitsResults invokeSequentially(IOpenClass openClass, long ntimes) {
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            ITestUnit testUnit = this.executeTest(openClass, i, ntimes);
            testUnitResults.addTestUnit(testUnit);
        }
        return testUnitResults;
    }

    private ITestUnit executeTest(IOpenClass openClass, int test, long ntimes) {
        TestDescription currentTest = this.getTest(test);
        SimpleRulesRuntimeEnv env = new SimpleRulesVM().getRuntimeEnv();
        Object target = openClass.newInstance((IRuntimeEnv)env);
        return this.testRunner.runTest(currentTest, target, (IRuntimeEnv)env, this.cloner, ntimes);
    }

    public TestUnitsResults invoke(Object target, IRuntimeEnv env) {
        TestUnitsResults testUnitResults = new TestUnitsResults(this);
        for (int i = 0; i < this.getNumberOfTests(); ++i) {
            TestDescription currentTest = this.getTest(i);
            ITestUnit testUnit = this.testRunner.runTest(currentTest, target, env, this.cloner, 1L);
            testUnitResults.addTestUnit(testUnit);
        }
        return testUnitResults;
    }

    public int getNumberOfTests() {
        return this.tests.length;
    }

    public String getName() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getName();
        }
        return VIRTUAL_TEST_SUITE;
    }

    public boolean isVirtualTestSuite() {
        return this.testSuiteMethod == null;
    }

    public IOpenMethod getTestedMethod() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getTestedMethod();
        }
        return this.tests[0].getTestedMethod();
    }

    public String getDisplayName(int mode) {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getDisplayName(mode);
        }
        return this.getName();
    }

    public String getUri() {
        if (this.testSuiteMethod != null) {
            return this.testSuiteMethod.getSourceUrl();
        }
        return this.getTestedMethod().getInfo().getSourceUrl();
    }

    public OpenLArgumentsCloner getArgumentsCloner() {
        return this.cloner;
    }
}

