/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.rules.table.formatters.FormattersManager;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.export.ExportUtils;
import org.openl.rules.testmethod.export.Styles;
import org.openl.types.IOpenField;

public abstract class BaseExport {
    static final int FIRST_COLUMN = 1;
    static final int FIRST_ROW = 2;
    static final int SPACE_BETWEEN_RESULTS = 3;
    protected Styles styles;

    protected static void setCellComment(Cell cell, String message) {
        CreationHelper factory = cell.getSheet().getWorkbook().getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex());
        anchor.setCol2(cell.getColumnIndex() + 3);
        anchor.setRow1(cell.getRowIndex());
        anchor.setRow2(cell.getRowIndex() + 3);
        Comment comment = cell.getSheet().createDrawingPatriarch().createCellComment(anchor);
        comment.setString(factory.createRichTextString(message));
        comment.setAuthor("OpenL");
        cell.setCellComment(comment);
    }

    protected void autoSizeColumns(SXSSFSheet sheet) {
        int lastColumn = sheet.getRow(sheet.getLastRowNum()).getLastCellNum();
        for (int i = 2; i < lastColumn; ++i) {
            sheet.autoSizeColumn(i);
        }
    }

    protected Cell createCell(Row row, int cellNum, Object value, CellStyle style) {
        Cell cell = row.createCell(cellNum);
        Object simpleValue = this.getSimpleValue(value);
        if (simpleValue != null) {
            if (simpleValue instanceof Date) {
                style = this.styles.getDateStyle(row.getSheet().getWorkbook(), style);
                cell.setCellValue((Date)simpleValue);
            } else {
                cell.setCellValue(FormattersManager.format(simpleValue));
            }
        }
        cell.setCellStyle(style);
        return cell;
    }

    protected Object getSimpleValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ParameterWithValueDeclaration) {
            ParameterWithValueDeclaration parameter = (ParameterWithValueDeclaration)value;
            Object simpleValue = parameter.getValue();
            IOpenField keyField = parameter.getKeyField();
            if (keyField != null) {
                Object key = ExportUtils.fieldValue(simpleValue, keyField);
                simpleValue = key == null ? simpleValue : key;
            }
            return this.getSimpleValue(simpleValue);
        }
        return value;
    }
}

