/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openl.rules.enumeration.OriginsEnum;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.expressions.sequence.ASimplePriorityRule;
import org.openl.rules.table.properties.expressions.sequence.IntersectedPropertiesPriorityRule;
import org.openl.rules.types.impl.ITablePropertiesSorter;
import org.openl.types.IOpenMethod;

public class DefaultTablePropertiesSorter
implements ITablePropertiesSorter {
    private List<Comparator<ITableProperties>> maxMinPriorityRules = new ArrayList<Comparator<ITableProperties>>();
    private List<Comparator<ITableProperties>> tablesPriorityRules = new ArrayList<Comparator<ITableProperties>>();
    private Comparator<IOpenMethod> methodsComparator;

    public DefaultTablePropertiesSorter() {
        this.initTablesPriorityRules();
        this.initMethodsComparator();
    }

    private void initTablesPriorityRules() {
        this.maxMinPriorityRules.add(new ASimplePriorityRule<Date>("startRequestDate"){

            @Override
            public String getOperationName() {
                return "MAX";
            }

            @Override
            public Date getProprtyValue(ITableProperties properties) {
                return properties.getStartRequestDate();
            }

            @Override
            public int compareNotNulls(Date propertyValue1, Date propertyValue2) {
                return this.MAX(propertyValue1, propertyValue2);
            }
        });
        this.maxMinPriorityRules.add(new ASimplePriorityRule<Date>("endRequestDate"){

            @Override
            public String getOperationName() {
                return "MIN";
            }

            @Override
            public Date getProprtyValue(ITableProperties properties) {
                return properties.getEndRequestDate();
            }

            @Override
            public int compareNotNulls(Date propertyValue1, Date propertyValue2) {
                return this.MIN(propertyValue1, propertyValue2);
            }
        });
        this.maxMinPriorityRules.add(new ASimplePriorityRule<OriginsEnum>("origin"){

            @Override
            public String getOperationName() {
                return "MAX";
            }

            @Override
            public OriginsEnum getProprtyValue(ITableProperties properties) {
                return properties.getOrigin();
            }

            @Override
            public int compareNotNulls(OriginsEnum propertyValue1, OriginsEnum propertyValue2) {
                return this.MAX(propertyValue1, propertyValue2);
            }
        });
        this.tablesPriorityRules.addAll(this.maxMinPriorityRules);
        this.tablesPriorityRules.add(new IntersectedPropertiesPriorityRule());
    }

    private void initMethodsComparator() {
        this.methodsComparator = (o1, o2) -> {
            Comparator<ITableProperties> tablesPriorityRule;
            ITableProperties tableProperties1 = PropertiesHelper.getTableProperties(o1);
            ITableProperties tableProperties2 = PropertiesHelper.getTableProperties(o2);
            int comparisonResult = 0;
            Iterator<Comparator<ITableProperties>> iterator = this.tablesPriorityRules.iterator();
            while (iterator.hasNext() && (comparisonResult = (tablesPriorityRule = iterator.next()).compare(tableProperties1, tableProperties2)) == 0) {
            }
            return comparisonResult;
        };
    }

    @Override
    public List<IOpenMethod> sort(Collection<IOpenMethod> candidates) {
        ArrayList<IOpenMethod> result = new ArrayList<IOpenMethod>(candidates);
        Collections.sort(result, this.methodsComparator);
        return result;
    }

    @Override
    public Comparator<IOpenMethod> getMethodsComparator() {
        return this.methodsComparator;
    }

    public List<Comparator<ITableProperties>> getMaxMinPriorityRules() {
        return this.maxMinPriorityRules;
    }
}

