/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation.properties.dimentional;

import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.expressions.match.MatchingExpression;
import org.openl.rules.validation.properties.dimentional.ADispatcherTableColumn;
import org.openl.rules.validation.properties.dimentional.DispatcherTableRules;

public class SimpleParameterColumn
extends ADispatcherTableColumn {
    SimpleParameterColumn(TablePropertyDefinition property, DispatcherTableRules rules) {
        super(property, rules);
    }

    @Override
    public String getCodeExpression() {
        String propertyName = this.getProperty().getName();
        MatchingExpression matchExpression = this.getProperty().getExpression();
        if (matchExpression == null) {
            String message = String.format("Can`t create expression for \"%s\" property validation.", propertyName);
            throw new OpenlNotCheckedException(message);
        }
        String parameterName = propertyName + "Local";
        String result = SimpleParameterColumn.getMatchByDefaultCodeExpression(matchExpression) + matchExpression.getMatchExpression().getCodeExpression(parameterName);
        return result;
    }

    @Override
    public String getTitle() {
        return this.getProperty().getDisplayName();
    }

    @Override
    public String getParameterDeclaration() {
        String propertyTypeName = this.getProperty().getType().getInstanceClass().getSimpleName();
        return String.format("%s %s%s", propertyTypeName, this.getProperty().getName(), "Local");
    }

    @Override
    public String getRuleValue(int ruleIndex, int elementNum) {
        return this.getRules().getRule(ruleIndex).getPropertyValueAsString(this.getProperty().getName());
    }
}

