/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.vm;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.vm.ResultNotFoundException;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;

public class ArgumentCachingStorage {
    private List<CalculationStep> originalCalculationSteps;
    private Iterator<CalculationStep> step;
    private SimpleRulesRuntimeEnv simpleRulesRuntimeEnv;
    private Storage storage = new Storage();

    public void resetMethodArgumentsCache() {
        this.storage.clear();
    }

    public ArgumentCachingStorage(SimpleRulesRuntimeEnv simpleRulesRuntimeEnv) {
        Objects.requireNonNull(simpleRulesRuntimeEnv, "simpleRulesRuntimeEnv can't be null!");
        this.simpleRulesRuntimeEnv = simpleRulesRuntimeEnv;
    }

    public Object findInCache(Object member, Object ... params) throws ResultNotFoundException {
        Data data = this.storage.get(member);
        if (data != null) {
            return data.get(params);
        }
        throw new ResultNotFoundException();
    }

    public void putToCache(Object member, Object[] params, Object result) {
        Data data = this.storage.get(member);
        if (data == null) {
            data = new Data();
            this.storage.put(member, data);
        }
        try {
            data.get(params);
        }
        catch (ResultNotFoundException e) {
            Object[] clonedParams = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                clonedParams[i] = ((XlsModuleOpenClass)this.simpleRulesRuntimeEnv.getTopClass()).getCloner().deepClone(params[i]);
            }
            data.add(new InvocationData(clonedParams, result));
        }
    }

    public void resetOriginalCalculationSteps() {
        this.originalCalculationSteps = null;
        this.initCurrentStep();
    }

    public void initCurrentStep() {
        this.step = this.originalCalculationSteps != null ? this.originalCalculationSteps.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public Object getValueFromOriginalCalculation(Object member) {
        boolean flag = true;
        int level = 0;
        while (flag) {
            CalculationStep calculationStep;
            flag = this.step.hasNext();
            if (!flag || (calculationStep = this.step.next()).getMember() != member) continue;
            if (calculationStep instanceof ForwardCalculationStep) {
                ++level;
                continue;
            }
            if (level == 0) {
                BackwardCalculationStep backwardCalculationStep = (BackwardCalculationStep)calculationStep;
                return backwardCalculationStep.getResult();
            }
            --level;
        }
        throw new IllegalStateException("Can't find result. Something wrong!!!");
    }

    public void makeForwardStepForOriginalCalculation(Object member) {
        if (this.originalCalculationSteps == null) {
            this.originalCalculationSteps = new LinkedList<CalculationStep>();
        }
        this.originalCalculationSteps.add(new ForwardCalculationStep(member));
    }

    public boolean makeForwardStep(Object member) {
        if (this.step.hasNext()) {
            CalculationStep calculationStep = this.step.next();
            return calculationStep.member == member && calculationStep instanceof ForwardCalculationStep;
        }
        return false;
    }

    public void makeBackwardStepForOriginalCalculation(Object member, Object result) {
        if (this.originalCalculationSteps == null) {
            this.originalCalculationSteps = new LinkedList<CalculationStep>();
        }
        this.originalCalculationSteps.add(new BackwardCalculationStep(member, result));
    }

    public void makeBackwardStep(Object member) {
        boolean flag = true;
        int level = 0;
        while (flag) {
            CalculationStep calculationStep;
            flag = this.step.hasNext();
            if (!flag || (calculationStep = this.step.next()).getMember() != member) continue;
            if (calculationStep instanceof ForwardCalculationStep) {
                ++level;
                continue;
            }
            if (level == 0) {
                return;
            }
            --level;
        }
    }

    static class Storage {
        private final Map<Object, Data> storage = new WeakHashMap<Object, Data>();
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private final Lock readLock = this.readWriteLock.readLock();
        private final Lock writeLock = this.readWriteLock.writeLock();

        Storage() {
        }

        public Data get(Object key) {
            this.readLock.lock();
            try {
                Data data = this.storage.get(key);
                return data;
            }
            finally {
                this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Data put(Object key, Data data) {
            this.writeLock.lock();
            try {
                Data data2 = this.storage.put(key, data);
                return data2;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        public void clear() {
            this.writeLock.lock();
            try {
                this.storage.clear();
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    static final class Data {
        private static final int MAX_DATA_LENGTH = 1000;
        InvocationData[] invocationDatas = new InvocationData[1000];
        int size = 0;

        Data() {
        }

        public Object get(Object[] params) throws ResultNotFoundException {
            int hashCode = Arrays.deepHashCode(params);
            for (int i = 0; i < this.size; ++i) {
                InvocationData invocationData = this.invocationDatas[i];
                if (hashCode != invocationData.getParamsHashCode() || !Arrays.deepEquals(invocationData.getParams(), params)) continue;
                return invocationData.getResult();
            }
            throw new ResultNotFoundException();
        }

        public void add(InvocationData invocationData) {
            if (this.size < 1000) {
                this.invocationDatas[this.size] = invocationData;
                ++this.size;
            }
        }
    }

    static final class InvocationData {
        private Object[] params;
        private int paramsHashCode;
        private boolean paramsHashCodeCalculated = false;
        private Object result;

        public InvocationData(Object[] params, Object result) {
            this.params = params;
            this.result = result;
        }

        public Object[] getParams() {
            return this.params;
        }

        public int getParamsHashCode() {
            if (!this.paramsHashCodeCalculated) {
                this.paramsHashCodeCalculated = true;
                this.paramsHashCode = Arrays.deepHashCode(this.getParams());
            }
            return this.paramsHashCode;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static class BackwardCalculationStep
    extends CalculationStep {
        private Object result;

        public BackwardCalculationStep(Object member, Object result) {
            super(member);
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }

    private static class ForwardCalculationStep
    extends CalculationStep {
        public ForwardCalculationStep(Object member) {
            super(member);
        }
    }

    private static abstract class CalculationStep {
        private Object member;

        public CalculationStep(Object member) {
            if (member == null) {
                throw new IllegalArgumentException("Member can't be null");
            }
            this.member = member;
        }

        public Object getMember() {
            return this.member;
        }
    }
}

