/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event.style;

import java.util.Map;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.openl.excel.parser.event.style.PoiCellStyle;
import org.openl.excel.parser.event.style.PoiUtils;
import org.openl.rules.table.xls.XlsCellStyle;

class OpenLCellStyle
extends XlsCellStyle {
    private final PaletteRecord palette;

    public OpenLCellStyle(int index, ExtendedFormatRecord format, PaletteRecord palette, Map<Integer, FormatRecord> formats) {
        super(new PoiCellStyle((short)index, format, formats), null);
        this.palette = palette;
    }

    @Override
    public short[][] getBorderRGB() {
        short[][] colors = new short[][]{PoiUtils.toRgb(this.palette, this.getXlsStyle().getTopBorderColor()), PoiUtils.toRgb(this.palette, this.getXlsStyle().getRightBorderColor()), PoiUtils.toRgb(this.palette, this.getXlsStyle().getBottomBorderColor()), PoiUtils.toRgb(this.palette, this.getXlsStyle().getLeftBorderColor())};
        return colors;
    }

    @Override
    public short[] getFillBackgroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return PoiUtils.toRgb(this.palette, this.getXlsStyle().getFillBackgroundColor());
    }

    @Override
    public short[] getFillForegroundColor() {
        if (this.hasNoFill()) {
            return null;
        }
        return PoiUtils.toRgb(this.palette, this.getXlsStyle().getFillForegroundColor());
    }
}

