/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.openl.excel.parser.sax.NumberFormat;

public class MinimalStyleTable {
    private List<Integer> numberFormatIdList = new ArrayList<Integer>();
    private Map<Integer, Short> indentMap = new HashMap<Integer, Short>();
    private SortedMap<Integer, String> formatStrings = new TreeMap<Integer, String>();

    public NumberFormat getFormat(int styleIndex) {
        Integer numberFormatId;
        String formatString;
        if (this.numberFormatIdList.isEmpty()) {
            return null;
        }
        if (styleIndex < 0 || styleIndex > this.numberFormatIdList.size()) {
            styleIndex = 0;
        }
        if ((formatString = (String)this.formatStrings.get(numberFormatId = this.numberFormatIdList.get(styleIndex))) == null) {
            formatString = BuiltinFormats.getBuiltinFormat((int)numberFormatId);
        }
        return new NumberFormat(numberFormatId, formatString);
    }

    public Short getIndent(int styleIndex) {
        return this.indentMap.get(styleIndex);
    }

    void addStyle(Integer numberFormatId) {
        this.numberFormatIdList.add(numberFormatId);
    }

    void addFormatString(Integer numberFormatId, String formatString) {
        this.formatStrings.put(numberFormatId, formatString);
    }

    void addIndent(short indent) {
        int lastStyleIndex = this.numberFormatIdList.size() - 1;
        this.indentMap.put(lastStyleIndex, indent);
    }
}

