/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.HashSet;
import java.util.Set;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;

public class ReturnSpreadsheetHeaderDefinition
extends SpreadsheetHeaderDefinition {
    private Set<Integer> returnCells;
    private boolean byColumn;

    public ReturnSpreadsheetHeaderDefinition(SpreadsheetHeaderDefinition source) {
        super(source.getRow(), source.getColumn());
    }

    public void setReturnCells(boolean byColumn, SpreadsheetCell ... cells) {
        if (cells.length == 0) {
            this.returnCells = null;
        } else {
            this.returnCells = new HashSet<Integer>();
            this.byColumn = byColumn;
            if (this.byColumn) {
                for (SpreadsheetCell cell : cells) {
                    this.returnCells.add(cell.getColumnIndex());
                }
            } else {
                for (SpreadsheetCell cell : cells) {
                    this.returnCells.add(cell.getRowIndex());
                }
            }
        }
    }

    public boolean isReturnCell(SpreadsheetCell cell) {
        if (this.byColumn) {
            return this.getRow() == cell.getRowIndex() && this.returnCells != null && this.returnCells.contains(cell.getColumnIndex());
        }
        return this.getColumn() == cell.getColumnIndex() && this.returnCells != null && this.returnCells.contains(cell.getRowIndex());
    }
}

