/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.meta.DoubleValue;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.StringValue;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.calc.CellsHeaderExtractor;
import org.openl.rules.calc.SpreadsheetComponentsBuilder;
import org.openl.rules.calc.SpreadsheetContext;
import org.openl.rules.calc.SpreadsheetHeaderDefinition;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SymbolicTypeDefinition;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetCellField;
import org.openl.rules.calc.element.SpreadsheetCellType;
import org.openl.rules.calc.element.SpreadsheetExpressionMarker;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;
import org.openl.util.text.ILocation;
import org.openl.util.text.LocationUtils;

public class SpreadsheetStructureBuilder {
    public static final String DOLLAR_SIGN = "$";
    private SpreadsheetComponentsBuilder componentsBuilder;
    private IBindingContext spreadsheetBindingContext;
    private IOpenMethodHeader spreadsheetHeader;
    private SpreadsheetStructureBuilderHolder spreadsheetStructureBuilderHolder = new SpreadsheetStructureBuilderHolder(this);
    private Map<Integer, IBindingContext> rowContexts = new HashMap<Integer, IBindingContext>();
    private Map<Integer, Map<Integer, IBindingContext>> colContexts = new HashMap<Integer, Map<Integer, IBindingContext>>();
    private SpreadsheetCell[][] cells;
    private List<SpreadsheetCell> processingCells = new ArrayList<SpreadsheetCell>();
    private List<SpreadsheetCell> extractedCellValues = new ArrayList<SpreadsheetCell>();

    public SpreadsheetStructureBuilderHolder getSpreadsheetStructureBuilderHolder() {
        return this.spreadsheetStructureBuilderHolder;
    }

    public SpreadsheetStructureBuilder(SpreadsheetComponentsBuilder componentsBuilder, IOpenMethodHeader spreadsheetHeader) {
        this.componentsBuilder = componentsBuilder;
        this.spreadsheetHeader = spreadsheetHeader;
    }

    public SpreadsheetCell[][] getCells() {
        this.extractCellValues();
        return (SpreadsheetCell[][])this.cells.clone();
    }

    public void addCellFields(SpreadsheetOpenClass spreadsheetType, boolean autoType) {
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        this.cells = new SpreadsheetCell[rowsCount][columnsCount];
        this.spreadsheetBindingContext = new SpreadsheetContext(generalBindingContext, spreadsheetType);
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                SpreadsheetCell spreadsheetCell;
                this.cells[rowIndex][columnIndex] = spreadsheetCell = this.buildCell(rowIndex, columnIndex, autoType);
                this.addSpreadsheetFields(spreadsheetType, spreadsheetCell, rowIndex, columnIndex);
            }
        }
    }

    private void extractCellValues() {
        CellsHeaderExtractor cellsHeadersExtractor = this.componentsBuilder.getCellsHeadersExtractor();
        int rowsCount = cellsHeadersExtractor.getHeight();
        int columnsCount = cellsHeadersExtractor.getWidth();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            IBindingContext rowBindingContext = this.getRowContext(rowIndex);
            for (int columnIndex = 0; columnIndex < columnsCount; ++columnIndex) {
                boolean found = false;
                for (SpreadsheetCell cell : this.extractedCellValues) {
                    int row = cell.getRowIndex();
                    int column = cell.getColumnIndex();
                    if (row != rowIndex || columnIndex != column) continue;
                    found = true;
                }
                if (found) continue;
                this.extractCellValue(rowBindingContext, rowIndex, columnIndex);
            }
        }
    }

    public IOpenClass makeType(SpreadsheetCell cell) {
        if (cell.getType() == null) {
            int rowIndex = cell.getRowIndex();
            int columnIndex = cell.getColumnIndex();
            IBindingContext rowContext = this.getRowContext(rowIndex);
            if (this.processingCells.contains(cell)) {
                throw new OpenlNotCheckedException("Spreadsheet Expression Loop:" + this.processingCells.toString());
            }
            this.processingCells.add(cell);
            this.extractCellValue(rowContext, rowIndex, columnIndex);
            this.extractedCellValues.add(cell);
            this.processingCells.remove(cell);
            if (cell.getType() == null) {
                cell.setType((IOpenClass)JavaOpenClass.OBJECT);
            }
        }
        return cell.getType();
    }

    private void extractCellValue(IBindingContext rowBindingContext, int rowIndex, int columnIndex) {
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        SpreadsheetCell spreadsheetCell = this.cells[rowIndex][columnIndex];
        if (columnHeaders.get(columnIndex) == null || rowHeaders.get(rowIndex) == null) {
            spreadsheetCell.setValue(null);
            return;
        }
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(cell.getSource(), this.spreadsheetBindingContext);
        String code = StringUtils.trimToNull((String)source.getCode());
        String name = this.getSpreadsheetCellFieldName(columnHeaders.get(columnIndex).getFirstname(), rowHeaders.get(rowIndex).getFirstname());
        IOpenClass type = spreadsheetCell.getType();
        if (code == null) {
            spreadsheetCell.setValue(null);
        } else if (SpreadsheetExpressionMarker.isFormula(code)) {
            int end = 0;
            if (code.startsWith(SpreadsheetExpressionMarker.OPEN_CURLY_BRACKET.getSymbol())) {
                end = -1;
            }
            SubTextSourceCodeModule srcCode = new SubTextSourceCodeModule((IOpenSourceCodeModule)source, 1, end);
            IMethodSignature signature = this.spreadsheetHeader.getSignature();
            IOpenClass declaringClass = this.spreadsheetHeader.getDeclaringClass();
            OpenMethodHeader header = new OpenMethodHeader(name, type, signature, declaringClass);
            IBindingContext columnBindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
            OpenL openl = columnBindingContext.getOpenL();
            try {
                CompositeMethod method;
                if (header.getType() == null) {
                    method = OpenLCellExpressionsCompiler.makeMethodWithUnknownType(openl, (IOpenSourceCodeModule)srcCode, name, signature, declaringClass, columnBindingContext);
                    spreadsheetCell.setType(method.getType());
                } else {
                    method = OpenLCellExpressionsCompiler.makeMethod(openl, (IOpenSourceCodeModule)srcCode, (IOpenMethodHeader)header, columnBindingContext);
                }
                spreadsheetCell.setValue(method);
            }
            catch (CompositeSyntaxNodeException e) {
                this.componentsBuilder.getTableSyntaxNode().addError(e);
                BindHelper.processError((CompositeSyntaxNodeException)e, (IBindingContext)this.spreadsheetBindingContext);
            }
            catch (Exception | LinkageError e) {
                String message = String.format("Cannot parse cell value: [%s] to the necessary type", code);
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ILocation)LocationUtils.createTextInterval((String)source.getCode()), (IOpenSourceCodeModule)source));
            }
        } else if (spreadsheetCell.isConstantCell()) {
            try {
                IOpenField openField = rowBindingContext.findVar("org.openl.this", code, true);
                ConstantOpenField constOpenField = (ConstantOpenField)openField;
                spreadsheetCell.setValue(constOpenField.getValue());
            }
            catch (Exception e) {
                String message = "Cannot parse cell!";
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, null, (IOpenSourceCodeModule)source));
            }
        } else {
            Class instanceClass = type.getInstanceClass();
            if (instanceClass == null) {
                String message = String.format("Type '%s' was loaded with errors", type.getName());
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (IOpenSourceCodeModule)source));
            }
            try {
                IBindingContext bindingContext = this.getColumnContext(columnIndex, rowIndex, rowBindingContext);
                ICell theCellValue = cell.getCell(0, 0);
                Object result = null;
                if (String.class.equals((Object)instanceClass)) {
                    result = String2DataConvertorFactory.parse(instanceClass, code, bindingContext);
                } else {
                    if (theCellValue.hasNativeType()) {
                        result = RuleRowHelper.loadNativeValue(theCellValue, type);
                    }
                    if (result == null) {
                        result = String2DataConvertorFactory.parse(instanceClass, code, bindingContext);
                    }
                }
                if (bindingContext.isExecutionMode() && result instanceof IMetaHolder) {
                    ValueMetaInfo meta = new ValueMetaInfo(name, null, (IOpenSourceCodeModule)source);
                    ((IMetaHolder)result).setMetaInfo((IMetaInfo)meta);
                }
                IOpenCast openCast = bindingContext.getCast((IOpenClass)JavaOpenClass.getOpenClass((Class)instanceClass), type);
                spreadsheetCell.setValue(openCast.convert(result));
            }
            catch (Exception t) {
                String message = String.format("Cannot parse cell value: [%s] to the necessary type", code);
                this.addError(SyntaxNodeExceptionUtils.createError((String)message, (Throwable)t, null, (IOpenSourceCodeModule)source));
            }
        }
    }

    private void addError(SyntaxNodeException e) {
        this.componentsBuilder.getTableSyntaxNode().addError(e);
        this.spreadsheetBindingContext.addError(e);
    }

    private void addSpreadsheetFields(SpreadsheetOpenClass spreadsheetType, SpreadsheetCell spreadsheetCell, int rowIndex, int columnIndex) {
        SpreadsheetHeaderDefinition columnHeaders = this.componentsBuilder.getColumnHeaders().get(columnIndex);
        SpreadsheetHeaderDefinition rowHeaders = this.componentsBuilder.getRowHeaders().get(rowIndex);
        if (columnHeaders == null || rowHeaders == null) {
            return;
        }
        for (SymbolicTypeDefinition columnDefinition : columnHeaders.getVars()) {
            for (SymbolicTypeDefinition rowDefinition : rowHeaders.getVars()) {
                String columnName = columnDefinition.getName().getIdentifier();
                String rowName = rowDefinition.getName().getIdentifier();
                String fieldname = this.getSpreadsheetCellFieldName(columnName, rowName);
                SpreadsheetCellField field = this.createSpreadsheetCellField((IOpenClass)spreadsheetType, spreadsheetCell, fieldname);
                spreadsheetType.addField((IOpenField)field);
            }
        }
    }

    private String getSpreadsheetCellFieldName(String columnName, String rowName) {
        return (DOLLAR_SIGN + columnName + DOLLAR_SIGN + rowName).intern();
    }

    private SpreadsheetCell buildCell(int rowIndex, int columnIndex, boolean autoType) {
        IOpenClass cellType;
        SpreadsheetCellType spreadsheetCellType;
        Map<Integer, SpreadsheetHeaderDefinition> columnHeaders = this.componentsBuilder.getColumnHeaders();
        Map<Integer, SpreadsheetHeaderDefinition> rowHeaders = this.componentsBuilder.getRowHeaders();
        ILogicalTable cell = LogicalTableHelper.mergeBounds((ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getRowNamesTable().getRow(rowIndex), (ILogicalTable)this.componentsBuilder.getCellsHeadersExtractor().getColumnNamesTable().getColumn(columnIndex));
        ICell sourceCell = cell.getSource().getCell(0, 0);
        String cellCode = sourceCell.getStringValue();
        ConstantOpenField openField = null;
        if (cellCode == null || cellCode.isEmpty() || columnHeaders.get(columnIndex) == null || rowHeaders.get(rowIndex) == null) {
            spreadsheetCellType = SpreadsheetCellType.EMPTY;
        } else if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
            spreadsheetCellType = SpreadsheetCellType.METHOD;
        } else {
            spreadsheetCellType = SpreadsheetCellType.VALUE;
            openField = RuleRowHelper.findConstantField(this.spreadsheetBindingContext, cellCode);
            if (openField != null) {
                spreadsheetCellType = SpreadsheetCellType.CONSTANT;
            }
        }
        ICell sourceCellForExecutionMode = this.spreadsheetBindingContext.isExecutionMode() ? null : sourceCell;
        SpreadsheetCell spreadsheetCell = new SpreadsheetCell(rowIndex, columnIndex, sourceCellForExecutionMode, spreadsheetCellType);
        SpreadsheetHeaderDefinition columnHeader = columnHeaders.get(columnIndex);
        SpreadsheetHeaderDefinition rowHeader = rowHeaders.get(rowIndex);
        if (openField != null) {
            cellType = openField.getType();
        } else if (columnHeader != null && columnHeader.getType() != null) {
            cellType = columnHeader.getType();
        } else if (rowHeader != null && rowHeader.getType() != null) {
            cellType = rowHeader.getType();
        } else {
            try {
                if (autoType) {
                    if (SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        cellType = null;
                    } else {
                        String2DataConvertorFactory.getConvertor(Double.class).parse(cellCode, null);
                        cellType = JavaOpenClass.getOpenClass(Double.class);
                    }
                } else {
                    if (!SpreadsheetExpressionMarker.isFormula(cellCode)) {
                        String2DataConvertorFactory.getConvertor(DoubleValue.class).parse(cellCode, null);
                    }
                    cellType = JavaOpenClass.getOpenClass(DoubleValue.class);
                }
            }
            catch (Exception t) {
                cellType = autoType ? JavaOpenClass.getOpenClass(String.class) : JavaOpenClass.getOpenClass(StringValue.class);
            }
        }
        spreadsheetCell.setType(cellType);
        return spreadsheetCell;
    }

    private IBindingContext getRowContext(int rowIndex) {
        IBindingContext rowContext = this.rowContexts.get(rowIndex);
        if (rowContext == null) {
            rowContext = this.makeRowContext(rowIndex);
            this.rowContexts.put(rowIndex, rowContext);
        }
        return rowContext;
    }

    private IBindingContext getColumnContext(int columnIndex, int rowIndex, IBindingContext rowBindingContext) {
        Map contexts = this.colContexts.computeIfAbsent(columnIndex, e -> new HashMap());
        return contexts.computeIfAbsent(rowIndex, e -> this.makeColumnContext(columnIndex, rowBindingContext));
    }

    private IBindingContext makeColumnContext(int columnIndex, IBindingContext rowBindingContext) {
        String columnOpenClassName = String.format("%sColType%d", this.spreadsheetHeader.getName(), columnIndex);
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        Map<Integer, SpreadsheetHeaderDefinition> headers = this.componentsBuilder.getRowHeaders();
        ComponentOpenClass columnOpenClass = new ComponentOpenClass(columnOpenClassName, generalBindingContext.getOpenL());
        int height = this.cells.length;
        for (int rowIndex = 0; rowIndex < height; ++rowIndex) {
            SpreadsheetHeaderDefinition headerDefinition = headers.get(rowIndex);
            this.proc(rowIndex, columnOpenClass, columnIndex, headerDefinition);
        }
        return new SpreadsheetContext(rowBindingContext, columnOpenClass);
    }

    private IBindingContext makeRowContext(int rowIndex) {
        String rowOpenClassName = String.format("%sRowType%d", this.spreadsheetHeader.getName(), rowIndex);
        IBindingContext generalBindingContext = this.componentsBuilder.getBindingContext();
        Map<Integer, SpreadsheetHeaderDefinition> headers = this.componentsBuilder.getColumnHeaders();
        ComponentOpenClass rowOpenClass = new ComponentOpenClass(rowOpenClassName, generalBindingContext.getOpenL());
        int width = this.cells[0].length;
        for (int columnIndex = 0; columnIndex < width; ++columnIndex) {
            SpreadsheetHeaderDefinition columnHeader = headers.get(columnIndex);
            this.proc(rowIndex, rowOpenClass, columnIndex, columnHeader);
        }
        return new SpreadsheetContext(this.spreadsheetBindingContext, rowOpenClass);
    }

    private void proc(int rowIndex, ComponentOpenClass rowOpenClass, int columnIndex, SpreadsheetHeaderDefinition columnHeader) {
        if (columnHeader == null) {
            return;
        }
        SpreadsheetCell cell = this.cells[rowIndex][columnIndex];
        for (SymbolicTypeDefinition typeDefinition : columnHeader.getVars()) {
            String fieldName = (DOLLAR_SIGN + typeDefinition.getName().getIdentifier()).intern();
            SpreadsheetCellField field = this.createSpreadsheetCellField((IOpenClass)rowOpenClass, cell, fieldName);
            rowOpenClass.addField((IOpenField)field);
        }
    }

    private SpreadsheetCellField createSpreadsheetCellField(IOpenClass rowOpenClass, SpreadsheetCell cell, String fieldName) {
        SpreadsheetStructureBuilderHolder structureBuilderContainer = this.getSpreadsheetStructureBuilderHolder();
        if (cell.getSpreadsheetCellType() == SpreadsheetCellType.METHOD) {
            return new SpreadsheetCellField(structureBuilderContainer, rowOpenClass, fieldName, cell);
        }
        return new SpreadsheetCellField.ConstSpreadsheetCellField(structureBuilderContainer, rowOpenClass, fieldName, cell);
    }
}

