/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import org.openl.binding.impl.NodeDescriptionHolder;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.element.SpreadsheetStructureBuilderHolder;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetCellField
extends ASpreadsheetField
implements NodeDescriptionHolder {
    protected SpreadsheetCell cell;
    private SpreadsheetStructureBuilderHolder structureBuilderContainer;

    public SpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
        super(declaringClass, name, cell.getType());
        this.cell = cell;
        this.structureBuilderContainer = structureBuilderContainer;
    }

    public Object get(Object target, IRuntimeEnv env) {
        SpreadsheetResultCalculator result = (SpreadsheetResultCalculator)target;
        if (result == null) {
            return this.getType().nullObject();
        }
        return result.getValue(this.cell.getRowIndex(), this.cell.getColumnIndex());
    }

    public SpreadsheetCell getCell() {
        return this.cell;
    }

    public IOpenClass getType() {
        IOpenClass t = this.cell.getType();
        if (t == null) {
            t = this.structureBuilderContainer.getSpreadsheetStructureBuilder().makeType(this.cell);
        }
        return t;
    }

    public boolean isWritable() {
        return false;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException("Can not write to spreadsheet cell result");
    }

    @Override
    public String getDescription() {
        return this.getType().getDisplayName(0) + " " + this.getName();
    }

    public static class ConstSpreadsheetCellField
    extends SpreadsheetCellField {
        public ConstSpreadsheetCellField(SpreadsheetStructureBuilderHolder structureBuilderContainer, IOpenClass declaringClass, String name, SpreadsheetCell cell) {
            super(structureBuilderContainer, declaringClass, name, cell);
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.cell.getValue();
        }
    }
}

