/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.cmatch.algorithm;

import java.util.List;
import org.openl.rules.cmatch.ColumnMatch;
import org.openl.rules.cmatch.MatchNode;
import org.openl.rules.cmatch.algorithm.Argument;
import org.openl.rules.cmatch.algorithm.IMatchAlgorithmExecutor;
import org.openl.rules.cmatch.matcher.IMatcher;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.Tracer;

public class MatchAlgorithmExecutor
implements IMatchAlgorithmExecutor {
    public static final Object NO_MATCH = null;

    public Object invoke(ColumnMatch target, Object[] params, IRuntimeEnv env) {
        MatchNode checkTree = target.getCheckTree();
        Object[] returnValues = target.getReturnValues();
        for (MatchNode line : checkTree.getChildren()) {
            if (line.getRowIndex() >= 0) {
                throw new IllegalArgumentException("Linearized MatchNode tree expected!");
            }
            for (int resultIndex = 0; resultIndex < returnValues.length; ++resultIndex) {
                boolean success = true;
                List<MatchNode> children = line.getChildren();
                for (MatchNode node : children) {
                    Object checkValue;
                    Argument arg = node.getArgument();
                    Object var = arg.extractValue(target, params, env);
                    IMatcher matcher = node.getMatcher();
                    if (matcher.match(var, checkValue = node.getCheckValues()[resultIndex])) continue;
                    success = false;
                    break;
                }
                if (!success) continue;
                Object result = returnValues[resultIndex];
                for (MatchNode node : line.getChildren()) {
                    Tracer.put((Object)this, (String)"match", (Object)target, (Object)node, (int)resultIndex, null);
                }
                Tracer.put((Object)this, (String)"result", (Object)target, (int)resultIndex, (Object)result);
                return result;
            }
        }
        return NO_MATCH;
    }
}

