/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.openl.OpenL;
import org.openl.meta.StringValue;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.CollectionElementWithMultiRowField;
import org.openl.rules.data.DatatypeArrayMultiRowElementContext;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ITable;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.DatatypeOpenField;
import org.openl.vm.IRuntimeEnv;

public class ColumnDescriptor {
    static final Object PREV_RES_EMPTY = new Object();
    private final IOpenField field;
    private final StringValue displayValue;
    private final OpenL openl;
    private final boolean valuesAnArray;
    private boolean supportMultirows = false;
    private final boolean constructor;
    private Map<String, Integer> uniqueIndex = null;
    private final IdentifierNode[] fieldChainTokens;
    private ColumnGroupKey groupKey;
    private final int columnIdx;
    private final boolean primaryKey;

    public ColumnDescriptor(IOpenField field, StringValue displayValue, OpenL openl, boolean constructor, IdentifierNode[] fieldChainTokens, int columnIdx, boolean primaryKey) {
        this.field = field;
        this.displayValue = displayValue;
        this.openl = openl;
        this.constructor = constructor;
        this.fieldChainTokens = fieldChainTokens;
        this.primaryKey = primaryKey;
        this.columnIdx = columnIdx;
        if (field == null) {
            this.valuesAnArray = false;
        } else {
            this.valuesAnArray = ColumnDescriptor.isValuesAnArray(field.getType());
            this.supportMultirows = ColumnDescriptor.isSupportMultirows(field);
        }
    }

    protected IRuntimeEnv getRuntimeEnv() {
        return this.openl.getVm().getRuntimeEnv();
    }

    protected static boolean isValuesAnArray(IOpenClass paramType) {
        if (paramType.getAggregateInfo() == null) {
            return false;
        }
        return paramType.getAggregateInfo().isAggregate(paramType);
    }

    private static boolean isSupportMultirows(IOpenField field) {
        if (field instanceof FieldChain) {
            IOpenField[] fields;
            FieldChain fieldChain = (FieldChain)field;
            for (IOpenField f : fields = fieldChain.getFields()) {
                if (!(f instanceof CollectionElementWithMultiRowField)) continue;
                return true;
            }
        }
        return false;
    }

    public ColumnGroupKey buildGroupKey() {
        if (this.field instanceof FieldChain) {
            int fields = ((FieldChain)this.field).getFields().length;
            if (this.isPrimaryKey() && ((FieldChain)this.field).getFields()[fields - 1] instanceof CollectionElementWithMultiRowField) {
                ++fields;
            } else if (this.valuesAnArray) {
                return new ColumnGroupKey(fields, this.field.getName(), true);
            }
            return new ColumnGroupKey(fields - 1, fields > 1 ? this.field.getName() : "this", this.primaryKey);
        }
        return ColumnGroupKey.DEFAULT;
    }

    protected IOpenField getField() {
        return this.field;
    }

    public Object getColumnValue(Object target) {
        return this.field == null ? target : this.field.get(target, this.getRuntimeEnv());
    }

    public String getDisplayName() {
        return this.displayValue.getValue();
    }

    public Object getLiteral(IOpenClass paramType, ILogicalTable valuesTable, OpenlToolAdaptor ota) throws SyntaxNodeException {
        boolean valuesAnArray = ColumnDescriptor.isValuesAnArray(paramType);
        valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
        if (valuesAnArray) {
            IOpenClass aggregateType = paramType;
            paramType = aggregateType.getAggregateInfo().getComponentType(paramType);
            if (valuesTable.getHeight() == 1 && valuesTable.getWidth() == 1) {
                return RuleRowHelper.loadCommaSeparatedParam(aggregateType, paramType, this.field == null ? "constructor" : this.field.getName(), null, valuesTable, ota);
            }
            return this.loadMultiRowArray(valuesTable, ota, paramType, aggregateType);
        }
        return this.getSingleValue(valuesTable, ota, paramType);
    }

    public String getName() {
        return this.field == null ? "this" : this.field.getName();
    }

    public IOpenClass getType() {
        return this.field == null ? null : this.field.getType();
    }

    public synchronized Map<String, Integer> getUniqueIndex(ITable table, int idx) throws SyntaxNodeException {
        if (this.uniqueIndex == null) {
            this.uniqueIndex = table.makeUniqueIndex(idx);
        }
        return this.uniqueIndex;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public IdentifierNode[] getFieldChainTokens() {
        return this.fieldChainTokens;
    }

    public Object populateLiteral(Object literal, ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter, IRuntimeEnv env) throws SyntaxNodeException {
        IOpenClass aggregateType;
        if (this.field == null) {
            return literal;
        }
        IOpenClass paramType = aggregateType = this.field.getType();
        if (this.valuesAnArray) {
            paramType = paramType.getAggregateInfo().getComponentType(paramType);
        }
        valuesTable = LogicalTableHelper.make1ColumnTable(valuesTable);
        env.pushThis(literal);
        if (this.supportMultirows) {
            this.processWithMultiRowsSupport(literal, valuesTable, toolAdapter, env, aggregateType, paramType);
        } else {
            Object res;
            if (this.valuesAnArray) {
                res = this.getArrayValues(valuesTable, toolAdapter, aggregateType, paramType);
            } else {
                IGridTable sourceGrid = (IGridTable)valuesTable.getSource().getSubtable(0, 0, 1, 1);
                ILogicalTable logicalTable = (ILogicalTable)LogicalTableHelper.logicalTable(sourceGrid).getSubtable(0, 0, 1, 1);
                res = this.getSingleValue(logicalTable, toolAdapter, paramType);
            }
            if (res != null) {
                this.field.set(literal, res, env);
            }
        }
        return env.popThis();
    }

    public void setFieldValue(Object literal, Object res, IRuntimeEnv env) {
        if (this.field == null) {
            return;
        }
        if (res != null) {
            this.field.set(literal, res, env);
        } else {
            this.field.get(literal, env);
        }
    }

    public Object getFieldValue(Object literal, IRuntimeEnv env) {
        return this.field != null ? this.field.get(literal, env) : null;
    }

    private void processWithMultiRowsSupport(Object literal, ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter, IRuntimeEnv env, IOpenClass aggregateType, IOpenClass paramType) throws SyntaxNodeException {
        DatatypeArrayMultiRowElementContext datatypeArrayMultiRowElementContext = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        Object prevRes = PREV_RES_EMPTY;
        for (int i = 0; i < valuesTable.getSource().getHeight(); ++i) {
            Object res;
            datatypeArrayMultiRowElementContext.setRow(i);
            ILogicalTable logicalTable = (ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, i, 1, i + 1)).getSubtable(0, 0, 1, 1);
            boolean isSame = false;
            if (this.valuesAnArray) {
                res = this.getArrayValues(logicalTable, toolAdapter, aggregateType, paramType);
                if (prevRes != null && prevRes.getClass().isArray()) {
                    isSame = ColumnDescriptor.isSameArrayValue(res, prevRes);
                    datatypeArrayMultiRowElementContext.setRowValueIsTheSameAsPrevious(isSame);
                } else {
                    datatypeArrayMultiRowElementContext.setRowValueIsTheSameAsPrevious(false);
                }
            } else {
                res = this.getSingleValue(logicalTable, toolAdapter, paramType);
                isSame = this.isSameSingleValue(res, prevRes);
                datatypeArrayMultiRowElementContext.setRowValueIsTheSameAsPrevious(isSame);
            }
            if (isSame) {
                res = prevRes;
            }
            if (res != null || PREV_RES_EMPTY == prevRes) {
                this.field.set(literal, res, env);
            } else {
                this.field.get(literal, env);
            }
            prevRes = res;
        }
    }

    Object parseCellValue(ILogicalTable valuesTable, OpenlToolAdaptor toolAdapter) throws SyntaxNodeException {
        IOpenClass aggregateType;
        IOpenClass paramType = aggregateType = this.field.getType();
        if (this.valuesAnArray) {
            paramType = paramType.getAggregateInfo().getComponentType(paramType);
        }
        return this.valuesAnArray ? this.getArrayValues(valuesTable, toolAdapter, aggregateType, paramType) : this.getSingleValue(valuesTable, toolAdapter, paramType);
    }

    boolean isSameValue(Object res, Object prevRes) {
        return this.valuesAnArray ? ColumnDescriptor.isSameArrayValue(res, prevRes) : this.isSameSingleValue(res, prevRes);
    }

    private static boolean isSameArrayValue(Object res, Object prevRes) {
        boolean resIsEmpty = Array.getLength(res) == 0;
        return resIsEmpty && Array.getLength(prevRes) == 0 || Arrays.deepEquals((Object[])prevRes, (Object[])res) || prevRes != PREV_RES_EMPTY && resIsEmpty;
    }

    private boolean isSameSingleValue(Object res, Object prevRes) {
        return prevRes == null && res == null || prevRes != null && prevRes.equals(res) || prevRes != PREV_RES_EMPTY && res == null;
    }

    public boolean isReference() {
        return false;
    }

    private Object getArrayValues(ILogicalTable valuesTable, OpenlToolAdaptor ota, IOpenClass aggregateType, IOpenClass paramType) throws SyntaxNodeException {
        if (valuesTable.getHeight() == 1 && valuesTable.getWidth() == 1) {
            String fieldName = this.field == null ? "constructor" : this.field.getName();
            return RuleRowHelper.loadCommaSeparatedParam(aggregateType, paramType, fieldName, null, (ILogicalTable)valuesTable.getRow(0), ota);
        }
        return this.loadMultiRowArray(valuesTable, ota, paramType, aggregateType);
    }

    private Object getSingleValue(ILogicalTable logicalTable, OpenlToolAdaptor toolAdapter, IOpenClass paramType) throws SyntaxNodeException {
        String fieldName = this.field == null ? "constructor" : this.field.getName();
        return RuleRowHelper.loadSingleParam(paramType, fieldName, null, logicalTable, toolAdapter);
    }

    private Object loadMultiRowArray(ILogicalTable logicalTable, OpenlToolAdaptor openlAdaptor, IOpenClass paramType, IOpenClass aggregateType) throws SyntaxNodeException {
        int valuesTableHeight = RuleRowHelper.calculateHeight(logicalTable);
        ArrayList<Object> values = new ArrayList<Object>(valuesTableHeight);
        for (int i = 0; i < valuesTableHeight; ++i) {
            Object res = this.getSingleValue((ILogicalTable)logicalTable.getRow(i), openlAdaptor, paramType);
            if (res == null) {
                res = paramType.nullObject();
            }
            values.add(res);
        }
        IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
        Object arrayValues = aggregateInfo.makeIndexedAggregate(paramType, values.size());
        IOpenIndex index = aggregateInfo.getIndex(aggregateType);
        for (int i = 0; i < values.size(); ++i) {
            index.setValue(arrayValues, (Object)i, values.get(i));
        }
        return arrayValues;
    }

    boolean isDeclaredClassSupportMultirow() {
        IOpenField targetField = this.getTargetField();
        if (!(targetField instanceof DatatypeOpenField)) {
            return true;
        }
        IOpenClass declaredClass = targetField.getDeclaringClass();
        for (IOpenField declaredField : declaredClass.getFields().values()) {
            IOpenClass fieldType = declaredField.getType();
            IAggregateInfo info = fieldType.getAggregateInfo();
            if (info == null || !info.isAggregate(fieldType)) continue;
            return true;
        }
        return false;
    }

    private IOpenField getTargetField() {
        if (!(this.field instanceof FieldChain)) {
            return null;
        }
        FieldChain fieldChain = (FieldChain)this.field;
        IOpenField[] fields = fieldChain.getFields();
        if (fields.length == 0) {
            return null;
        }
        return fields[fields.length - 1];
    }

    public boolean isSupportMultirows() {
        return this.supportMultirows;
    }

    public void setSupportMultirows(boolean supportMultirows) {
        this.supportMultirows = supportMultirows;
    }

    public boolean isValuesAnArray() {
        return this.valuesAnArray;
    }

    public int getColumnIdx() {
        return this.columnIdx;
    }

    public ColumnGroupKey getGroupKey() {
        return this.groupKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setGroupKey(ColumnGroupKey key) {
        this.groupKey = key;
    }

    public static final class ColumnGroupKey
    implements Comparable<ColumnGroupKey> {
        private static final ColumnGroupKey DEFAULT = new ColumnGroupKey(0, "this", false);
        private final int level;
        private final String path;

        public ColumnGroupKey(int level, String path, boolean pk) {
            int sep;
            this.level = level;
            this.path = pk ? path : ((sep = path.lastIndexOf(46)) > 0 ? path.substring(0, sep) : path);
        }

        public int getLevel() {
            return this.level;
        }

        @Override
        public int compareTo(ColumnGroupKey o) {
            int i = Integer.compare(this.level, o.level);
            if (i != 0) {
                return i;
            }
            return this.path.compareTo(o.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnGroupKey key = (ColumnGroupKey)o;
            return this.level == key.level && Objects.equals(this.path, key.path);
        }

        public int hashCode() {
            return Objects.hash(this.level, this.path);
        }
    }
}

