/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.ArrayList;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.DataTableBoundNode;
import org.openl.rules.data.ITable;
import org.openl.rules.data.OpenlBasedDataTableModel;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DataTableMetaInfoReader;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;

public class DataNodeBinder
extends AXlsTableBinder {
    public static final int TYPE_INDEX = 1;
    private static final int TABLE_NAME_INDEX = 2;

    protected ATableBoundNode makeNode(TableSyntaxNode tsn, XlsModuleOpenClass module, IBindingContext bindingContext) {
        DataTableBoundNode boundNode = new DataTableBoundNode(tsn, module);
        if (!bindingContext.isExecutionMode()) {
            tsn.setMetaInfoReader(new DataTableMetaInfoReader(boundNode));
        }
        return boundNode;
    }

    protected ILogicalTable getTableBody(TableSyntaxNode tsn) {
        return DataTableBindHelper.getTableBody(tsn);
    }

    @Override
    public IMemberBoundNode preBind(TableSyntaxNode tableSyntaxNode, OpenL openl, IBindingContext bindingContext, XlsModuleOpenClass module) throws Exception {
        DataTableBoundNode dataNode = (DataTableBoundNode)this.makeNode(tableSyntaxNode, module, bindingContext);
        ILogicalTable table = tableSyntaxNode.getTable();
        GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource(), bindingContext);
        IdentifierNode[] parsedHeader = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)" \n\r");
        if (parsedHeader.length < 3) {
            throw SyntaxNodeExceptionUtils.createError((String)"Data table format: Data <typename> <tablename>", (IOpenSourceCodeModule)source);
        }
        if ((parsedHeader = this.mergeArraySimbols(parsedHeader)).length > 3) {
            throw SyntaxNodeExceptionUtils.createError((String)"Data table format: Data <typename> <tablename>", (IOpenSourceCodeModule)source);
        }
        String typeName = parsedHeader[1].getText();
        String tableName = parsedHeader[2].getText();
        IOpenClass tableType = RuleRowHelper.getType(typeName, (ISyntaxNode)parsedHeader[1], bindingContext);
        if (tableType.getInstanceClass() == null) {
            String message = String.format("Type '%s' was defined with errors", typeName);
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)parsedHeader[1]);
        }
        ITable dataTable = this.makeTable(module, tableSyntaxNode, tableName, tableType, bindingContext, openl, true);
        dataNode.setTable(dataTable);
        return dataNode;
    }

    private IdentifierNode[] mergeArraySimbols(IdentifierNode[] parsedHeader) {
        int i;
        ArrayList<IdentifierNode> parsedHeader1 = new ArrayList<IdentifierNode>();
        parsedHeader1.add(parsedHeader[0]);
        StringBuilder sb = new StringBuilder();
        for (i = 2; i < parsedHeader.length - 1 && ("[]".equals(parsedHeader[i].getIdentifier()) || "]".equals(parsedHeader[i].getIdentifier()) || "[".equals(parsedHeader[i].getIdentifier())); ++i) {
            sb.append(parsedHeader[i].getIdentifier());
        }
        parsedHeader1.add(new IdentifierNode(parsedHeader[1].getType(), (ILocation)new TextInterval(parsedHeader[1].getLocation().getStart(), parsedHeader[i - 1].getLocation().getEnd()), parsedHeader[1].getIdentifier() + sb.toString(), parsedHeader[1].getModule()));
        for (int j = i; j < parsedHeader.length; ++j) {
            parsedHeader1.add(parsedHeader[j]);
        }
        return parsedHeader1.toArray(new IdentifierNode[0]);
    }

    public void processTable(XlsModuleOpenClass xlsOpenClass, ITable tableToProcess, ILogicalTable tableBody, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow) throws Exception {
        if (tableBody == null) {
            String message = "There is no body in Data table.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        ILogicalTable horizDataTableBody = DataTableBindHelper.getHorizontalTable(tableBody, tableType);
        if (horizDataTableBody.getHeight() <= 1) {
            String message = "Invalid table structure: data table body should contain key and value columns.";
            throw SyntaxNodeExceptionUtils.createError((String)message, (ISyntaxNode)tableToProcess.getTableSyntaxNode());
        }
        ILogicalTable descriptorRows = DataTableBindHelper.getDescriptorRows(horizDataTableBody);
        ILogicalTable dataWithTitleRows = DataTableBindHelper.getHorizontalDataWithTitle(horizDataTableBody);
        dataWithTitleRows = LogicalTableHelper.logicalTable(dataWithTitleRows.getSource(), descriptorRows, null);
        ColumnDescriptor[] descriptors = this.makeDescriptors(tableToProcess, tableType, bindingContext, openl, hasColumnTitleRow, horizDataTableBody, descriptorRows, dataWithTitleRows);
        OpenlBasedDataTableModel dataModel = new OpenlBasedDataTableModel(tableName, tableType, openl, descriptors, hasColumnTitleRow);
        OpenlToolAdaptor ota = new OpenlToolAdaptor(openl, bindingContext, tableToProcess.getTableSyntaxNode());
        xlsOpenClass.getDataBase().preLoadTable(tableToProcess, dataModel, dataWithTitleRows, ota);
    }

    protected ColumnDescriptor[] makeDescriptors(ITable tableToProcess, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean hasColumnTitleRow, ILogicalTable horizDataTableBody, ILogicalTable descriptorRows, ILogicalTable dataWithTitleRows) throws Exception {
        return DataTableBindHelper.makeDescriptors(bindingContext, tableToProcess, tableType, openl, descriptorRows, dataWithTitleRows, DataTableBindHelper.hasForeignKeysRow(horizDataTableBody), hasColumnTitleRow, true);
    }

    public static void putSubTableForBussinesView(TableSyntaxNode tableSyntaxNode, IOpenClass tableType) {
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        ILogicalTable dataWithTitle = DataTableBindHelper.getSubTableForBusinessView(tableBody, tableType);
        tableSyntaxNode.getSubTables().put("business", dataWithTitle);
    }

    protected ITable makeTable(XlsModuleOpenClass xlsOpenClass, TableSyntaxNode tableSyntaxNode, String tableName, IOpenClass tableType, IBindingContext bindingContext, OpenL openl, boolean useRegistered) throws Exception {
        ITable resultTable = useRegistered ? xlsOpenClass.getDataBase().registerTable(tableName, tableSyntaxNode) : xlsOpenClass.getDataBase().registerNewTable(tableName, tableSyntaxNode);
        ILogicalTable tableBody = DataTableBindHelper.getTableBody(tableSyntaxNode);
        this.processTable(xlsOpenClass, resultTable, tableBody, tableName, tableType, bindingContext, openl, true);
        DataNodeBinder.putSubTableForBussinesView(tableSyntaxNode, tableType);
        return resultTable;
    }
}

