/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openl.OpenL;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.ITableModel;
import org.openl.types.IOpenClass;

public class OpenlBasedDataTableModel
implements ITableModel {
    private String name;
    private IOpenClass type;
    private OpenL openl;
    private ColumnDescriptor[] columnDescriptors;
    private boolean hasColumnTitleRow;
    private final int columnCount;

    public OpenlBasedDataTableModel(String name, IOpenClass type, OpenL openl, ColumnDescriptor[] columnDescriptor, boolean hasColumnTitleRow) {
        this.name = name;
        this.type = type;
        this.openl = openl;
        this.columnCount = columnDescriptor.length;
        this.columnDescriptors = OpenlBasedDataTableModel.initializeDescriptors(columnDescriptor);
        this.hasColumnTitleRow = hasColumnTitleRow;
    }

    private static ColumnDescriptor[] initializeDescriptors(ColumnDescriptor[] descriptors) {
        ColumnDescriptor.ColumnGroupKey key;
        int cntDescriptors = 0;
        TreeMap<ColumnDescriptor.ColumnGroupKey, List> descriptorGroups = new TreeMap<ColumnDescriptor.ColumnGroupKey, List>();
        for (ColumnDescriptor descriptor : descriptors) {
            if (descriptor == null) continue;
            ++cntDescriptors;
            key = descriptor.buildGroupKey();
            List descriptorsByKey = descriptorGroups.computeIfAbsent(key, k -> new LinkedList());
            if (descriptor.isPrimaryKey()) {
                descriptorsByKey.add(0, descriptor);
                continue;
            }
            descriptorsByKey.add(descriptor);
        }
        ColumnDescriptor[] res = new ColumnDescriptor[cntDescriptors];
        int i = 0;
        for (Map.Entry e : descriptorGroups.entrySet()) {
            key = (ColumnDescriptor.ColumnGroupKey)e.getKey();
            for (ColumnDescriptor descriptor : (List)e.getValue()) {
                descriptor.setGroupKey(key);
                res[i] = descriptor;
                ++i;
            }
        }
        return res;
    }

    @Override
    public boolean hasColumnTitleRow() {
        return this.hasColumnTitleRow;
    }

    @Override
    public ColumnDescriptor[] getDescriptors() {
        return this.columnDescriptors;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.type.getInstanceClass();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IOpenClass getType() {
        return this.type;
    }

    @Override
    public Object newInstance() {
        return this.type.newInstance(this.openl.getVm().getRuntimeEnv());
    }

    @Override
    public ColumnDescriptor getDescriptor(int idx) {
        for (ColumnDescriptor descriptor : this.columnDescriptors) {
            if (descriptor.getColumnIdx() != idx) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }
}

