/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.datatype.gen;

import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.openl.gen.FieldDescription;
import org.openl.gen.POJOByteCodeGenerator;

class SimpleBeanByteCodeGenerator
extends POJOByteCodeGenerator {
    private final String methodName;

    SimpleBeanByteCodeGenerator(String beanName, LinkedHashMap<String, FieldDescription> beanFields, Class<?> parentClass, Map<String, FieldDescription> parentFields, String methodName) {
        super(beanName, beanFields, parentClass, parentFields, true);
        this.methodName = methodName;
    }

    private void addArgs(ClassWriter classWriter, Map<String, FieldDescription> beanFields) {
        Type objectType = Type.getType(Object.class);
        Type beanType = Type.getType((String)this.getBeanNameDescriptor());
        Method args = Method.getMethod((String)"java.lang.Object[] _args()");
        GeneratorAdapter ag = new GeneratorAdapter(1, args, null, null, (ClassVisitor)classWriter);
        ag.push(beanFields.size());
        ag.newArray(objectType);
        int i = 0;
        for (Map.Entry<String, FieldDescription> field : beanFields.entrySet()) {
            Type fieldType = Type.getType((String)field.getValue().getTypeDescriptor());
            ag.dup();
            ag.push(i);
            ag.loadThis();
            ag.getField(beanType, field.getKey(), fieldType);
            ag.valueOf(fieldType);
            ag.arrayStore(objectType);
            ++i;
        }
        ag.returnValue();
        ag.endMethod();
    }

    private void addTypes(ClassWriter classWriter, Map<String, FieldDescription> beanFields) {
        Type classType = Type.getType(Class.class);
        Method types = Method.getMethod((String)"java.lang.Class[] _types()");
        GeneratorAdapter tg = new GeneratorAdapter(9, types, null, null, (ClassVisitor)classWriter);
        tg.push(beanFields.size());
        tg.newArray(classType);
        int i = 0;
        for (Map.Entry<String, FieldDescription> field : beanFields.entrySet()) {
            Type fieldType = Type.getType((String)field.getValue().getTypeDescriptor());
            tg.dup();
            tg.push(i);
            tg.push(fieldType);
            tg.arrayStore(classType);
            ++i;
        }
        tg.returnValue();
        tg.endMethod();
    }

    private void addMethod(ClassWriter classWriter, String methodName) {
        Method method = Method.getMethod((String)"java.lang.String _method()");
        GeneratorAdapter mg = new GeneratorAdapter(9, method, null, null, (ClassVisitor)classWriter);
        mg.push(methodName);
        mg.returnValue();
        mg.endMethod();
    }

    protected void visitExtraByteCodeGeneration(ClassWriter classWriter) {
        if (this.methodName != null) {
            this.addArgs(classWriter, this.getBeanFields());
            this.addTypes(classWriter, this.getBeanFields());
            this.addMethod(classWriter, this.methodName);
        }
    }
}

