/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.exception.OpenLCompilationException;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.DecisionTableLookupConvertor;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.element.Action;
import org.openl.rules.dt.element.ActionType;
import org.openl.rules.dt.element.Condition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.utils.ParserUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;

public class DecisionTableLoader {
    static final String EMPTY_BODY = "Decision table must contain body section.";
    private int columnsNumber;
    private RuleRow ruleRow;
    private DTInfo info;
    private List<IBaseCondition> conditions = new ArrayList<IBaseCondition>();
    private List<IBaseAction> actions = new ArrayList<IBaseAction>();
    private boolean hasReturnAction = false;
    private boolean hasCollectReturnAction = false;
    private boolean hasCollectReturnKeyAction = false;
    private String firstUsedReturnActionHeader = null;

    private void addAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, ActionType.ACTION, DTScale.getStandardScale()));
    }

    private void addCondition(String name, int row, ILogicalTable table) {
        this.conditions.add(new Condition(name, row, table, this.getConditionScale(name)));
    }

    private DTScale.RowScale getConditionScale(String name) {
        if (DecisionTableHelper.isValidHConditionHeader(name.toUpperCase())) {
            return this.info.getScale().getHScale();
        }
        return this.info.getScale().getVScale();
    }

    private void addReturnAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, ActionType.RETURN, DTScale.getStandardScale()));
    }

    private void addCollectReturnKeyAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, ActionType.COLLECT_RETURN_KEY, DTScale.getStandardScale()));
    }

    private void addCollectReturnAction(String name, int row, ILogicalTable table) {
        this.actions.add(new Action(name, row, table, ActionType.COLLECT_RETURN, DTScale.getStandardScale()));
    }

    private void addRule(int row, ILogicalTable table, IBindingContext bindingContext) throws SyntaxNodeException {
        if (this.ruleRow != null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Only one rule row/column allowed", (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
        this.ruleRow = new RuleRow(row, table);
    }

    public void loadAndBind(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, OpenL openl, ModuleOpenClass module, IBindingContext bindingContext) throws Exception {
        this.loadTableStructure(tableSyntaxNode, decisionTable, bindingContext);
        IBaseCondition[] conditionsArray = this.conditions.toArray(IBaseCondition.EMPTY);
        IBaseAction[] actionsArray = this.actions.toArray(IBaseAction.EMPTY);
        decisionTable.bindTable(conditionsArray, actionsArray, this.ruleRow, openl, (ComponentOpenClass)module, bindingContext, this.columnsNumber);
    }

    private void loadTableStructure(TableSyntaxNode tableSyntaxNode, DecisionTable decisionTable, IBindingContext bindingContext) throws SyntaxNodeException {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)EMPTY_BODY, (ISyntaxNode)tableSyntaxNode);
        }
        if (DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode)) {
            try {
                tableBody = DecisionTableHelper.preprocessDecisionTableWithoutHeaders(tableSyntaxNode, decisionTable, tableBody, bindingContext);
            }
            catch (OpenLCompilationException e) {
                throw SyntaxNodeExceptionUtils.createError((String)"Can't create a header for a Simple Rules or Lookup Table", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        }
        ILogicalTable toParse = tableBody;
        int nHConditions = DecisionTableHelper.countHConditionsByHeaders(tableBody);
        int nVConditions = DecisionTableHelper.countVConditionsByHeaders(tableBody);
        if (nHConditions > 0) {
            try {
                DecisionTableLookupConvertor dtlc = new DecisionTableLookupConvertor();
                IGridTable convertedTable = dtlc.convertTable(tableBody);
                ILogicalTable offsetConvertedTable = LogicalTableHelper.logicalTable(convertedTable);
                toParse = (ILogicalTable)offsetConvertedTable.transpose();
                this.info = new DTInfo(nHConditions, nVConditions, dtlc.getScale());
            }
            catch (OpenLCompilationException e) {
                throw SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
            catch (Exception e) {
                throw SyntaxNodeExceptionUtils.createError((String)"Can't convert table", (Throwable)e, (ISyntaxNode)tableSyntaxNode);
            }
        } else if (DecisionTableHelper.looksLikeVertical(tableBody)) {
            toParse = (ILogicalTable)tableBody.transpose();
        }
        if (this.needToUnmergeFirstRow(toParse)) {
            toParse = this.unmergeFirstRow(toParse);
        }
        if (this.info == null) {
            this.info = new DTInfo(nHConditions, nVConditions);
        }
        decisionTable.setDtInfo(this.info);
        if (toParse.getWidth() < 4) {
            throw SyntaxNodeExceptionUtils.createError((String)"Invalid structure of decision table", (ISyntaxNode)tableSyntaxNode);
        }
        this.columnsNumber = toParse.getWidth() - 4;
        this.putTableForBusinessView(tableSyntaxNode);
        for (int i = 0; i < toParse.getHeight(); ++i) {
            this.loadRow(i, toParse, decisionTable, bindingContext);
        }
        this.validateMapReturnType(decisionTable, tableSyntaxNode);
    }

    private void validateMapReturnType(DecisionTable decisionTable, TableSyntaxNode tableSyntaxNode) throws SyntaxNodeException {
        if (Map.class.isAssignableFrom(decisionTable.getType().getInstanceClass())) {
            if (this.hasCollectReturnAction && !this.hasCollectReturnKeyAction) {
                throw SyntaxNodeExceptionUtils.createError((String)"Invalid Decision Table headers: At least one KEY header is required.", (ISyntaxNode)tableSyntaxNode);
            }
            if (this.hasCollectReturnKeyAction && !this.hasCollectReturnAction) {
                throw SyntaxNodeExceptionUtils.createError((String)"Invalid Decision Table headers: At least one CRET header is required.", (ISyntaxNode)tableSyntaxNode);
            }
        }
    }

    private ILogicalTable unmergeFirstRow(ILogicalTable toParse) {
        return LogicalTableHelper.unmergeColumns(toParse, 4, toParse.getWidth());
    }

    private boolean needToUnmergeFirstRow(ILogicalTable toParse) {
        String header = this.getHeaderStr(0, toParse);
        return DecisionTableHelper.isConditionHeader(header) && !DecisionTableHelper.isValidMergedConditionHeader(header);
    }

    private void putTableForBusinessView(TableSyntaxNode tableSyntaxNode) {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (DecisionTableHelper.isSmartDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleDecisionTable(tableSyntaxNode) || DecisionTableHelper.isSimpleLookupTable(tableSyntaxNode) || DecisionTableHelper.isSmartLookupTable(tableSyntaxNode)) {
            tableSyntaxNode.getSubTables().put("business", tableBody);
        } else {
            ILogicalTable businessView = null;
            businessView = DecisionTableHelper.looksLikeVertical(tableBody) ? (ILogicalTable)tableBody.getRows(3) : (ILogicalTable)tableBody.getColumns(3);
            tableSyntaxNode.getSubTables().put("business", businessView);
        }
    }

    private String getHeaderStr(int row, ILogicalTable table) {
        String headerStr = ((ILogicalTable)table.getRow(row)).getSource().getCell(0, 0).getStringValue();
        if (headerStr == null) {
            return "";
        }
        return headerStr.toUpperCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadRow(int row, ILogicalTable table, DecisionTable decisionTable, IBindingContext bindingContext) throws SyntaxNodeException {
        String header = this.getHeaderStr(row, table);
        if (DecisionTableHelper.isConditionHeader(header)) {
            this.addCondition(header, row, table);
            return;
        } else if (DecisionTableHelper.isValidActionHeader(header)) {
            this.addAction(header, row, table);
            return;
        } else if (DecisionTableHelper.isValidRuleHeader(header)) {
            this.addRule(row, table, bindingContext);
            return;
        } else if (DecisionTableHelper.isValidKeyHeader(header)) {
            this.addCollectReturnKeyAction(header, row, table);
            this.hasCollectReturnKeyAction = true;
            return;
        } else if (DecisionTableHelper.isValidRetHeader(header)) {
            if (this.hasCollectReturnAction) {
                throw SyntaxNodeExceptionUtils.createError((String)("Invalid Decision Table header: " + header + ". Headers '" + this.firstUsedReturnActionHeader + "' and '" + header + "' can't be used together."), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
            }
            this.addReturnAction(header, row, table);
            this.saveFirstUsedReturnActionHeader(header);
            this.hasReturnAction = true;
            return;
        } else if (DecisionTableHelper.isValidCRetHeader(header)) {
            if (this.hasReturnAction) {
                throw SyntaxNodeExceptionUtils.createError((String)("Invalid Decision Table header: " + header + ". Headers '" + this.firstUsedReturnActionHeader + "' and '" + header + "' can't be used together."), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
            }
            this.hasCollectReturnAction = true;
            this.saveFirstUsedReturnActionHeader(header);
            if (!this.validateCollectReturnType(decisionTable)) throw SyntaxNodeExceptionUtils.createError((String)("Incompatible method return type with '" + header + "' header."), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
            this.addCollectReturnAction(header, row, table);
            return;
        } else {
            if (ParserUtils.isBlankOrCommented(header)) return;
            throw SyntaxNodeExceptionUtils.createError((String)("Invalid Decision Table header: " + header), (IOpenSourceCodeModule)new GridCellSourceCodeModule(((ILogicalTable)table.getRow(row)).getSource(), 0, 0, bindingContext));
        }
    }

    private void saveFirstUsedReturnActionHeader(String header) {
        if (this.firstUsedReturnActionHeader == null) {
            this.firstUsedReturnActionHeader = header;
        }
    }

    private boolean validateCollectReturnType(DecisionTable decisionTable) {
        IOpenClass type = decisionTable.getType();
        if (type.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type.getInstanceClass())) {
            return true;
        }
        return Map.class.isAssignableFrom(type.getInstanceClass());
    }
}

