/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Arrays;
import java.util.Set;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.IDecisionTableRuleNodeV2;
import org.openl.rules.dt.index.IRuleIndex;

public class RangeIndexDecisionTableRuleNode
extends DecisionTableRuleNode
implements IDecisionTableRuleNodeV2 {
    private final Set<Integer> ruleSet;
    private final IRuleIndex nextIndex;

    public RangeIndexDecisionTableRuleNode(Set<Integer> ruleSet, IRuleIndex nextIndex) {
        super(null);
        this.ruleSet = ruleSet;
        this.nextIndex = nextIndex;
    }

    @Override
    public Set<Integer> getRuleSet() {
        return this.ruleSet;
    }

    @Override
    public int[] getRules() {
        int[] result = new int[this.ruleSet.size()];
        int i = 0;
        for (Integer it : this.ruleSet) {
            result[i++] = it;
        }
        Arrays.sort(result);
        return result;
    }

    @Override
    public IRuleIndex getNextIndex() {
        return this.nextIndex;
    }

    @Override
    public boolean hasIndex() {
        return this.nextIndex != null;
    }
}

