/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import org.openl.rules.table.CoordinatesTransformer;
import org.openl.rules.table.IGridTable;

public class TwoDimensionDecisionTableTranformer
implements CoordinatesTransformer {
    private static final int CONDITION_HEADERS_HEIGHT = 4;
    private static final int HCONDITION_HEADERS_HEIGHT = 3;
    private int conditionsWidth;
    private int hConditionsCount;
    private int lookupValuesTableHeight;
    private int lookupValuesTableWidth;
    private int retTableWidth;
    private int dtHeaderHeight;

    TwoDimensionDecisionTableTranformer(IGridTable entireTable, IGridTable lookupValuesTable, int retTableWidth) {
        this.lookupValuesTableHeight = lookupValuesTable.getHeight();
        this.lookupValuesTableWidth = lookupValuesTable.getWidth();
        this.conditionsWidth = entireTable.getWidth() - this.lookupValuesTableWidth;
        this.hConditionsCount = entireTable.getHeight() - this.lookupValuesTableHeight - 3;
        this.retTableWidth = retTableWidth;
        this.dtHeaderHeight = 4 + (this.hConditionsCount - 1);
    }

    int getRetTableWidth() {
        return this.retTableWidth;
    }

    @Override
    public int getHeight() {
        return this.dtHeaderHeight + this.lookupValuesTableWidth / this.retTableWidth * this.lookupValuesTableHeight;
    }

    @Override
    public int getWidth() {
        return this.conditionsWidth + this.hConditionsCount + this.retTableWidth;
    }

    @Override
    public int getColumn(int col, int row) {
        int res;
        if (row < this.dtHeaderHeight) {
            res = col;
        } else if (col < this.conditionsWidth) {
            res = col;
        } else if (col < this.conditionsWidth + this.hConditionsCount) {
            int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
            res = this.conditionsWidth + hConditionValueIndex;
        } else {
            int hConditionValueIndex = (row - this.dtHeaderHeight) / this.lookupValuesTableHeight * this.retTableWidth;
            res = this.conditionsWidth + hConditionValueIndex + (col - this.conditionsWidth - this.hConditionsCount);
        }
        return res;
    }

    @Override
    public int getRow(int col, int row) {
        int res;
        if (row < this.dtHeaderHeight) {
            res = row;
        } else if (col < this.conditionsWidth) {
            int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
            res = this.dtHeaderHeight + conditionValueIndex;
        } else if (col < this.conditionsWidth + this.hConditionsCount) {
            int hConditionIndex = col - this.conditionsWidth;
            res = 3 + hConditionIndex;
        } else {
            int conditionValueIndex = (row - this.dtHeaderHeight) % this.lookupValuesTableHeight;
            res = 3 + this.hConditionsCount + conditionValueIndex;
        }
        return res;
    }
}

