/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.ARangeIndexEvaluator;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.CombinedRangeIndex;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.index.RangeAscIndex;
import org.openl.rules.dt.index.RangeDescIndex;
import org.openl.rules.dt.type.IRangeAdaptor;

public class CombinedRangeIndexEvaluator
extends ARangeIndexEvaluator {
    public CombinedRangeIndexEvaluator(IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor, int paramsN) {
        super(rangeAdaptor, paramsN);
    }

    @Override
    public IRuleIndex makeIndex(ICondition condition, IIntIterator it) {
        if (it.size() < 1) {
            return null;
        }
        DecisionTableRuleNodeBuilder nextNodeBuilder = new DecisionTableRuleNodeBuilder();
        DecisionTableRuleNodeBuilder emptyRulesBuilder = new DecisionTableRuleNodeBuilder();
        List<ARangeIndexEvaluator.IndexNode> minIndexNodes = this.collectMinIndexNodes(condition, it, nextNodeBuilder, emptyRulesBuilder);
        ARangeIndexEvaluator.RangeIndexNodeAdaptor indexNodeAdaptor = new ARangeIndexEvaluator.RangeIndexNodeAdaptor(this.rangeAdaptor);
        RangeAscIndex minIndex = new RangeAscIndex(null, minIndexNodes, indexNodeAdaptor, emptyRulesBuilder.makeNode().getRules());
        it.reset();
        emptyRulesBuilder = new DecisionTableRuleNodeBuilder();
        List<ARangeIndexEvaluator.IndexNode> maxIndexNodes = this.collectMaxIndexNodes(condition, it, emptyRulesBuilder);
        RangeDescIndex maxIndex = new RangeDescIndex(null, maxIndexNodes, indexNodeAdaptor, emptyRulesBuilder.makeNode().getRules());
        return new CombinedRangeIndex(minIndex, maxIndex, nextNodeBuilder.makeNode());
    }

    private List<ARangeIndexEvaluator.IndexNode> collectMinIndexNodes(ICondition condition, IIntIterator it, DecisionTableRuleNodeBuilder nextNodeBuilder, DecisionTableRuleNodeBuilder emptyRulesBuilder) {
        ArrayList<ARangeIndexEvaluator.IndexNode> nodes = new ArrayList<ARangeIndexEvaluator.IndexNode>(it.size());
        while (it.hasNext()) {
            int ruleN = it.nextInt();
            nextNodeBuilder.addRule(ruleN);
            Object origVal = condition.getParamValue(0, ruleN);
            if (origVal == null) {
                emptyRulesBuilder.addRule(ruleN);
                continue;
            }
            Comparable vFrom = this.rangeAdaptor == null ? (Comparable)origVal : this.rangeAdaptor.getMin(origVal);
            nodes.add(new ARangeIndexEvaluator.IndexNode((Comparable<Object>)vFrom, ruleN));
        }
        return this.mergeRulesByValue(nodes);
    }

    private List<ARangeIndexEvaluator.IndexNode> collectMaxIndexNodes(ICondition condition, IIntIterator it, DecisionTableRuleNodeBuilder emptyRulesBuilder) {
        int paramN;
        ArrayList<ARangeIndexEvaluator.IndexNode> nodes = new ArrayList<ARangeIndexEvaluator.IndexNode>(it.size());
        int n = paramN = this.nparams == 2 ? 1 : 0;
        while (it.hasNext()) {
            int ruleN = it.nextInt();
            Object origVal = condition.getParamValue(paramN, ruleN);
            if (origVal == null) {
                emptyRulesBuilder.addRule(ruleN);
                continue;
            }
            Comparable vTo = this.rangeAdaptor == null ? (Comparable)origVal : this.rangeAdaptor.getMax(origVal);
            nodes.add(new ARangeIndexEvaluator.IndexNode((Comparable<Object>)vTo, ruleN));
        }
        return this.mergeRulesByValue(nodes);
    }
}

