/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.Collection;
import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.ActionType;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class Action
extends FunctionalRow
implements IAction {
    private static final String EXTRA_RET = "e$x$t$r$a$R$e$t";
    private boolean isSingleReturnParam = false;
    private IOpenClass returnType;
    private ActionType actionType;

    public Action(String name, int row, ILogicalTable decisionTable, ActionType actionType, DTScale.RowScale scale) {
        super(name, row, decisionTable, scale);
        this.actionType = actionType;
    }

    @Override
    public boolean isAction() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public boolean isReturnAction() {
        return ActionType.RETURN.equals((Object)this.actionType);
    }

    @Override
    public boolean isCollectReturnKeyAction() {
        return ActionType.COLLECT_RETURN_KEY.equals((Object)this.actionType);
    }

    @Override
    public boolean isCollectReturnAction() {
        return ActionType.COLLECT_RETURN.equals((Object)this.actionType);
    }

    @Override
    public Object executeAction(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isSingleReturnParam) {
            if (this.isEmpty(ruleN)) {
                return null;
            }
            Object[] dest = new Object[this.getNumberOfParams()];
            this.loadValues(dest, 0, ruleN, target, params, env);
            Object returnValue = dest[0];
            CompositeMethod method = this.getMethod();
            IOpenClass returnType = method.getType();
            if (returnValue == null || ClassUtils.isAssignable(returnValue.getClass(), (Class)returnType.getInstanceClass())) {
                return returnValue;
            }
            return this.executeActionInternal(ruleN, target, params, env);
        }
        return this.executeActionInternal(ruleN, target, params, env);
    }

    private Object executeActionInternal(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (this.isEmpty(ruleN)) {
            return null;
        }
        return this.getMethod().invoke(target, this.mergeParams(target, params, env, ruleN), env);
    }

    private IOpenClass exctractMethodTypeForCollectReturnAction(IOpenClass type) {
        if (type.isArray()) {
            return type.getComponentClass();
        }
        if (Collection.class.isAssignableFrom(type.getInstanceClass())) {
            return JavaOpenClass.OBJECT;
        }
        if (Map.class.isAssignableFrom(type.getInstanceClass())) {
            return JavaOpenClass.OBJECT;
        }
        return type;
    }

    @Override
    public void prepareAction(IOpenMethodHeader header, IMethodSignature signature, OpenL openl, IBindingContext bindingContext, RuleRow ruleRow, IOpenClass ruleExecutionType, TableSyntaxNode tableSyntaxNode) throws Exception {
        this.returnType = header.getType();
        JavaOpenClass methodType = JavaOpenClass.VOID;
        if (this.isReturnAction()) {
            methodType = header.getType();
        } else if (this.isCollectReturnAction()) {
            methodType = this.exctractMethodTypeForCollectReturnAction(header.getType());
        } else if (this.isCollectReturnKeyAction()) {
            methodType = JavaOpenClass.OBJECT;
        }
        this.prepare((IOpenClass)methodType, signature, openl, bindingContext, ruleRow, ruleExecutionType, tableSyntaxNode);
        IParameterDeclaration[] params = this.getParams();
        CompositeMethod method = this.getMethod();
        String code = method.getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        this.isSingleReturnParam = params.length == 1 && params[0].getName().equals(code);
    }

    @Override
    public IOpenClass getType() {
        return this.returnType;
    }

    @Override
    protected IParameterDeclaration[] getParams(IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (EXTRA_RET.equals(methodSource.getCode()) && (this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction()) && this.getParams() == null) {
            ParameterDeclaration extraParam = new ParameterDeclaration(methodType, EXTRA_RET);
            IParameterDeclaration[] parameterDeclarations = new IParameterDeclaration[]{extraParam};
            this.setParams(parameterDeclarations);
            return this.getParams();
        }
        return super.getParams(methodSource, signature, declaringClass, methodType, openl, bindingContext);
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext, OpenL openl, IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType) throws Exception {
        IOpenSourceCodeModule source = super.getExpressionSource(bindingContext, openl, declaringClass, signature, methodType);
        if ((this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction()) && StringUtils.isEmpty((CharSequence)source.getCode()) && this.getParams() == null) {
            return new StringSourceCodeModule(EXTRA_RET, source.getUri());
        }
        return source;
    }

    @Override
    public void removeDebugInformation() {
        this.getMethod().removeDebugInformation();
        if (this.storage != null) {
            for (IStorage st : this.storage) {
                int rules = st.size();
                for (int i = 0; i < rules; ++i) {
                    Object paramValue = st.getValue(i);
                    if (!(paramValue instanceof CompositeMethod)) continue;
                    ((CompositeMethod)paramValue).removeDebugInformation();
                }
            }
        }
    }
}

