/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.Date;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.DecisionValue;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.table.ILogicalTable;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.vm.IRuntimeEnv;

public class Condition
extends FunctionalRow
implements ICondition {
    private IMethodCaller evaluator;
    private IConditionEvaluator conditionEvaluator;
    private IOpenSourceCodeModule userDefinedOpenSourceCodeModule;

    public Condition(String name, int row, ILogicalTable table, DTScale.RowScale scale) {
        super(name, row, table, scale);
    }

    @Override
    public IConditionEvaluator getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    @Override
    public void setConditionEvaluator(IConditionEvaluator conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }

    @Override
    public boolean isAction() {
        return false;
    }

    @Override
    public boolean isCondition() {
        return true;
    }

    @Override
    public IMethodCaller getEvaluator() {
        return this.evaluator == null ? this.getMethod() : this.evaluator;
    }

    @Override
    public void setEvaluator(IMethodCaller evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public DecisionValue calculateCondition(int ruleN, Object target, Object[] dtParams, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isEmpty(ruleN)) {
            return DecisionValue.NxA_VALUE;
        }
        Object[] params = this.mergeParams(target, dtParams, env, ruleN);
        Object result = this.getMethod().invoke(target, params, env);
        if (Boolean.TRUE.equals(result)) {
            return DecisionValue.TRUE_VALUE;
        }
        return DecisionValue.FALSE_VALUE;
    }

    private IOpenField getLocalField(IOpenField f) {
        if (f instanceof ILocalVar) {
            return f;
        }
        if (f instanceof OpenFieldDelegator) {
            OpenFieldDelegator d = (OpenFieldDelegator)f;
            return d.getField();
        }
        return f;
    }

    @Override
    public boolean isDependentOnAnyParams() {
        IParameterDeclaration[] params = this.getParams();
        RulesBindingDependencies dependencies = new RulesBindingDependencies();
        this.getMethod().updateDependency((BindingDependencies)dependencies);
        for (IOpenField field : dependencies.getFieldsMap().values()) {
            if (!((field = this.getLocalField(field)) instanceof ILocalVar)) continue;
            for (IParameterDeclaration param : params) {
                if (!param.getName().equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IOpenSourceCodeModule getUserDefinedExpressionSource() {
        if (this.userDefinedOpenSourceCodeModule == null) {
            return this.getSourceCodeModule();
        }
        return this.userDefinedOpenSourceCodeModule;
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(IBindingContext bindingContext, OpenL openl, IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType) throws Exception {
        IOpenSourceCodeModule source = super.getExpressionSource(bindingContext, openl, declaringClass, signature, methodType);
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            if (!signature.getParameterName(i).equals(source.getCode())) continue;
            this.userDefinedOpenSourceCodeModule = source;
            IParameterDeclaration[] params = this.getParams(source, signature, declaringClass, methodType, openl, bindingContext);
            if (params.length == 1) {
                if (params[0].getType().isArray() && params[0].getType().getComponentClass().getInstanceClass() != null && params[0].getType().getComponentClass().getInstanceClass().isAssignableFrom(signature.getParameterType(i).getInstanceClass())) {
                    return !this.hasFormulas() ? source : new StringSourceCodeModule("contains(" + params[0].getName() + ", " + source.getCode() + ")", source.getUri());
                }
                boolean rangeExpression = false;
                if (INumberRange.class.isAssignableFrom(params[0].getType().getInstanceClass()) && Number.class.isAssignableFrom(signature.getParameterType(i).getInstanceClass())) {
                    rangeExpression = true;
                } else if (INumberRange.class.isAssignableFrom(params[0].getType().getInstanceClass()) && signature.getParameterType(i).getInstanceClass().isPrimitive() && !Character.TYPE.equals(signature.getParameterType(i).getInstanceClass())) {
                    rangeExpression = true;
                } else if (DateRange.class.isAssignableFrom(params[0].getType().getInstanceClass()) && Date.class.isAssignableFrom(signature.getParameterType(i).getInstanceClass())) {
                    rangeExpression = true;
                } else if (CharRange.class.isAssignableFrom(params[0].getType().getInstanceClass()) && (Character.class.isAssignableFrom(signature.getParameterType(i).getInstanceClass()) || Character.TYPE.equals(signature.getParameterType(i).getInstanceClass()))) {
                    rangeExpression = true;
                } else if (StringRange.class.isAssignableFrom(params[0].getType().getInstanceClass()) && CharSequence.class.isAssignableFrom(signature.getParameterType(i).getInstanceClass())) {
                    rangeExpression = true;
                }
                if (rangeExpression) {
                    return !this.hasFormulas() ? source : new StringSourceCodeModule(params[0].getName() + ".contains(" + source.getCode() + ")", source.getUri());
                }
                return !this.hasFormulas() && (!params[0].getType().isArray() || !signature.getParameterType(i).isArray()) ? source : new StringSourceCodeModule(source.getCode() + " == " + params[0].getName(), source.getUri());
            }
            if (params.length != 2) continue;
            return !this.hasFormulas() ? source : new StringSourceCodeModule(params[0].getName() + "<=" + source.getCode() + " and " + source.getCode() + "<" + params[1].getName(), source.getUri());
        }
        return source;
    }

    @Override
    public void removeDebugInformation() {
        this.getMethod().removeDebugInformation();
    }

    @Override
    public int getNumberOfEmptyRules(int paramIndex) {
        if (this.storage != null) {
            return this.storage[paramIndex].getInfo().getNumberOfSpaces();
        }
        return 0;
    }
}

