/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.index;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.openl.rules.dt.DecisionTableRuleNode;
import org.openl.rules.dt.index.IRuleIndex;

public abstract class ARuleIndex
implements IRuleIndex {
    private DecisionTableRuleNode emptyOrFormulaNodes;

    ARuleIndex(DecisionTableRuleNode emptyOrFormulaNodes) {
        this.emptyOrFormulaNodes = emptyOrFormulaNodes;
    }

    @Override
    public DecisionTableRuleNode getEmptyOrFormulaNodes() {
        return this.emptyOrFormulaNodes;
    }

    @Override
    public DecisionTableRuleNode findNode(Object value, DecisionTableRuleNode prevResult) {
        if (value == null) {
            return this.emptyOrFormulaNodes;
        }
        DecisionTableRuleNode node = this.findNodeInIndex(value);
        return node == null ? this.emptyOrFormulaNodes : node;
    }

    abstract DecisionTableRuleNode findNodeInIndex(Object var1);

    @Override
    public abstract Iterable<? extends DecisionTableRuleNode> nodes();

    @Override
    public int[] collectRules() {
        HashSet<Integer> set = new HashSet<Integer>();
        for (DecisionTableRuleNode decisionTableRuleNode : this.nodes()) {
            int[] rules;
            for (int rule : rules = decisionTableRuleNode.getRules()) {
                set.add(rule);
            }
        }
        if (this.emptyOrFormulaNodes != null) {
            int[] rules;
            for (int rule : rules = this.emptyOrFormulaNodes.getRules()) {
                set.add(rule);
            }
        }
        int[] res = new int[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < res.length && iterator.hasNext(); ++i) {
            res[i] = (Integer)iterator.next();
        }
        Arrays.sort(res);
        return res;
    }
}

