/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.ReadOnlyStorage;
import org.openl.rules.dt.storage.StorageInfo;
import org.openl.rules.dt.storage.StorageUtils;

abstract class MappedStorage
extends ReadOnlyStorage<Object> {
    private Object[] uniqueValues;

    MappedStorage(Object[] uniqueValues, StorageInfo info) {
        super(info);
        this.uniqueValues = uniqueValues;
    }

    @Override
    public Object getValue(int index) {
        return this.uniqueValues[this.mapIndex(index)];
    }

    protected abstract int mapIndex(int var1);

    @Override
    public boolean isSpace(int index) {
        return this.uniqueValues[this.mapIndex(index)] == null;
    }

    @Override
    public boolean isFormula(int index) {
        return StorageUtils.isFormula(this.uniqueValues[this.mapIndex(index)]);
    }

    @Override
    public boolean isElse(int index) {
        return this.uniqueValues[this.mapIndex(index)] == IStorage.StorageType.ELSE;
    }
}

