/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type;

import org.openl.rules.dt.type.BooleanFieldAdaptor;
import org.openl.rules.dt.type.BooleanMethodAdaptor;
import org.openl.rules.dt.type.BooleanTypeAdaptor;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;

public class BooleanAdaptorFactory {
    private static final String BOOLEAN_VALUE = "booleanValue";

    private BooleanAdaptorFactory() {
    }

    public static BooleanTypeAdaptor getAdaptor(IOpenClass openClass) {
        if (Boolean.TYPE.equals(openClass.getInstanceClass()) || Boolean.class.equals((Object)openClass.getInstanceClass())) {
            return new BooleanTypeAdaptor();
        }
        IOpenMethod method = openClass.getMethod(BOOLEAN_VALUE, IOpenClass.EMPTY);
        if (method != null) {
            return new BooleanMethodAdaptor(method);
        }
        IOpenField field = openClass.getField(BOOLEAN_VALUE, true);
        if (field != null) {
            return new BooleanFieldAdaptor(field);
        }
        return null;
    }
}

