/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.fuzzy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.rules.fuzzy.Token;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;

public final class OpenLFuzzyUtils {
    private static final double ACCEPTABLE_SIMILARITY_VALUE = 0.85;
    private static final int DEEP_LEVEL = 5;
    private static final ThreadLocal<Map<IOpenClass, Map<String, Map<Token, IOpenMethod[][]>>>> openlClassRecursivelyCacheForSetterMethods = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<IOpenClass, Map<String, Map<Token, IOpenMethod[][]>>>> openlClassRecursivelyCacheForGetterMethods = ThreadLocal.withInitial(HashMap::new);
    private static final ThreadLocal<Map<IOpenClass, Map<Token, IOpenMethod[]>>> openlClassCacheForSetterMethods = ThreadLocal.withInitial(HashMap::new);

    private OpenLFuzzyUtils() {
    }

    public static void clearCaches() {
        openlClassCacheForSetterMethods.remove();
        openlClassRecursivelyCacheForGetterMethods.remove();
        openlClassRecursivelyCacheForSetterMethods.remove();
    }

    public static Map<Token, IOpenMethod[]> tokensMapToOpenClassSetterMethods(IOpenClass openClass) {
        Map<IOpenClass, Map<Token, IOpenMethod[]>> cache = openlClassCacheForSetterMethods.get();
        Map<Token, IOpenMethod[]> ret = cache.get(openClass);
        if (ret == null) {
            ret = new HashMap<Token, IOpenMethod[]>();
            HashMap<Token, LinkedList> map = new HashMap<Token, LinkedList>();
            if (!openClass.isSimple()) {
                for (IOpenMethod iOpenMethod : openClass.getMethods()) {
                    String fieldName;
                    IOpenField openField;
                    if (iOpenMethod.isStatic() || iOpenMethod.getSignature().getNumberOfParameters() != 1 || !iOpenMethod.getName().startsWith("set") || (openField = openClass.getField(fieldName = iOpenMethod.getName().substring(3), false)) == null) continue;
                    String t = OpenLFuzzyUtils.toTokenString(fieldName);
                    LinkedList m = null;
                    for (Map.Entry entry : map.entrySet()) {
                        Token token = (Token)entry.getKey();
                        if (!token.getValue().equals(t)) continue;
                        m = (LinkedList)entry.getValue();
                        break;
                    }
                    if (m == null) {
                        m = new LinkedList();
                        m.add(iOpenMethod);
                        map.put(new Token(t, 0), m);
                        continue;
                    }
                    m.add(iOpenMethod);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                ret.put((Token)entry.getKey(), ((LinkedList)entry.getValue()).toArray(new IOpenMethod[0]));
            }
            cache.put(openClass, ret);
        }
        return ret;
    }

    public static Map<Token, IOpenMethod[][]> tokensMapToOpenClassSetterMethodsRecursively(IOpenClass openClass) {
        return OpenLFuzzyUtils.tokensMapToOpenClassSetterMethodsRecursively(openClass, null, 0);
    }

    public static Map<Token, IOpenMethod[][]> tokensMapToOpenClassSetterMethodsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel) {
        return OpenLFuzzyUtils.tokensMapToOpenClassMethodsRecursively(openClass, tokenPrefix, startLevel, true);
    }

    public static Map<Token, IOpenMethod[][]> tokensMapToOpenClassGetterMethodsRecursively(IOpenClass openClass) {
        return OpenLFuzzyUtils.tokensMapToOpenClassGetterMethodsRecursively(openClass, null, 0);
    }

    public static Map<Token, IOpenMethod[][]> tokensMapToOpenClassGetterMethodsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel) {
        return OpenLFuzzyUtils.tokensMapToOpenClassMethodsRecursively(openClass, tokenPrefix, startLevel, false);
    }

    private static Map<Token, IOpenMethod[][]> tokensMapToOpenClassMethodsRecursively(IOpenClass openClass, String tokenPrefix, int startLevel, boolean setterMethods) {
        String tokenizedPrefix;
        Map<IOpenClass, Map<String, Map<Token, IOpenMethod[][]>>> cache = null;
        cache = setterMethods ? openlClassRecursivelyCacheForSetterMethods.get() : openlClassRecursivelyCacheForGetterMethods.get();
        Map cache1 = cache.computeIfAbsent(openClass, e -> new HashMap());
        HashMap<Token, IOpenMethod[][]> ret = (HashMap<Token, IOpenMethod[][]>)cache1.get(tokenizedPrefix = OpenLFuzzyUtils.toTokenString(tokenPrefix));
        if (ret == null) {
            Map<Token, LinkedList<LinkedList<IOpenMethod>>> map = null;
            if (StringUtils.isBlank((CharSequence)tokenPrefix)) {
                map = OpenLFuzzyUtils.buildTokensMapToOpenClassMethodsRecursively(openClass, startLevel, setterMethods);
            } else {
                map = OpenLFuzzyUtils.buildTokensMapToOpenClassMethodsRecursively(openClass, startLevel, setterMethods);
                HashMap<Token, LinkedList<LinkedList<IOpenMethod>>> updatedMap = new HashMap<Token, LinkedList<LinkedList<IOpenMethod>>>(map);
                for (Map.Entry<Token, LinkedList<LinkedList<IOpenMethod>>> entry : map.entrySet()) {
                    Token updatedToken = new Token(OpenLFuzzyUtils.toTokenString(tokenizedPrefix + " " + entry.getKey().getValue()), entry.getKey().getDistance());
                    updatedMap.put(updatedToken, entry.getValue());
                }
                map = updatedMap;
            }
            HashMap<Token, LinkedList[]> tmp = new HashMap<Token, LinkedList[]>();
            for (Map.Entry<Token, LinkedList<LinkedList<IOpenMethod>>> entry : map.entrySet()) {
                tmp.put(entry.getKey(), entry.getValue().toArray(new LinkedList[0]));
            }
            ret = new HashMap<Token, IOpenMethod[][]>();
            for (Map.Entry<Token, LinkedList<LinkedList<Object>>> entry : tmp.entrySet()) {
                IOpenMethod[][] m = new IOpenMethod[((LinkedList[])entry.getValue()).length][];
                int i = 0;
                for (LinkedList x : (LinkedList[])entry.getValue()) {
                    m[i] = x.toArray(new IOpenMethod[0]);
                    ++i;
                }
                ret.put(entry.getKey(), m);
            }
            cache1.put(tokenizedPrefix, ret);
        }
        return ret;
    }

    public static boolean isEqualsMethodChains(IOpenMethod[] methodChain1, IOpenMethod[] methodChain2) {
        if (methodChain1 == methodChain2) {
            return true;
        }
        return Arrays.deepEquals(methodChain1, methodChain2);
    }

    public static boolean isSetterMethod(IOpenMethod method) {
        return !method.isStatic() && method.getSignature().getNumberOfParameters() == 1 && method.getName().startsWith("set") && JavaOpenClass.isVoid((IOpenClass)method.getType());
    }

    public static boolean isGetterMethod(IOpenMethod method) {
        return !method.isStatic() && method.getSignature().getNumberOfParameters() == 0 && method.getName().startsWith("get");
    }

    private static Map<Token, LinkedList<LinkedList<IOpenMethod>>> buildTokensMapToOpenClassMethodsRecursively(IOpenClass openClass, int deepLevel, boolean setterMethods) {
        if (deepLevel >= 5) {
            return Collections.emptyMap();
        }
        HashMap<Token, LinkedList<LinkedList<IOpenMethod>>> ret = new HashMap<Token, LinkedList<LinkedList<IOpenMethod>>>();
        if (!openClass.isSimple()) {
            for (IOpenMethod method : openClass.getMethods()) {
                String fieldName;
                IOpenField openField;
                boolean g = setterMethods ? OpenLFuzzyUtils.isSetterMethod(method) : OpenLFuzzyUtils.isGetterMethod(method);
                if (!g || (openField = openClass.getField(fieldName = method.getName().substring(3), false)) == null) continue;
                String t = OpenLFuzzyUtils.toTokenString(fieldName);
                LinkedList<IOpenMethod> methods = new LinkedList<IOpenMethod>();
                methods.add(method);
                LinkedList x = null;
                for (Map.Entry entry : ret.entrySet()) {
                    Token token = (Token)entry.getKey();
                    if (!token.getValue().equals(t) || ((Token)entry.getKey()).getDistance() != deepLevel) continue;
                    x = (LinkedList)entry.getValue();
                    break;
                }
                if (x == null) {
                    x = new LinkedList();
                    x.add(methods);
                    ret.put(new Token(t, deepLevel), x);
                } else {
                    x.add(methods);
                }
                IOpenClass type = null;
                type = setterMethods ? method.getSignature().getParameterType(0) : method.getType();
                if (type.isSimple() || type.isArray()) continue;
                Map<Token, LinkedList<LinkedList<IOpenMethod>>> map = OpenLFuzzyUtils.buildTokensMapToOpenClassMethodsRecursively(type, deepLevel + 1, setterMethods);
                for (Map.Entry<Token, LinkedList<LinkedList<IOpenMethod>>> entry : map.entrySet()) {
                    LinkedList<IOpenMethod> y1;
                    if (entry.getValue().isEmpty()) continue;
                    Token k = new Token(t + " " + entry.getKey().getValue(), entry.getKey().getDistance() + 1);
                    LinkedList v = ret.computeIfAbsent(k, e -> new LinkedList());
                    for (LinkedList linkedList : entry.getValue()) {
                        y1 = new LinkedList<IOpenMethod>(linkedList);
                        y1.addFirst(method);
                        v.add(y1);
                    }
                    v = ret.computeIfAbsent(entry.getKey(), e -> new LinkedList());
                    for (LinkedList linkedList : entry.getValue()) {
                        y1 = new LinkedList(linkedList);
                        y1.addFirst(method);
                        v.add(y1);
                    }
                }
            }
        }
        return ret;
    }

    private static String[] concatTokens(String[] tokens, String pattern) {
        ArrayList<String> t = new ArrayList<String>();
        StringBuilder sbBuilder = new StringBuilder();
        boolean g = false;
        for (String s : tokens) {
            if (s.length() == 1 && s.matches(pattern)) {
                g = true;
                sbBuilder.append(s);
                continue;
            }
            if (g) {
                t.add(sbBuilder.toString());
                g = false;
                sbBuilder = new StringBuilder();
            }
            t.add(s);
        }
        if (g) {
            t.add(sbBuilder.toString());
        }
        return t.toArray(new String[0]);
    }

    private static String[] cleanUpTokens(String[] tokens) {
        ArrayList<String> t = new ArrayList<String>();
        for (String token : tokens) {
            String s = token.trim().toLowerCase();
            if (s.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isLetterOrDigit(s.charAt(i))) continue;
                sb.append(s.charAt(i));
            }
            if (sb.toString().length() <= 0) continue;
            t.add(sb.toString());
        }
        return t.toArray(new String[0]);
    }

    public static String toTokenString(String source) {
        if (source == null) {
            return "";
        }
        String[] tokens = source.split("(?<=.)(?=\\p{Lu}|\\d|\\s|[_])");
        tokens = OpenLFuzzyUtils.concatTokens(tokens, "\\p{Lu}+");
        tokens = OpenLFuzzyUtils.concatTokens(tokens, "\\d+");
        tokens = OpenLFuzzyUtils.cleanUpTokens(tokens);
        StringBuilder sb = new StringBuilder();
        boolean f = false;
        for (String s : tokens) {
            if (!f) {
                f = true;
            } else {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static List<FuzzyResult> openlFuzzyExtract(String source, Token[] tokens, boolean ignoreDistances) {
        source = OpenLFuzzyUtils.toTokenString(source);
        String[] sourceTokens = source.split(" ");
        String[][] tokensList = new String[tokens.length][];
        for (int i = 0; i < tokens.length; ++i) {
            tokensList[i] = tokens[i].getValue().split(" ");
        }
        ArrayList<Pair> similarity = new ArrayList<Pair>();
        Object[] sortedSourceTokens = new String[sourceTokens.length];
        System.arraycopy(sourceTokens, 0, sortedSourceTokens, 0, sourceTokens.length);
        Arrays.sort(sortedSourceTokens);
        int[] f = new int[tokensList.length];
        int max = 0;
        for (int i = 0; i < tokensList.length; ++i) {
            Object[] sortedTokens = new String[tokensList[i].length];
            System.arraycopy(tokensList[i], 0, sortedTokens, 0, tokensList[i].length);
            Arrays.sort(sortedTokens);
            int l = 0;
            int r = 0;
            int c = 0;
            ArrayList<Object> source1 = new ArrayList<Object>();
            ArrayList<Object> target1 = new ArrayList<Object>();
            while (l < sortedSourceTokens.length && r < sortedTokens.length) {
                double d = StringUtils.getJaroWinklerDistance((CharSequence)sortedSourceTokens[l], (CharSequence)sortedTokens[r]);
                if (d > 0.85) {
                    source1.add(sortedSourceTokens[l]);
                    target1.add(sortedTokens[r]);
                    ++l;
                    ++r;
                    ++c;
                    continue;
                }
                if (((String)sortedSourceTokens[l]).compareTo((String)sortedTokens[r]) < 0) {
                    ++l;
                    continue;
                }
                ++r;
            }
            if (max < c) {
                max = c;
            }
            f[i] = c;
            similarity.add(Pair.of((Object)source1.stream().collect(Collectors.joining(" ")), (Object)target1.stream().collect(Collectors.joining(" "))));
        }
        if (max == 0) {
            return Collections.emptyList();
        }
        int min = Integer.MAX_VALUE;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < tokensList.length; ++i) {
            if (f[i] != max) continue;
            if (min > tokensList[i].length - f[i]) {
                min = tokensList[i].length - f[i];
            }
            if (minDistance <= tokens[i].getDistance()) continue;
            minDistance = tokens[i].getDistance();
        }
        ArrayList<Token> ret = new ArrayList<Token>();
        int best = 0;
        int bestL = Integer.MAX_VALUE;
        for (int i = 0; i < tokensList.length; ++i) {
            if (f[i] != max || tokensList[i].length - f[i] != min || !ignoreDistances && tokens[i].getDistance() != minDistance) continue;
            Pair pair = (Pair)similarity.get(i);
            if (!ignoreDistances) {
                int d = StringUtils.getFuzzyDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()), (Locale)Locale.ENGLISH);
                if (d > best) {
                    best = d;
                    bestL = StringUtils.getLevenshteinDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()));
                    ret.clear();
                    ret.add(tokens[i]);
                    continue;
                }
                if (d != best) continue;
                int l = StringUtils.getLevenshteinDistance((CharSequence)((CharSequence)pair.getRight()), (CharSequence)((CharSequence)pair.getLeft()));
                if (l < bestL) {
                    bestL = l;
                    ret.clear();
                    ret.add(tokens[i]);
                    continue;
                }
                if (l != bestL) continue;
                ret.add(tokens[i]);
                continue;
            }
            ret.add(tokens[i]);
        }
        int max1 = max;
        int min1 = min;
        return ret.stream().map(e -> new FuzzyResult((Token)e, max1, min1)).collect(Collectors.toList());
    }

    public static final class FuzzyResult
    implements Comparable<FuzzyResult> {
        Token token;
        int max;
        int min;

        public FuzzyResult(Token token, int max, int min) {
            this.token = token;
            this.max = max;
            this.min = min;
        }

        @Override
        public int compareTo(FuzzyResult o) {
            if (this.max > o.max) {
                return -1;
            }
            if (this.max < o.max) {
                return 1;
            }
            if (this.min > o.min) {
                return 1;
            }
            if (this.min < o.min) {
                return -1;
            }
            if (this.token.getDistance() > o.token.getDistance()) {
                return 1;
            }
            if (this.token.getDistance() < o.token.getDistance()) {
                return -1;
            }
            return 0;
        }

        public Token getToken() {
            return this.token;
        }

        public int getMax() {
            return this.max;
        }

        public int getMin() {
            return this.min;
        }
    }
}

