/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import org.openl.rules.helpers.RangeParser;
import org.openl.util.RangeWithBounds;
import org.openl.util.StringUtils;

public abstract class BaseRangeParser
implements RangeParser {
    protected String minNumber = "";
    protected String minMultiplier = "";
    protected String maxNumber = "";
    protected String maxMultiplier = "";

    public String getMinNumber() {
        return this.minNumber;
    }

    public String getMaxNumber() {
        return this.maxNumber;
    }

    public String getMinMultiplier() {
        return this.minMultiplier;
    }

    public String getMaxMultiplier() {
        return this.maxMultiplier;
    }

    protected long parseMultiplier(String suffix) {
        long multiplier;
        if ("K".equals(suffix)) {
            multiplier = 1000L;
        } else if ("M".equals(suffix)) {
            multiplier = 1000000L;
        } else if ("B".equals(suffix)) {
            multiplier = 1000000000L;
        } else {
            throw new IllegalArgumentException("Suffix " + suffix + " is not supported in ranges");
        }
        return multiplier;
    }

    protected long parseIntWithMultiplier(String number, String suffix) {
        long result = Long.parseLong(number.replace(",", ""));
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            result *= this.parseMultiplier(suffix);
        }
        return result;
    }

    protected double parseDoubleWithMultiplier(String number, String suffix) {
        double result = Double.parseDouble(number.replace(",", ""));
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            result *= (double)this.parseMultiplier(suffix);
        }
        return result;
    }

    protected Number getMax(Number number) {
        if (number.getClass() == Double.class) {
            return Double.POSITIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    protected Number getMin(Number number) {
        if (number.getClass() == Double.class) {
            return Double.NEGATIVE_INFINITY;
        }
        if (number.getClass() == Long.class) {
            return Long.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    protected RangeWithBounds getRangeWithBounds(Number first, Number second, String firstBound, String secondBound) {
        RangeWithBounds.BoundType maxBound;
        RangeWithBounds.BoundType minBound;
        Number max;
        Number min;
        if (firstBound.startsWith("<")) {
            if (secondBound.startsWith("<")) {
                return null;
            }
            min = second;
            max = first;
            minBound = secondBound.equals(">") ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            maxBound = firstBound.equals("<") ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            String t = this.minNumber;
            this.minNumber = this.maxNumber;
            this.maxNumber = t;
            t = this.minMultiplier;
            this.minMultiplier = this.maxMultiplier;
            this.maxMultiplier = t;
        } else {
            if (secondBound.startsWith(">")) {
                return null;
            }
            min = first;
            max = second;
            minBound = firstBound.equals(">") ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            maxBound = secondBound.equals("<") ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
        }
        return new RangeWithBounds(min, max, minBound, maxBound);
    }
}

