/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.rules.helpers.ARangeParser;

public class DateRangeParser
extends ARangeParser<Long> {
    private static final DateTimeFormatter dateTimeParser = DateTimeFormatter.ofPattern("M/d/yyyy[ H:m:s]");
    static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy[ HH:mm:ss]");
    private static final String BRACKETS_PATTERN = "\\s*([\\[(])\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(?:[-;\u2026]|\\.{2,3})\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*([])])\\s*";
    private static final String MIN_MAX_PATTERN = "\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*([-\u2026]|\\.{2,3})\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*";
    private static final String VERBAL_PATTERN = "\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(\\+|and more|or less)\\s*";
    private static final String MORE_LESS_PATTERN = "\\s*(<|>|>=|<=|less than|more than)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*";
    private static final String RANGE_MORE_LESS_PATTERN = "\\s*(<=?|>=?)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(<=?|>=?)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*";
    private static final String SIMPLE_PATTERN = "\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*";
    private final ARangeParser.RangeParser[] parsers;
    private final Pattern[] patterns = new Pattern[]{Pattern.compile("\\s*([\\[(])\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(?:[-;\u2026]|\\.{2,3})\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*([])])\\s*"), Pattern.compile("\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*([-\u2026]|\\.{2,3})\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*"), Pattern.compile("\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(\\+|and more|or less)\\s*"), Pattern.compile("\\s*(<|>|>=|<=|less than|more than)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*"), Pattern.compile("\\s*(<=?|>=?)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*(<=?|>=?)\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*"), Pattern.compile("\\s*((?:\\d{1,2}/){2}\\d+(?: (?:\\d{1,2}:){2}\\d{1,2})?)\\s*")};

    private DateRangeParser() {
        DateRangeBoundAdapter adapter = new DateRangeBoundAdapter();
        this.parsers = new ARangeParser.RangeParser[]{new ARangeParser.BracketsParser<Long>(this.patterns[0], adapter), new ARangeParser.MinMaxParser<Long>(this.patterns[1], adapter), new ARangeParser.VerbalParser<Long>(this.patterns[2], adapter), new ARangeParser.MoreLessParser<Long>(this.patterns[3], adapter), new ARangeParser.RangeWithMoreLessParser<Long>(this.patterns[4], adapter), new ARangeParser.SimpleParser<Long>(this.patterns[5], adapter)};
    }

    public static DateRangeParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean isDateRange(String value) {
        for (Pattern pattern : this.patterns) {
            Matcher m = pattern.matcher(value);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean likelyRangeThanDate(String value) {
        for (int i = 0; i < 5; ++i) {
            Matcher m = this.patterns[i].matcher(value);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    ARangeParser.RangeParser[] getRangeParsers() {
        return this.parsers;
    }

    private static final class DateRangeBoundAdapter
    implements ARangeParser.RangeBoundAdapter<Long> {
        private static final Long MIN = Long.MIN_VALUE;
        private static final Long MAX = Long.MAX_VALUE;

        private DateRangeBoundAdapter() {
        }

        @Override
        public Long adaptValue(String s) {
            TemporalAccessor res = dateTimeParser.parseBest(s, LocalDateTime::from, LocalDate::from);
            return this.toInstant(res);
        }

        private Long toInstant(TemporalAccessor t) {
            LocalDateTime localDateTime = t instanceof LocalDate ? ((LocalDate)t).atStartOfDay() : (LocalDateTime)t;
            return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        }

        @Override
        public Long getMinLeftBound() {
            return MIN;
        }

        @Override
        public Long getMaxRightBound() {
            return MAX;
        }
    }

    private static final class InstanceHolder {
        private static final DateRangeParser INSTANCE = new DateRangeParser();

        private InstanceHolder() {
        }
    }
}

