/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

public class RoundingOperator {
    static final OpUp OP_UP = new OpUp();
    static final OpDown OP_DOWN = new OpDown();
    static final OpRound OP_ROUND = new OpRound();
    public static final IRoundingOperator[] OPERATORS = new IRoundingOperator[]{OP_UP, OP_DOWN, OP_ROUND};
    IRoundingOperator operator;

    static IRoundingOperator findOperator(String op) {
        if (op == null) {
            throw new RuntimeException("RoundingOperator's name must not be null");
        }
        for (int i = 0; i < OPERATORS.length; ++i) {
            for (int j = 0; j < OPERATORS[i].getNames().length; ++j) {
                if (!OPERATORS[i].getNames()[j].equalsIgnoreCase(op)) continue;
                return OPERATORS[i];
            }
        }
        throw new RuntimeException("Unknown RoundingOperator name: " + op);
    }

    public RoundingOperator(String op) {
        this.operator = RoundingOperator.findOperator(op);
    }

    public double op(double value, double precision) {
        return this.operator.value(value, precision);
    }

    public String toString() {
        return this.operator.getNames()[0];
    }

    static class OpUp
    implements IRoundingOperator {
        OpUp() {
        }

        @Override
        public String[] getNames() {
            return new String[]{"UP"};
        }

        @Override
        public double value(double value, double precision) {
            return Math.ceil(value / precision) * precision;
        }
    }

    static class OpRound
    implements IRoundingOperator {
        OpRound() {
        }

        @Override
        public String[] getNames() {
            return new String[]{"ROUND"};
        }

        @Override
        public double value(double value, double precision) {
            return (double)Math.round(value / precision) * precision;
        }
    }

    static class OpDown
    implements IRoundingOperator {
        OpDown() {
        }

        @Override
        public String[] getNames() {
            return new String[]{"DOWN"};
        }

        @Override
        public double value(double value, double precision) {
            return Math.floor(value / precision) * precision;
        }
    }

    static interface IRoundingOperator {
        public String[] getNames();

        public double value(double var1, double var3);
    }
}

