/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.impl.cast.AutoCastReturnType;
import org.openl.binding.impl.cast.ThrowableVoidCast;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.RulesUtilsGetValuesAutoCastFactory;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.table.OpenLArgumentsCloner;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.types.impl.DomainOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.CollectionUtils;
import org.openl.util.DateTool;
import org.openl.util.IOUtils;
import org.openl.util.math.MathUtils;

public final class RulesUtils {
    public static final String DEFAULT_DOUBLE_FORMAT = "#,##0.00";
    public static final double E = Math.E;
    public static final double PI = Math.PI;

    private RulesUtils() {
    }

    public static Byte small(Byte[] values, int position) {
        return (Byte)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Short small(Short[] values, int position) {
        return (Short)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Integer small(Integer[] values, int position) {
        return (Integer)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Long small(Long[] values, int position) {
        return (Long)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Float small(Float[] values, int position) {
        return (Float)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Double small(Double[] values, int position) {
        return (Double)MathUtils.small((Comparable[])values, (int)position);
    }

    public static BigInteger small(BigInteger[] values, int position) {
        return (BigInteger)MathUtils.small((Comparable[])values, (int)position);
    }

    public static BigDecimal small(BigDecimal[] values, int position) {
        return (BigDecimal)MathUtils.small((Comparable[])values, (int)position);
    }

    public static Byte small(byte[] values, int position) {
        return MathUtils.small((byte[])values, (int)position);
    }

    public static Short small(short[] values, int position) {
        return MathUtils.small((short[])values, (int)position);
    }

    public static Integer small(int[] values, int position) {
        return MathUtils.small((int[])values, (int)position);
    }

    public static Long small(long[] values, int position) {
        return MathUtils.small((long[])values, (int)position);
    }

    public static Float small(float[] values, int position) {
        return MathUtils.small((float[])values, (int)position);
    }

    public static Double small(double[] values, int position) {
        return MathUtils.small((double[])values, (int)position);
    }

    public static Byte big(Byte[] values, int position) {
        return (Byte)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Short big(Short[] values, int position) {
        return (Short)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Integer big(Integer[] values, int position) {
        return (Integer)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Long big(Long[] values, int position) {
        return (Long)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Float big(Float[] values, int position) {
        return (Float)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Double big(Double[] values, int position) {
        return (Double)MathUtils.big((Comparable[])values, (int)position);
    }

    public static BigInteger big(BigInteger[] values, int position) {
        return (BigInteger)MathUtils.big((Comparable[])values, (int)position);
    }

    public static BigDecimal big(BigDecimal[] values, int position) {
        return (BigDecimal)MathUtils.big((Comparable[])values, (int)position);
    }

    public static Byte big(byte[] values, int position) {
        return MathUtils.big((byte[])values, (int)position);
    }

    public static Short big(short[] values, int position) {
        return MathUtils.big((short[])values, (int)position);
    }

    public static Integer big(int[] values, int position) {
        return MathUtils.big((int[])values, (int)position);
    }

    public static Long big(long[] values, int position) {
        return MathUtils.big((long[])values, (int)position);
    }

    public static Float big(float[] values, int position) {
        return MathUtils.big((float[])values, (int)position);
    }

    public static Double big(double[] values, int position) {
        return MathUtils.big((double[])values, (int)position);
    }

    public static Double median(Byte[] values) {
        return MathUtils.median((Number[])values);
    }

    public static Double median(Short[] values) {
        return MathUtils.median((Number[])values);
    }

    public static Double median(Integer[] values) {
        return MathUtils.median((Number[])values);
    }

    public static Double median(Long[] values) {
        return MathUtils.median((Number[])values);
    }

    public static Float median(Float[] values) {
        return MathUtils.median((Float[])values);
    }

    public static Double median(Double[] values) {
        return MathUtils.median((Number[])values);
    }

    public static BigDecimal median(BigInteger[] values) {
        return MathUtils.median((BigInteger[])values);
    }

    public static BigDecimal median(BigDecimal[] values) {
        return MathUtils.median((BigDecimal[])values);
    }

    public static Double median(byte[] values) {
        return MathUtils.median((byte[])values);
    }

    public static Double median(short[] values) {
        return MathUtils.median((short[])values);
    }

    public static Double median(int[] values) {
        return MathUtils.median((int[])values);
    }

    public static Double median(long[] values) {
        return MathUtils.median((long[])values);
    }

    public static Float median(float[] values) {
        return MathUtils.median((float[])values);
    }

    public static Double median(double[] values) {
        return MathUtils.median((double[])values);
    }

    public static long quotient(Byte number, Byte divisor) {
        return MathUtils.quotient((Byte)number, (Byte)divisor);
    }

    public static long quotient(Short number, Short divisor) {
        return MathUtils.quotient((Short)number, (Short)divisor);
    }

    public static long quotient(Integer number, Integer divisor) {
        return MathUtils.quotient((Integer)number, (Integer)divisor);
    }

    public static long quotient(Long number, Long divisor) {
        return MathUtils.quotient((Long)number, (Long)divisor);
    }

    public static long quotient(Float number, Float divisor) {
        return MathUtils.quotient((Float)number, (Float)divisor);
    }

    public static long quotient(Double number, Double divisor) {
        return MathUtils.quotient((Double)number, (Double)divisor);
    }

    public static long quotient(BigInteger number, BigInteger divisor) {
        return MathUtils.quotient((BigInteger)number, (BigInteger)divisor);
    }

    public static long quotient(BigDecimal number, BigDecimal divisor) {
        return MathUtils.quotient((BigDecimal)number, (BigDecimal)divisor);
    }

    public static long quotient(byte number, byte divisor) {
        return MathUtils.quotient((byte)number, (byte)divisor);
    }

    public static long quotient(short number, short divisor) {
        return MathUtils.quotient((short)number, (short)divisor);
    }

    public static long quotient(int number, int divisor) {
        return MathUtils.quotient((int)number, (int)divisor);
    }

    public static long quotient(long number, long divisor) {
        return MathUtils.quotient((long)number, (long)divisor);
    }

    public static long quotient(float number, float divisor) {
        return MathUtils.quotient((float)number, (float)divisor);
    }

    public static long quotient(double number, double divisor) {
        return MathUtils.quotient((double)number, (double)divisor);
    }

    public static Byte mod(Byte number, Byte divisor) {
        return MathUtils.mod((Byte)number, (Byte)divisor);
    }

    public static Short mod(Short number, Short divisor) {
        return MathUtils.mod((Short)number, (Short)divisor);
    }

    public static Integer mod(Integer number, Integer divisor) {
        return MathUtils.mod((Integer)number, (Integer)divisor);
    }

    public static Long mod(Long number, Long divisor) {
        return MathUtils.mod((Long)number, (Long)divisor);
    }

    public static Float mod(Float number, Float divisor) {
        return MathUtils.mod((Float)number, (Float)divisor);
    }

    public static Double mod(Double number, Double divisor) {
        return MathUtils.mod((Double)number, (Double)divisor);
    }

    public static BigInteger mod(BigInteger number, BigInteger divisor) {
        return MathUtils.mod((BigInteger)number, (BigInteger)divisor);
    }

    public static BigDecimal mod(BigDecimal number, BigDecimal divisor) {
        return MathUtils.mod((BigDecimal)number, (BigDecimal)divisor);
    }

    public static byte mod(byte number, byte divisor) {
        return MathUtils.mod((byte)number, (byte)divisor);
    }

    public static short mod(short number, short divisor) {
        return MathUtils.mod((short)number, (short)divisor);
    }

    public static int mod(int number, int divisor) {
        return MathUtils.mod((int)number, (int)divisor);
    }

    public static long mod(long number, long divisor) {
        return MathUtils.mod((long)number, (long)divisor);
    }

    public static float mod(float number, float divisor) {
        return MathUtils.mod((float)number, (float)divisor);
    }

    public static double mod(double number, double divisor) {
        return MathUtils.mod((double)number, (double)divisor);
    }

    public static <T extends Comparable<?>> T[] sort(T[] values) {
        Comparable[] sortedArray = null;
        if (values != null) {
            sortedArray = (Comparable[])Array.newInstance(values.getClass().getComponentType(), values.length);
            Object[] notNullArray = (Comparable[])ArrayTool.removeNulls((Object[])values);
            if (notNullArray == values) {
                notNullArray = (Comparable[])values.clone();
            }
            Arrays.sort(notNullArray);
            System.arraycopy(notNullArray, 0, sortedArray, 0, notNullArray.length);
        }
        return sortedArray;
    }

    public static byte[] sort(byte[] values) {
        return MathUtils.sort((byte[])values);
    }

    public static short[] sort(short[] values) {
        return MathUtils.sort((short[])values);
    }

    public static int[] sort(int[] values) {
        return MathUtils.sort((int[])values);
    }

    public static long[] sort(long[] values) {
        return MathUtils.sort((long[])values);
    }

    public static float[] sort(float[] values) {
        return MathUtils.sort((float[])values);
    }

    public static double[] sort(double[] values) {
        return MathUtils.sort((double[])values);
    }

    public static boolean contains(Object[] array, Object obj) {
        return ArrayUtils.contains((Object[])array, (Object)obj);
    }

    public static boolean contains(int[] array, int elem) {
        return ArrayUtils.contains((int[])array, (int)elem);
    }

    public static boolean contains(long[] array, long elem) {
        return ArrayUtils.contains((long[])array, (long)elem);
    }

    public static boolean contains(byte[] array, byte elem) {
        return ArrayUtils.contains((byte[])array, (byte)elem);
    }

    public static boolean contains(short[] array, short elem) {
        return ArrayUtils.contains((short[])array, (short)elem);
    }

    public static boolean contains(char[] array, char elem) {
        return ArrayUtils.contains((char[])array, (char)elem);
    }

    public static boolean contains(float[] array, float elem) {
        return ArrayUtils.contains((float[])array, (float)elem);
    }

    public static boolean contains(double[] array, double elem) {
        return ArrayUtils.contains((double[])array, (double)elem);
    }

    public static boolean contains(Byte[] array, Byte elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Short[] array, Short elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Integer[] array, Integer elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Long[] array, Long elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Float[] array, Float elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Double[] array, Double elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Date[] array, Date elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(String[] array, String elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(Character[] array, Character elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(IntRange[] array, Integer elem) {
        if (array == null) {
            return false;
        }
        for (IntRange range : array) {
            if (range == null || !range.contains(elem.intValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(DoubleRange[] array, Double elem) {
        if (array == null) {
            return false;
        }
        for (DoubleRange range : array) {
            if (range == null || !range.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharRange[] array, Character elem) {
        if (array == null) {
            return false;
        }
        for (CharRange range : array) {
            if (range == null || !range.contains(elem.charValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(DateRange[] array, Date elem) {
        if (array == null) {
            return false;
        }
        for (DateRange range : array) {
            if (range == null || !range.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(StringRange[] array, CharSequence elem) {
        if (array == null) {
            return false;
        }
        for (StringRange range : array) {
            if (range == null || !range.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(StringRange[] array, String elem) {
        return RulesUtils.contains(array, (CharSequence)elem);
    }

    public static boolean contains(Object[] ary1, Object[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(boolean[] array, boolean elem) {
        return ArrayUtils.contains((boolean[])array, (boolean)elem);
    }

    public static boolean contains(Boolean[] array, Boolean elem) {
        return ArrayUtils.contains((Object[])array, (Object)elem);
    }

    public static boolean contains(int[] ary1, int[] ary2) {
        return ArrayTool.containsAll((int[])ary1, (int[])ary2);
    }

    public static boolean contains(Integer[] ary1, Integer[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(byte[] ary1, byte[] ary2) {
        return ArrayTool.containsAll((byte[])ary1, (byte[])ary2);
    }

    public static boolean contains(Byte[] ary1, Byte[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(short[] ary1, short[] ary2) {
        return ArrayTool.containsAll((short[])ary1, (short[])ary2);
    }

    public static boolean contains(Short[] ary1, Short[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(long[] ary1, long[] ary2) {
        return ArrayTool.containsAll((long[])ary1, (long[])ary2);
    }

    public static boolean contains(Long[] ary1, Long[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(char[] ary1, char[] ary2) {
        return ArrayTool.containsAll((char[])ary1, (char[])ary2);
    }

    public static boolean contains(Character[] ary1, Character[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(float[] ary1, float[] ary2) {
        return ArrayTool.containsAll((float[])ary1, (float[])ary2);
    }

    public static boolean contains(Float[] ary1, Float[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(String[] ary1, String[] ary2) {
        return ArrayTool.containsAll((String[])ary1, (String[])ary2);
    }

    public static boolean contains(double[] ary1, double[] ary2) {
        return ArrayTool.containsAll((double[])ary1, (double[])ary2);
    }

    public static boolean contains(Double[] ary1, Double[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(boolean[] ary1, boolean[] ary2) {
        return ArrayTool.containsAll((boolean[])ary1, (boolean[])ary2);
    }

    public static boolean contains(Boolean[] ary1, Boolean[] ary2) {
        return ArrayTool.containsAll((Object[])ary1, (Object[])ary2);
    }

    public static boolean contains(IntRange[] ary1, Integer[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (Integer elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static boolean contains(IntRange[] ary1, int[] ary2) {
        if (ary2 == null) {
            return false;
        }
        int[] nArray = ary2;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer elem = nArray[i];
            if (RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return ary2.length > 0;
    }

    public static boolean contains(DoubleRange[] ary1, Double[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (Double elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static boolean contains(DoubleRange[] ary1, double[] ary2) {
        if (ary2 == null) {
            return false;
        }
        double[] dArray = ary2;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double elem = dArray[i];
            if (RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return ary2.length > 0;
    }

    public static boolean contains(CharRange[] ary1, Character[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (Character elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static boolean contains(CharRange[] ary1, char[] ary2) {
        if (ary2 == null) {
            return false;
        }
        char[] cArray = ary2;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character elem = Character.valueOf(cArray[i]);
            if (RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return ary2.length > 0;
    }

    public static boolean contains(StringRange[] ary1, CharSequence[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (CharSequence elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static boolean contains(StringRange[] ary1, String[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (String elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static boolean contains(DateRange[] ary1, Date[] ary2) {
        if (ary2 == null) {
            return false;
        }
        for (Date elem : ary2) {
            if (elem == null || RulesUtils.contains(ary1, elem)) continue;
            return false;
        }
        return Arrays.stream(ary2).anyMatch(Objects::nonNull);
    }

    public static int indexOf(Object[] array, Object obj) {
        return ArrayUtils.indexOf((Object[])array, (Object)obj);
    }

    public static int indexOf(int[] array, int elem) {
        return ArrayUtils.indexOf((int[])array, (int)elem);
    }

    public static int indexOf(long[] array, long elem) {
        return ArrayUtils.indexOf((long[])array, (long)elem);
    }

    public static int indexOf(byte[] array, byte elem) {
        return ArrayUtils.indexOf((byte[])array, (byte)elem);
    }

    public static int indexOf(short[] array, short elem) {
        return ArrayUtils.indexOf((short[])array, (short)elem);
    }

    public static int indexOf(char[] array, char elem) {
        return ArrayUtils.indexOf((char[])array, (char)elem);
    }

    public static int indexOf(float[] array, float elem) {
        return ArrayUtils.indexOf((float[])array, (float)elem);
    }

    public static int indexOf(double[] array, double elem) {
        return ArrayUtils.indexOf((double[])array, (double)elem);
    }

    public static int indexOf(boolean[] array, boolean elem) {
        return ArrayUtils.indexOf((boolean[])array, (boolean)elem);
    }

    public static int indexOf(Boolean[] array, Boolean elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Byte[] array, Byte elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Short[] array, Short elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Long[] array, Long elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Integer[] array, Integer elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Float[] array, Float elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Double[] array, Double elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static int indexOf(Character[] array, Character elem) {
        return ArrayUtils.indexOf((Object[])array, (Object)elem);
    }

    public static boolean noNulls(Object[] values) {
        return CollectionUtils.isNotEmpty((Object[])values) && !CollectionUtils.hasNull((Object[])values);
    }

    public static ThrowableVoidCast.ThrowableVoid error(String msg) {
        throw new OpenLUserRuntimeException(msg);
    }

    @Deprecated
    public static String format(Date date) {
        return RulesUtils.dateToString(date);
    }

    @Deprecated
    public static String format(Date date, String format) {
        return RulesUtils.dateToString(date, format);
    }

    @Deprecated
    public static String dateToString(Date date, String dateFormat) {
        String stringDate = "Incorrect date format";
        try {
            stringDate = DateTool.dateToString((Date)date, (String)dateFormat);
        }
        catch (Exception e) {
            throw new OpenLRuntimeException(stringDate + " '" + dateFormat + "'");
        }
        return stringDate;
    }

    @Deprecated
    public static String dateToString(Date date) {
        String stringDate = "Incorrect date format";
        try {
            stringDate = DateTool.dateToString((Date)date);
        }
        catch (Exception e) {
            throw new OpenLRuntimeException(stringDate);
        }
        return stringDate;
    }

    @Deprecated
    public static Date stringToDate(String value) throws ParseException {
        DateFormat df = DateFormat.getDateInstance(3);
        return df.parse(value);
    }

    public static String format(double d) {
        return RulesUtils.format(d, DEFAULT_DOUBLE_FORMAT);
    }

    public static String format(double d, String fmt) {
        DecimalFormat df = new DecimalFormat(fmt);
        return df.format(d);
    }

    public static String[] intersection(String[] ary1, String[] ary2) {
        return ArrayTool.intersection((String[])ary1, (String[])ary2);
    }

    public static void out(String output) {
        System.out.println(output);
    }

    public static void out(Object output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(byte output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(short output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(int output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(long output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(float output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(double output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(char output) {
        System.out.println(String.valueOf(output));
    }

    public static void out(boolean output) {
        System.out.println(String.valueOf(output));
    }

    @Deprecated
    public static double parseFormattedDouble(String s) throws ParseException {
        return RulesUtils.parseFormattedDouble(s, DEFAULT_DOUBLE_FORMAT);
    }

    @Deprecated
    public static double parseFormattedDouble(String s, String fmt) throws ParseException {
        DecimalFormat df = new DecimalFormat(fmt);
        return df.parse(s).doubleValue();
    }

    public static Integer absMonth(Date d) {
        return DateTool.absMonth((Date)d);
    }

    public static Integer absQuarter(Date d) {
        return DateTool.absQuarter((Date)d);
    }

    public static Integer dayDiff(Date d1, Date d2) {
        return DateTool.dayDiff((Date)d1, (Date)d2);
    }

    public static Integer dayOfMonth(Date d) {
        return DateTool.dayOfMonth((Date)d);
    }

    public static Date firstDateOfQuarter(int absQuarter) {
        return DateTool.firstDateOfQuarter((int)absQuarter);
    }

    public static Date lastDateOfQuarter(int absQuarter) {
        return DateTool.lastDateOfQuarter((int)absQuarter);
    }

    public static Integer lastDayOfMonth(Date d) {
        return DateTool.lastDayOfMonth((Date)d);
    }

    public static Integer month(Date d) {
        return DateTool.month((Date)d);
    }

    public static Integer monthDiff(Date d1, Date d2) {
        return DateTool.monthDiff((Date)d1, (Date)d2);
    }

    public static Integer yearDiff(Date d1, Date d2) {
        return DateTool.yearDiff((Date)d1, (Date)d2);
    }

    public static Integer weekDiff(Date d1, Date d2) {
        return DateTool.weekDiff((Date)d1, (Date)d2);
    }

    public static Integer quarter(Date d) {
        return DateTool.quarter((Date)d);
    }

    public static Integer year(Date d) {
        return DateTool.year((Date)d);
    }

    public static Integer dayOfWeek(Date d) {
        return DateTool.dayOfWeek((Date)d);
    }

    public static Integer dayOfYear(Date d) {
        return DateTool.dayOfYear((Date)d);
    }

    public static Integer weekOfYear(Date d) {
        return DateTool.weekOfYear((Date)d);
    }

    public static Integer weekOfMonth(Date d) {
        return DateTool.weekOfMonth((Date)d);
    }

    public static Integer second(Date d) {
        return DateTool.second((Date)d);
    }

    public static Integer minute(Date d) {
        return DateTool.minute((Date)d);
    }

    public static Integer hour(Date d) {
        return DateTool.hour((Date)d);
    }

    public static Integer hourOfDay(Date d) {
        return DateTool.hourOfDay((Date)d);
    }

    public static String amPm(Date d) {
        return DateTool.amPm((Date)d);
    }

    public static <T> T[] removeNulls(T[] array) {
        return ArrayTool.removeNulls((Object[])array);
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static int abs(int a) {
        return Math.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static double acos(double a) {
        return Math.acos(a);
    }

    public static double asin(double a) {
        return Math.asin(a);
    }

    public static double atan(double a) {
        return Math.atan(a);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double cbrt(double a) {
        return Math.cbrt(a);
    }

    public static double ceil(double a) {
        return Math.ceil(a);
    }

    public static double copySign(double magnitude, double sign) {
        return Math.copySign(magnitude, sign);
    }

    public static float copySign(float magnitude, float sign) {
        return Math.copySign(magnitude, sign);
    }

    public static double cos(double a) {
        return Math.cos(a);
    }

    public static double cosh(double x) {
        return Math.cosh(x);
    }

    public static double exp(double a) {
        return Math.exp(a);
    }

    public static double expm1(double x) {
        return Math.expm1(x);
    }

    public static double floor(double a) {
        return Math.floor(a);
    }

    public static int getExponent(double d) {
        return Math.getExponent(d);
    }

    public static int getExponent(float f) {
        return Math.getExponent(f);
    }

    public static double getExponent(double x, double y) {
        return Math.hypot(x, y);
    }

    public static double IEEEremainder(double f1, double f2) {
        return Math.IEEEremainder(f1, f2);
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static double log10(double a) {
        return Math.log10(a);
    }

    public static double log1p(double x) {
        return Math.log1p(x);
    }

    public static double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    public static float nextAfter(float start, float direction) {
        return Math.nextAfter(start, (double)direction);
    }

    public static float nextAfter(float f) {
        return Math.nextUp(f);
    }

    public static double nextAfter(double d) {
        return Math.nextUp(d);
    }

    public static double pow(byte a, byte b) {
        return Math.pow(a, b);
    }

    public static double pow(short a, short b) {
        return Math.pow(a, b);
    }

    public static double pow(int a, int b) {
        return Math.pow(a, b);
    }

    public static double pow(long a, long b) {
        return Math.pow(a, b);
    }

    public static double pow(float a, float b) {
        return Math.pow(a, b);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static double pow(Double a, Double b) {
        if (a == null) {
            return (b == null ? null : Integer.valueOf(0)).intValue();
        }
        if (b == null) {
            return a;
        }
        return Math.pow(a, b);
    }

    public static double random() {
        return Math.random();
    }

    public static double rint(double a) {
        return Math.rint(a);
    }

    public static double scalb(double d, int scaleFactor) {
        return Math.scalb(d, scaleFactor);
    }

    public static float scalb(float f, int scaleFactor) {
        return Math.scalb(f, scaleFactor);
    }

    public static double signum(double d) {
        return Math.signum(d);
    }

    public static double signum(float f) {
        return Math.signum(f);
    }

    public static double sin(double a) {
        return Math.sin(a);
    }

    public static double sinh(double x) {
        return Math.sinh(x);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static double tan(double a) {
        return Math.tan(a);
    }

    public static double tanh(double x) {
        return Math.tanh(x);
    }

    public static double toDegrees(double angrad) {
        return Math.toDegrees(angrad);
    }

    public static double toRadians(double angdeg) {
        return Math.toRadians(angdeg);
    }

    public static double ulp(double d) {
        return Math.ulp(d);
    }

    public static float ulp(float f) {
        return Math.ulp(f);
    }

    public static boolean[] add(boolean[] array, boolean element) {
        return ArrayUtils.add((boolean[])array, (boolean)element);
    }

    public static boolean[] add(boolean[] array, int index, boolean element) {
        return ArrayUtils.add((boolean[])array, (int)index, (boolean)element);
    }

    public static byte[] add(byte[] array, byte element) {
        return ArrayUtils.add((byte[])array, (byte)element);
    }

    public static byte[] add(byte[] array, int index, byte element) {
        return ArrayUtils.add((byte[])array, (int)index, (byte)element);
    }

    public static char[] add(char[] array, char element) {
        return ArrayUtils.add((char[])array, (char)element);
    }

    public static char[] add(char[] array, int index, char element) {
        return ArrayUtils.add((char[])array, (int)index, (char)element);
    }

    public static double[] add(double[] array, double element) {
        return ArrayUtils.add((double[])array, (double)element);
    }

    public static double[] add(double[] array, int index, double element) {
        return ArrayUtils.add((double[])array, (int)index, (double)element);
    }

    public static float[] add(float[] array, float element) {
        return ArrayUtils.add((float[])array, (float)element);
    }

    public static float[] add(float[] array, int index, float element) {
        return ArrayUtils.add((float[])array, (int)index, (float)element);
    }

    public static int[] add(int[] array, int element) {
        return ArrayUtils.add((int[])array, (int)element);
    }

    public static int[] add(int[] array, int index, int element) {
        return ArrayUtils.add((int[])array, (int)index, (int)element);
    }

    public static long[] add(long[] array, int index, long element) {
        return ArrayUtils.add((long[])array, (int)index, (long)element);
    }

    public static long[] add(long[] array, long element) {
        return ArrayUtils.add((long[])array, (long)element);
    }

    public static <T> T[] add(T[] array, int index, T element) {
        return ArrayUtils.add((Object[])array, (int)index, element);
    }

    public static short[] add(short[] array, int index, short element) {
        return ArrayUtils.add((short[])array, (int)index, (short)element);
    }

    public static short[] add(short[] array, short element) {
        return ArrayUtils.add((short[])array, (short)element);
    }

    public static Byte[] add(Byte[] array, int index, Byte element) {
        return (Byte[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Short[] add(Short[] array, int index, Short element) {
        return (Short[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Integer[] add(Integer[] array, int index, Integer element) {
        return (Integer[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Long[] add(Long[] array, int index, Long element) {
        return (Long[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Float[] add(Float[] array, int index, Float element) {
        return (Float[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Double[] add(Double[] array, int index, Double element) {
        return (Double[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Character[] add(Character[] array, int index, Character element) {
        return (Character[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static Boolean[] add(Boolean[] array, int index, Boolean element) {
        return (Boolean[])ArrayUtils.add((Object[])array, (int)index, (Object)element);
    }

    public static <T> T[] addIgnoreNull(T[] array, int index, T element) {
        if (element != null) {
            return ArrayUtils.add((Object[])array, (int)index, element);
        }
        return array;
    }

    public static <T> T[] addIgnoreNull(T[] array, T element) {
        if (element != null) {
            return ArrayUtils.add((Object[])array, element);
        }
        return array;
    }

    @Deprecated
    public static Object[] addArrayElementIgnoreNull(Object[] array, int index, Object element) {
        return RulesUtils.addIgnoreNull(array, index, element);
    }

    @Deprecated
    public static Object[] addArrayElementIgnoreNull(Object[] array, Object element) {
        return RulesUtils.addIgnoreNull(array, element);
    }

    public static boolean[] addAll(boolean[] array1, boolean[] array2) {
        return ArrayUtils.addAll((boolean[])array1, (boolean[])array2);
    }

    public static byte[] addAll(byte[] array1, byte[] array2) {
        return ArrayUtils.addAll((byte[])array1, (byte[])array2);
    }

    public static char[] addAll(char[] array1, char[] array2) {
        return ArrayUtils.addAll((char[])array1, (char[])array2);
    }

    public static double[] addAll(double[] array1, double[] array2) {
        return ArrayUtils.addAll((double[])array1, (double[])array2);
    }

    public static float[] addAll(float[] array1, float[] array2) {
        return ArrayUtils.addAll((float[])array1, (float[])array2);
    }

    public static int[] addAll(int[] array1, int[] array2) {
        return ArrayUtils.addAll((int[])array1, (int[])array2);
    }

    public static long[] addAll(long[] array1, long[] array2) {
        return ArrayUtils.addAll((long[])array1, (long[])array2);
    }

    public static short[] addAll(short[] array1, short[] array2) {
        return ArrayUtils.addAll((short[])array1, (short[])array2);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return ArrayUtils.remove((boolean[])array, (int)index);
    }

    public static byte[] remove(byte[] array, int index) {
        return ArrayUtils.remove((byte[])array, (int)index);
    }

    public static char[] remove(char[] array, int index) {
        return ArrayUtils.remove((char[])array, (int)index);
    }

    public static double[] remove(double[] array, int index) {
        return ArrayUtils.remove((double[])array, (int)index);
    }

    public static float[] remove(float[] array, int index) {
        return ArrayUtils.remove((float[])array, (int)index);
    }

    public static int[] remove(int[] array, int index) {
        return ArrayUtils.remove((int[])array, (int)index);
    }

    public static long[] remove(long[] array, int index) {
        return ArrayUtils.remove((long[])array, (int)index);
    }

    public static <T> T[] remove(T[] array, int index) {
        return ArrayUtils.remove((Object[])array, (int)index);
    }

    public static short[] remove(short[] array, int index) {
        return ArrayUtils.remove((short[])array, (int)index);
    }

    public static Byte[] remove(Byte[] array, int index) {
        return (Byte[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Short[] remove(Short[] array, int index) {
        return (Short[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Integer[] remove(Integer[] array, int index) {
        return (Integer[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Long[] remove(Long[] array, int index) {
        return (Long[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Float[] remove(Float[] array, int index) {
        return (Float[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Double[] remove(Double[] array, int index) {
        return (Double[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Character[] remove(Character[] array, int index) {
        return (Character[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static Boolean[] remove(Boolean[] array, int index) {
        return (Boolean[])ArrayUtils.remove((Object[])array, (int)index);
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        return ArrayUtils.removeElement((boolean[])array, (boolean)element);
    }

    public static byte[] removeElement(byte[] array, byte element) {
        return ArrayUtils.removeElement((byte[])array, (byte)element);
    }

    public static char[] removeElement(char[] array, char element) {
        return ArrayUtils.removeElement((char[])array, (char)element);
    }

    public static double[] removeElement(double[] array, double element) {
        return ArrayUtils.removeElement((double[])array, (double)element);
    }

    public static float[] removeElement(float[] array, float element) {
        return ArrayUtils.removeElement((float[])array, (float)element);
    }

    public static int[] removeElement(int[] array, int element) {
        return ArrayUtils.removeElement((int[])array, (int)element);
    }

    public static long[] removeElement(long[] array, long element) {
        return ArrayUtils.removeElement((long[])array, (long)element);
    }

    public static short[] removeElement(short[] array, short element) {
        return ArrayUtils.removeElement((short[])array, (short)element);
    }

    public static <T> T[] removeElement(T[] array, T element) {
        return ArrayUtils.removeElement((Object[])array, element);
    }

    public static Byte[] removeElement(Byte[] array, Byte element) {
        return (Byte[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Short[] removeElement(Short[] array, Short element) {
        return (Short[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Integer[] removeElement(Integer[] array, Integer element) {
        return (Integer[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Long[] removeElement(Long[] array, Long element) {
        return (Long[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Float[] removeElement(Float[] array, Float element) {
        return (Float[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Double[] removeElement(Double[] array, Double element) {
        return (Double[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Character[] removeElement(Character[] array, Character element) {
        return (Character[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    public static Boolean[] removeElement(Boolean[] array, Boolean element) {
        return (Boolean[])ArrayUtils.removeElement((Object[])array, (Object)element);
    }

    @AutoCastReturnType
    public static Object[] flatten(Object ... data) {
        if (data == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        Class type = Void.class;
        for (Object obj : data) {
            if (obj == null) {
                values.add(null);
                continue;
            }
            if (obj.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(obj); ++i) {
                    Object o = Array.get(obj, i);
                    Object[] flatten = RulesUtils.flatten(o);
                    values.addAll(Arrays.asList(flatten));
                    type = RulesUtils.getCommonSuperClass(type, flatten.getClass().getComponentType());
                }
                continue;
            }
            values.add(obj);
            type = RulesUtils.getCommonSuperClass(type, obj.getClass());
        }
        Object[] result = (Object[])Array.newInstance(type, 0);
        result = values.toArray(result);
        return result;
    }

    public static Class<?> getCommonSuperClass(Class<?> classA, Class<?> classB) {
        if (classA == Void.class) {
            return classB;
        }
        if (classB == Void.class) {
            return classA;
        }
        if (classA.isAssignableFrom(classB)) {
            return classA;
        }
        Class<?> commonClass = classB;
        while (!commonClass.isAssignableFrom(classA)) {
            commonClass = commonClass.getSuperclass();
        }
        return commonClass;
    }

    @AutoCastReturnType(value=RulesUtilsGetValuesAutoCastFactory.class)
    public static Object getValues(DomainOpenClass clazz) {
        IDomain domain = clazz.getDomain();
        int size = 0;
        for (Object item : domain) {
            ++size;
        }
        Class type = clazz.getInstanceClass();
        Object result = Array.newInstance(type, size);
        int i = 0;
        for (Object item : domain) {
            Array.set(result, i, item);
            ++i;
        }
        return result;
    }

    public static boolean instanceOf(Object o, Class<?> clazz) {
        if (o == null) {
            return false;
        }
        if (clazz == null) {
            return false;
        }
        return clazz.isAssignableFrom(o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <T> T copy(T origin) {
        if (origin == null) {
            return null;
        }
        Class<?> clazz = origin.getClass();
        if (clazz.isArray() && Serializable.class.isAssignableFrom(clazz.getComponentType()) || !clazz.isArray() && origin instanceof Serializable) {
            Object object;
            ObjectOutputStream oos = null;
            ClassLoaderObjectInputStream ois = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
                oos = new ObjectOutputStream(baos);
                oos.writeObject(origin);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                ois = new ClassLoaderObjectInputStream(Thread.currentThread().getContextClassLoader(), (InputStream)bais);
                object = ois.readObject();
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(oos);
                IOUtils.closeQuietly(ois);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(oos);
                    IOUtils.closeQuietly(ois);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)oos);
            IOUtils.closeQuietly((Closeable)ois);
            return (T)object;
        }
        return (T)new OpenLArgumentsCloner().deepClone(origin);
    }
}

