/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.rules.helpers.ARangeParser;

public final class StringRangeParser
extends ARangeParser<String> {
    public static final String MAX_VALUE = String.valueOf('\uffff');
    public static final String MIN_VALUE = " ";
    private final ARangeParser.RangeParser[] parsers;
    private final Pattern[] patterns;
    private static final String BRACKETS_PATTERN = "\\s*([\\[(])\\s*(\\S+)\\s*(?:[-;\u2026]|\\.{3}|\\.{2})\\s*(\\S+)\\s*([])])\\s*";
    private static final String MIN_MAX_PATTERN = "\\s*(\\S+)\\s*([-\u2026]|\\.{3}|\\.{2})\\s*(\\S+)\\s*";
    private static final String VERBAL_PATTERN = "\\s*(\\S+)\\s*(\\+|(?<=\\s)and more|(?<=\\s)or less)\\s*";
    private static final String MORE_LESS_PATTERN = "\\s*(<=?|>=?|less than(?=\\s)|more than(?=\\s))\\s*(\\S+)\\s*";
    private static final String RANGE_MORE_LESS_PATTERN = "\\s*(<=?|>=?)\\s*(\\S+)\\s*(<=?|>=?)\\s*(\\S+)\\s*";
    private static final String SIMPLE_PATTERN = "\\s*(\\S+)\\s*";

    private StringRangeParser() {
        StringRangeBoundAdapter adapter = new StringRangeBoundAdapter();
        this.patterns = new Pattern[]{Pattern.compile(BRACKETS_PATTERN), Pattern.compile(MIN_MAX_PATTERN), Pattern.compile(VERBAL_PATTERN), Pattern.compile(MORE_LESS_PATTERN), Pattern.compile(RANGE_MORE_LESS_PATTERN), Pattern.compile(SIMPLE_PATTERN)};
        this.parsers = new ARangeParser.RangeParser[]{new ARangeParser.BracketsParser<String>(this.patterns[0], adapter), new ARangeParser.MinMaxParser<String>(this.patterns[1], adapter), new ARangeParser.VerbalParser<String>(this.patterns[2], adapter), new ARangeParser.MoreLessParser<String>(this.patterns[3], adapter), new ARangeParser.RangeWithMoreLessParser<String>(this.patterns[4], adapter), new ARangeParser.SimpleParser<String>(this.patterns[5], adapter)};
    }

    public boolean isStringRange(String value) {
        for (Pattern pattern : this.patterns) {
            Matcher m = pattern.matcher(value);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean likelyRangeThanString(String value) {
        for (int i = 0; i < 5; ++i) {
            Matcher m = this.patterns[i].matcher(value);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    public static StringRangeParser getInstance() {
        return StringRangeParserHolder.INSTANCE;
    }

    @Override
    ARangeParser.RangeParser[] getRangeParsers() {
        return this.parsers;
    }

    private static final class StringRangeBoundAdapter
    implements ARangeParser.RangeBoundAdapter<String> {
        private StringRangeBoundAdapter() {
        }

        @Override
        public String adaptValue(String s) {
            return s;
        }

        @Override
        public String getMinLeftBound() {
            return StringRangeParser.MIN_VALUE;
        }

        @Override
        public String getMaxRightBound() {
            return MAX_VALUE;
        }
    }

    private static class StringRangeParserHolder {
        private static final StringRangeParser INSTANCE = new StringRangeParser();

        private StringRangeParserHolder() {
        }
    }
}

