/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.IOpenBinder;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundNode;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.INameSpacedMethodFactory;
import org.openl.binding.INameSpacedTypeFactory;
import org.openl.binding.INameSpacedVarFactory;
import org.openl.binding.INodeBinderFactory;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BindingContext;
import org.openl.binding.impl.BoundCode;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.module.ModuleNode;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenLBuilderImpl;
import org.openl.conf.OpenLConfigurationException;
import org.openl.dependency.CompiledDependency;
import org.openl.engine.OpenLManager;
import org.openl.engine.OpenLSystemProperties;
import org.openl.exception.OpenlNotCheckedException;
import org.openl.rules.binding.RecursiveOpenMethodPreBinder;
import org.openl.rules.binding.RulesModuleBindingContext;
import org.openl.rules.calc.SpreadsheetNodeBinder;
import org.openl.rules.cmatch.ColumnMatchNodeBinder;
import org.openl.rules.constants.ConstantsTableBinder;
import org.openl.rules.data.DataBase;
import org.openl.rules.data.DataNodeBinder;
import org.openl.rules.data.IDataBase;
import org.openl.rules.datatype.binding.DatatypeNodeBinder;
import org.openl.rules.datatype.binding.DatatypesSorter;
import org.openl.rules.dt.ActionsTableBinder;
import org.openl.rules.dt.ConditionsTableBinder;
import org.openl.rules.dt.DecisionTableNodeBinder;
import org.openl.rules.dt.ReturnsTableBinder;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.lang.xls.SpreadsheetTableSyntaxNodeRelationsDeterminer;
import org.openl.rules.lang.xls.SyntaxNodeConvertor;
import org.openl.rules.lang.xls.TableSyntaxNodeCircularDependencyException;
import org.openl.rules.lang.xls.TableSyntaxNodeRelationsUtils;
import org.openl.rules.lang.xls.XlsHelper;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.binding.AExecutableNodeBinder;
import org.openl.rules.lang.xls.binding.AXlsTableBinder;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNodeHelper;
import org.openl.rules.lang.xls.syntax.XlsModuleSyntaxNode;
import org.openl.rules.method.table.MethodTableNodeBinder;
import org.openl.rules.property.PropertyTableBinder;
import org.openl.rules.table.properties.PropertiesLoader;
import org.openl.rules.tbasic.AlgorithmNodeBinder;
import org.openl.rules.testmethod.TestMethodNodeBinder;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ASelector;
import org.openl.util.AStringConvertor;
import org.openl.util.ISelector;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsBinder
implements IOpenBinder {
    private static final Pattern REGEX = Pattern.compile("[ ,()\t\n\r]");
    private final Logger log = LoggerFactory.getLogger(XlsBinder.class);
    private static Map<String, AXlsTableBinder> binderFactory;
    private static final String[][] BINDERS;
    private IUserContext userContext;

    public static synchronized Map<String, AXlsTableBinder> getBinderFactory() {
        if (binderFactory == null) {
            binderFactory = new HashMap<String, AXlsTableBinder>();
            for (int i = 0; i < BINDERS.length; ++i) {
                try {
                    binderFactory.put(BINDERS[i][0], (AXlsTableBinder)((Object)Class.forName(BINDERS[i][1]).newInstance()));
                    continue;
                }
                catch (Exception ex) {
                    throw RuntimeExceptionWrapper.wrap((Throwable)ex);
                }
            }
        }
        return binderFactory;
    }

    public XlsBinder(IUserContext userContext) {
        this.userContext = userContext;
    }

    public ICastFactory getCastFactory() {
        return null;
    }

    public INameSpacedMethodFactory getMethodFactory() {
        return null;
    }

    public INodeBinderFactory getNodeBinderFactory() {
        return null;
    }

    public INameSpacedTypeFactory getTypeFactory() {
        return null;
    }

    public INameSpacedVarFactory getVarFactory() {
        return null;
    }

    public IBindingContext makeBindingContext() {
        return new BindingContext(null, (IOpenClass)JavaOpenClass.VOID, null);
    }

    public IBoundCode bind(IParsedCode parsedCode) {
        return this.bind(parsedCode, null);
    }

    public IBoundCode bind(IParsedCode parsedCode, IBindingContext bindingContext) {
        Set compiledDependencies;
        BindingContext bc;
        XlsModuleSyntaxNode moduleNode = (XlsModuleSyntaxNode)parsedCode.getTopNode();
        OpenL openl = null;
        try {
            openl = this.makeOpenL(moduleNode);
        }
        catch (OpenLConfigurationException ex) {
            OpenlSyntaxNode syntaxNode = moduleNode.getOpenlNode();
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Error Creating OpenL", (Throwable)ex, (ISyntaxNode)syntaxNode);
            ErrorBoundNode boundNode = new ErrorBoundNode((ISyntaxNode)syntaxNode);
            return new BoundCode(parsedCode, (IBoundNode)boundNode, new SyntaxNodeException[]{error}, null);
        }
        if (bindingContext == null) {
            IOpenBinder openlBinder = openl.getBinder();
            bindingContext = openlBinder.makeBindingContext();
        } else if (bindingContext instanceof BindingContext && ((bc = (BindingContext)bindingContext).getOpenL() == null || bc.getBinder() == null)) {
            bc.setOpenl(openl);
            bc.setBinder(openl.getBinder());
        }
        if (parsedCode.getExternalParams() != null) {
            bindingContext.setExternalParams(parsedCode.getExternalParams());
        }
        compiledDependencies = (compiledDependencies = parsedCode.getCompiledDependencies()).isEmpty() ? null : compiledDependencies;
        XlsModuleOpenClass moduleOpenClass = this.createModuleOpenClass(moduleNode, openl, this.getModuleDatabase(), compiledDependencies, bindingContext);
        RulesModuleBindingContext moduleContext = new RulesModuleBindingContext(bindingContext, moduleOpenClass);
        if (compiledDependencies != null) {
            try {
                for (IOpenClass type : moduleOpenClass.getTypes()) {
                    moduleContext.addType("org.openl.this", type);
                }
            }
            catch (Exception ex) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Can`t add datatype from dependency", (Throwable)ex, (ISyntaxNode)moduleNode);
                bindingContext.addError(error);
            }
        }
        IBoundNode topNode = this.processBinding(moduleNode, openl, moduleContext, moduleOpenClass, bindingContext);
        return new BoundCode(parsedCode, topNode, bindingContext.getErrors(), bindingContext.getMessages());
    }

    protected IDataBase getModuleDatabase() {
        return new DataBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBoundNode processBinding(XlsModuleSyntaxNode moduleNode, OpenL openl, RulesModuleBindingContext moduleContext, XlsModuleOpenClass moduleOpenClass, IBindingContext bindingContext) {
        try {
            ASelector.StringValueSelector<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
            ASelector.StringValueSelector<ISyntaxNode> constantsSelector = this.getSelector(XlsNodeTypes.XLS_CONSTANTS);
            ASelector.StringValueSelector<ISyntaxNode> dataTypeSelector = this.getSelector(XlsNodeTypes.XLS_DATATYPE);
            ASelector.StringValueSelector<ISyntaxNode> conditionsSelector = this.getSelector(XlsNodeTypes.XLS_CONDITIONS);
            ASelector.StringValueSelector<ISyntaxNode> actionsSelector = this.getSelector(XlsNodeTypes.XLS_ACTIONS);
            ASelector.StringValueSelector<ISyntaxNode> returnsSelector = this.getSelector(XlsNodeTypes.XLS_RETURNS);
            ISelector dtDefinitionSelector = conditionsSelector.or(returnsSelector).or(actionsSelector);
            ISelector notPropertiesAndNotDatatypeAndNotConstantsSelector = propertiesSelector.not().and(dataTypeSelector.not()).and(constantsSelector.not());
            ASelector.StringValueSelector<ISyntaxNode> spreadsheetSelector = this.getSelector(XlsNodeTypes.XLS_SPREADSHEET);
            ASelector.StringValueSelector<ISyntaxNode> dtSelector = this.getSelector(XlsNodeTypes.XLS_DT);
            ASelector.StringValueSelector<ISyntaxNode> testMethodSelector = this.getSelector(XlsNodeTypes.XLS_TEST_METHOD);
            ASelector.StringValueSelector<ISyntaxNode> runMethodSelector = this.getSelector(XlsNodeTypes.XLS_RUN_METHOD);
            ISelector commonTablesSelector = notPropertiesAndNotDatatypeAndNotConstantsSelector.and(spreadsheetSelector.not().and(testMethodSelector.not().and(runMethodSelector.not().and(dtSelector.not().and(dtDefinitionSelector.not())))));
            TableSyntaxNode[] propertiesNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)propertiesSelector);
            this.bindInternal(moduleNode, moduleOpenClass, propertiesNodes, openl, moduleContext);
            this.bindPropertiesForAllTables(moduleNode, moduleOpenClass, openl, moduleContext);
            IBoundNode topNode = null;
            TableSyntaxNode[] constantNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)constantsSelector);
            this.bindInternal(moduleNode, moduleOpenClass, constantNodes, openl, moduleContext);
            TableSyntaxNode[] datatypeNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)dataTypeSelector);
            TableSyntaxNode[] processedDatatypeNodes = DatatypesSorter.sort(datatypeNodes, (IBindingContext)moduleContext);
            this.bindInternal(moduleNode, moduleOpenClass, processedDatatypeNodes, openl, moduleContext);
            TableSyntaxNode[] dtHeaderDefinitionsNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)dtDefinitionSelector);
            TableSyntaxNode[] commonTables = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)commonTablesSelector);
            TableSyntaxNode[] spreadsheets = this.selectTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)spreadsheetSelector);
            if (OpenLSystemProperties.isCustomSpreadsheetType(bindingContext.getExternalParams())) {
                try {
                    spreadsheets = TableSyntaxNodeRelationsUtils.sort(spreadsheets, new SpreadsheetTableSyntaxNodeRelationsDeterminer());
                }
                catch (TableSyntaxNodeCircularDependencyException e) {
                    for (TableSyntaxNode tsn : e.getTableSyntaxNodes()) {
                        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)((Object)e), (ISyntaxNode)tsn);
                        this.processError(error, tsn, moduleContext);
                    }
                }
            }
            TableSyntaxNode[] dts = this.selectTableSyntaxNodes(moduleNode, (ISelector<ISyntaxNode>)dtSelector);
            TableSyntaxNode[] commonAndSpreadsheetTables = (TableSyntaxNode[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])dtHeaderDefinitionsNodes, (Object[])dts), (Object[])spreadsheets), (Object[])commonTables);
            this.bindInternal(moduleNode, moduleOpenClass, commonAndSpreadsheetTables, openl, moduleContext);
            TableSyntaxNode[] runTables = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)runMethodSelector);
            this.bindInternal(moduleNode, moduleOpenClass, runTables, openl, moduleContext);
            TableSyntaxNode[] testTables = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)testMethodSelector);
            topNode = this.bindInternal(moduleNode, moduleOpenClass, testTables, openl, moduleContext);
            if (moduleOpenClass.isUseDescisionTableDispatcher()) {
                DispatcherTablesBuilder dispTableBuilder = new DispatcherTablesBuilder((XlsModuleOpenClass)topNode.getType(), moduleContext);
                dispTableBuilder.build();
            }
            ((XlsModuleOpenClass)topNode.getType()).setRulesModuleBindingContext(moduleContext);
            ((XlsModuleOpenClass)topNode.getType()).completeOpenClassBuilding();
            this.processErrors(moduleOpenClass.getErrors(), bindingContext);
            IBoundNode iBoundNode = topNode;
            return iBoundNode;
        }
        finally {
            OpenLFuzzyUtils.clearCaches();
        }
    }

    private ASelector.StringValueSelector<ISyntaxNode> getSelector(XlsNodeTypes selectorValue) {
        return this.getSelector(selectorValue.toString());
    }

    private ASelector.StringValueSelector<ISyntaxNode> getSelector(String selectorValue) {
        return new ASelector.StringValueSelector(selectorValue, (AStringConvertor)new SyntaxNodeConvertor());
    }

    protected XlsModuleOpenClass createModuleOpenClass(XlsModuleSyntaxNode moduleNode, OpenL openl, IDataBase dbase, Set<CompiledDependency> moduleDependencies, IBindingContext bindingContext) {
        return new XlsModuleOpenClass(XlsHelper.getModuleName(moduleNode), new XlsMetaInfo(moduleNode), openl, dbase, moduleDependencies, Thread.currentThread().getContextClassLoader(), OpenLSystemProperties.isDTDispatchingMode(bindingContext.getExternalParams()), OpenLSystemProperties.isDispatchingValidationEnabled(bindingContext.getExternalParams()));
    }

    private void bindPropertiesForAllTables(XlsModuleSyntaxNode moduleNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext bindingContext) {
        ASelector.StringValueSelector<ISyntaxNode> propertiesSelector = this.getSelector(XlsNodeTypes.XLS_PROPERTIES);
        ASelector.StringValueSelector<ISyntaxNode> otherNodesSelector = this.getSelector(XlsNodeTypes.XLS_OTHER);
        ISelector notPropertiesAndNotOtherSelector = propertiesSelector.not().and(otherNodesSelector.not());
        TableSyntaxNode[] tableSyntaxNodes = this.selectNodes(moduleNode, (ISelector<ISyntaxNode>)notPropertiesAndNotOtherSelector);
        PropertiesLoader propLoader = new PropertiesLoader(openl, bindingContext, module);
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            try {
                propLoader.loadProperties(tsn);
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tsn, bindingContext);
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tsn, bindingContext);
                }
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tsn);
                this.processError(error, tsn, bindingContext);
            }
        }
    }

    private void addImports(OpenLBuilderImpl builder, Collection<String> imports) {
        LinkedHashSet<String> packageNames = new LinkedHashSet<String>();
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        LinkedHashSet<String> libraries = new LinkedHashSet<String>();
        for (String singleImport : imports) {
            if (singleImport.endsWith(".*")) {
                try {
                    String libraryClassName = singleImport.substring(0, singleImport.length() - 2);
                    this.userContext.getUserClassLoader().loadClass(libraryClassName);
                    libraries.add(libraryClassName);
                }
                catch (Exception e) {
                    packageNames.add(singleImport.substring(0, singleImport.length() - 2));
                }
                continue;
            }
            try {
                this.userContext.getUserClassLoader().loadClass(singleImport);
                classNames.add(singleImport);
            }
            catch (Exception e) {
                packageNames.add(singleImport);
            }
        }
        builder.setPackageImports(packageNames.toArray(new String[0]));
        builder.setClassImports(classNames.toArray(new String[0]));
        builder.setLibraries(libraries.toArray(new String[0]));
    }

    private OpenL makeOpenL(XlsModuleSyntaxNode moduleNode) {
        String openlName = this.getOpenLName(moduleNode.getOpenlNode());
        Collection<String> imports = moduleNode.getImports();
        if (imports == null) {
            return OpenL.getInstance((String)openlName, (IUserContext)this.userContext);
        }
        OpenLBuilderImpl builder = new OpenLBuilderImpl();
        builder.setExtendsCategory(openlName);
        String category = openlName + "::" + moduleNode.getModule().getUri();
        builder.setCategory(category);
        this.addImports(builder, imports);
        builder.setContexts(null, this.userContext);
        return OpenL.getInstance((String)category, (IUserContext)this.userContext, (IOpenLBuilder)builder);
    }

    private IMemberBoundNode preBindXlsNode(ISyntaxNode syntaxNode, OpenL openl, RulesModuleBindingContext bindingContext, XlsModuleOpenClass moduleOpenClass) throws Exception {
        String tableSyntaxNodeType = syntaxNode.getType();
        AXlsTableBinder binder = this.findBinder(tableSyntaxNodeType);
        if (binder == null) {
            this.log.debug("Unknown table type '{}'", (Object)tableSyntaxNodeType);
            return null;
        }
        TableSyntaxNode tableSyntaxNode = (TableSyntaxNode)syntaxNode;
        return binder.preBind(tableSyntaxNode, openl, (IBindingContext)bindingContext, moduleOpenClass);
    }

    protected AXlsTableBinder findBinder(String tableSyntaxNodeType) {
        return XlsBinder.getBinderFactory().get(tableSyntaxNodeType);
    }

    protected String getDefaultOpenLName() {
        return "org.openl.rules.java";
    }

    private String getOpenLName(OpenlSyntaxNode osn) {
        return osn == null ? this.getDefaultOpenLName() : osn.getOpenlName();
    }

    private TableSyntaxNode[] selectNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector) {
        return this.selectAndSortNodes(moduleSyntaxNode, childSelector, null);
    }

    private TableSyntaxNode[] selectAndSortNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector, Comparator<TableSyntaxNode> nodesComparator) {
        ArrayList<TableSyntaxNode> childSyntaxNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : moduleSyntaxNode.getXlsTableSyntaxNodes()) {
            if (childSelector != null && !childSelector.select((Object)tsn)) continue;
            childSyntaxNodes.add(tsn);
        }
        TableSyntaxNode[] tableSyntaxNodes = childSyntaxNodes.toArray(new TableSyntaxNode[childSyntaxNodes.size()]);
        if (nodesComparator != null) {
            try {
                Arrays.sort(tableSyntaxNodes, nodesComparator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tableSyntaxNodes;
    }

    private TableSyntaxNode[] selectTableSyntaxNodes(XlsModuleSyntaxNode moduleSyntaxNode, ISelector<ISyntaxNode> childSelector) {
        ArrayList<TableSyntaxNode> childSyntaxNodes = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode tsn : moduleSyntaxNode.getXlsTableSyntaxNodes()) {
            if (childSelector != null && !childSelector.select((Object)tsn)) continue;
            childSyntaxNodes.add(tsn);
        }
        return childSyntaxNodes.toArray(new TableSyntaxNode[childSyntaxNodes.size()]);
    }

    private boolean isExecutableTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        return XlsNodeTypes.XLS_DT.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_TBASIC.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_METHOD.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_COLUMN_MATCH.equals((Object)tableSyntaxNode.getNodeType()) || XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType());
    }

    private boolean isSpreadsheetResultTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        return XlsNodeTypes.XLS_SPREADSHEET.equals((Object)tableSyntaxNode.getNodeType());
    }

    private Set<String> extractCustomSpreadsheetResultTypes(TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext moduleContext) {
        HashSet<String> customSpreadsheetResultTypeNames = new HashSet<String>();
        if (OpenLSystemProperties.isCustomSpreadsheetType(moduleContext.getExternalParams())) {
            for (int i = 0; i < tableSyntaxNodes.length; ++i) {
                if (!this.isSpreadsheetResultTableSyntaxNode(tableSyntaxNodes[i])) continue;
                customSpreadsheetResultTypeNames.add("SpreadsheetResult" + TableSyntaxNodeHelper.getTableName(tableSyntaxNodes[i]));
            }
        }
        return customSpreadsheetResultTypeNames;
    }

    protected IBoundNode bindInternal(XlsModuleSyntaxNode moduleSyntaxNode, XlsModuleOpenClass module, TableSyntaxNode[] tableSyntaxNodes, OpenL openl, RulesModuleBindingContext moduleContext) {
        int i;
        IMemberBoundNode[] children = new IMemberBoundNode[tableSyntaxNodes.length];
        OpenMethodHeader[] openMethodHeaders = new OpenMethodHeader[tableSyntaxNodes.length];
        Set<String> customSpreadsheetResultTypes = this.extractCustomSpreadsheetResultTypes(tableSyntaxNodes, moduleContext);
        SyntaxNodeExceptionHolder syntaxNodeExceptionHolder = new SyntaxNodeExceptionHolder();
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            if (!this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            openMethodHeaders[i] = this.addMethodHeaderToContext(module, tableSyntaxNodes[i], openl, moduleContext, syntaxNodeExceptionHolder, children, i, customSpreadsheetResultTypes);
        }
        for (i = 0; i < tableSyntaxNodes.length; ++i) {
            IMemberBoundNode child;
            if (this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            children[i] = child = this.beginBind(tableSyntaxNodes[i], module, openl, moduleContext);
            if (child == null) continue;
            try {
                child.addTo((ModuleOpenClass)module);
                continue;
            }
            catch (OpenlNotCheckedException e) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, tableSyntaxNodes[i], moduleContext);
            }
        }
        for (i = 0; i < children.length; ++i) {
            if (!this.isExecutableTableSyntaxNode(tableSyntaxNodes[i])) continue;
            moduleContext.preBindMethod(openMethodHeaders[i]);
        }
        for (i = 0; i < children.length; ++i) {
            if (children[i] == null) continue;
            this.finilizeBind(children[i], tableSyntaxNodes[i], moduleContext);
        }
        syntaxNodeExceptionHolder.processModuleContextErrors((IBindingContext)moduleContext);
        if (moduleContext.isExecutionMode()) {
            this.removeDebugInformation(children, tableSyntaxNodes, moduleContext);
        }
        return new ModuleNode((ISyntaxNode)moduleSyntaxNode, (IOpenClass)moduleContext.getModule());
    }

    private OpenMethodHeader addMethodHeaderToContext(XlsModuleOpenClass module, TableSyntaxNode tableSyntaxNode, OpenL openl, RulesModuleBindingContext moduleContext, SyntaxNodeExceptionHolder syntaxNodeExceptionHolder, IMemberBoundNode[] children, int index, Set<String> customSpreadsheetResultTypes) {
        try {
            AExecutableNodeBinder aExecutableNodeBinder = (AExecutableNodeBinder)XlsBinder.getBinderFactory().get(tableSyntaxNode.getType());
            IOpenSourceCodeModule source = null;
            if (!customSpreadsheetResultTypes.isEmpty()) {
                int j;
                String headerSource = aExecutableNodeBinder.createHeaderSource(tableSyntaxNode, (IBindingContext)moduleContext).getCode();
                String[] tokens = REGEX.split(headerSource);
                ArrayList<String> notEmptyTokens = new ArrayList<String>();
                for (String token : tokens) {
                    if (token.isEmpty()) continue;
                    notEmptyTokens.add(token);
                }
                tokens = notEmptyTokens.toArray(new String[0]);
                StringBuilder sb = new StringBuilder();
                this.addTypeToken(customSpreadsheetResultTypes, tokens[0], sb);
                for (j = 1; j < tokens.length && (tokens[j].startsWith("[") || tokens[j].startsWith("]")); ++j) {
                    sb.append(tokens[j]);
                }
                sb.append(" ");
                sb.append(tokens[j++]);
                sb.append("(");
                boolean isType = true;
                while (j < tokens.length) {
                    if (isType) {
                        this.addTypeToken(customSpreadsheetResultTypes, tokens[j], sb);
                        ++j;
                        while (j < tokens.length && (tokens[j].startsWith("[") || tokens[j].startsWith("]"))) {
                            sb.append(tokens[j]);
                            ++j;
                        }
                        isType = false;
                        sb.append(" ");
                        continue;
                    }
                    sb.append(tokens[j]);
                    isType = true;
                    if (++j >= tokens.length - 1) continue;
                    sb.append(", ");
                }
                sb.append(")");
                headerSource = sb.toString();
                source = new StringSourceCodeModule(headerSource, tableSyntaxNode.getUri());
            } else {
                source = aExecutableNodeBinder.createHeaderSource(tableSyntaxNode, (IBindingContext)moduleContext);
            }
            OpenMethodHeader openMethodHeader = (OpenMethodHeader)OpenLManager.makeMethodHeader((OpenL)openl, (IOpenSourceCodeModule)source, (IBindingContext)moduleContext);
            XlsBinderExecutableMethodBind xlsBinderExecutableMethodBind = new XlsBinderExecutableMethodBind(module, openl, tableSyntaxNode, children, index, openMethodHeader, moduleContext, syntaxNodeExceptionHolder);
            moduleContext.addBinderMethod(openMethodHeader, xlsBinderExecutableMethodBind);
            return openMethodHeader;
        }
        catch (Exception | LinkageError e) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
    }

    private void addTypeToken(Set<String> customSpreadsheetResultTypes, String token, StringBuilder sb) {
        int i = token.indexOf(91);
        if (i > 0) {
            String beginToken = token.substring(0, i);
            String endToken = token.substring(i);
            if (customSpreadsheetResultTypes.contains(beginToken)) {
                sb.append("SpreadsheetResult");
                sb.append(endToken);
            } else {
                sb.append(token);
            }
        } else if (customSpreadsheetResultTypes.contains(token)) {
            sb.append("SpreadsheetResult");
        } else {
            sb.append(token);
        }
    }

    protected void finilizeBind(IMemberBoundNode memberBoundNode, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        try {
            memberBoundNode.finalizeBind((IBindingContext)moduleContext);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
        }
        catch (CompositeSyntaxNodeException ex) {
            if (ex.getErrors() != null) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tableSyntaxNode, moduleContext);
                }
            }
        }
        catch (Exception | LinkageError t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
        }
    }

    protected void removeDebugInformation(IMemberBoundNode[] boundNodes, TableSyntaxNode[] tableSyntaxNodes, RulesModuleBindingContext moduleContext) {
        for (int i = 0; i < boundNodes.length; ++i) {
            if (boundNodes[i] == null) continue;
            try {
                boundNodes[i].removeDebugInformation((IBindingContext)moduleContext);
                continue;
            }
            catch (SyntaxNodeException error) {
                this.processError(error, tableSyntaxNodes[i], moduleContext);
                continue;
            }
            catch (CompositeSyntaxNodeException ex) {
                for (SyntaxNodeException error : ex.getErrors()) {
                    this.processError(error, tableSyntaxNodes[i], moduleContext);
                }
                continue;
            }
            catch (Exception | LinkageError t) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNodes[i]);
                this.processError(error, tableSyntaxNodes[i], moduleContext);
            }
        }
    }

    protected IMemberBoundNode beginBind(TableSyntaxNode tableSyntaxNode, XlsModuleOpenClass module, OpenL openl, RulesModuleBindingContext moduleContext) {
        try {
            return this.preBindXlsNode((ISyntaxNode)tableSyntaxNode, openl, moduleContext, module);
        }
        catch (SyntaxNodeException error) {
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
        catch (CompositeSyntaxNodeException ex) {
            for (SyntaxNodeException error : ex.getErrors()) {
                this.processError(error, tableSyntaxNode, moduleContext);
            }
            return null;
        }
        catch (Exception | LinkageError t) {
            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)t, (ISyntaxNode)tableSyntaxNode);
            this.processError(error, tableSyntaxNode, moduleContext);
            return null;
        }
    }

    protected void processError(SyntaxNodeException error, TableSyntaxNode tableSyntaxNode, RulesModuleBindingContext moduleContext) {
        tableSyntaxNode.addError(error);
        moduleContext.addError(error);
    }

    protected void processErrors(List<Exception> errors, IBindingContext bindingContext) {
        if (errors != null) {
            for (Exception error : errors) {
                if (error instanceof SyntaxNodeException) {
                    bindingContext.addError((SyntaxNodeException)((Object)error));
                    continue;
                }
                if (error instanceof CompositeSyntaxNodeException) {
                    BindHelper.processError((CompositeSyntaxNodeException)((CompositeSyntaxNodeException)((Object)error)), (IBindingContext)bindingContext);
                    continue;
                }
                BindHelper.processError((Throwable)error, null, (IBindingContext)bindingContext);
            }
        }
    }

    static {
        BINDERS = new String[][]{{XlsNodeTypes.XLS_DATA.toString(), DataNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DATATYPE.toString(), DatatypeNodeBinder.class.getName()}, {XlsNodeTypes.XLS_DT.toString(), DecisionTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_SPREADSHEET.toString(), SpreadsheetNodeBinder.class.getName()}, {XlsNodeTypes.XLS_METHOD.toString(), MethodTableNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TEST_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_RUN_METHOD.toString(), TestMethodNodeBinder.class.getName()}, {XlsNodeTypes.XLS_TBASIC.toString(), AlgorithmNodeBinder.class.getName()}, {XlsNodeTypes.XLS_COLUMN_MATCH.toString(), ColumnMatchNodeBinder.class.getName()}, {XlsNodeTypes.XLS_PROPERTIES.toString(), PropertyTableBinder.class.getName()}, {XlsNodeTypes.XLS_CONDITIONS.toString(), ConditionsTableBinder.class.getName()}, {XlsNodeTypes.XLS_ACTIONS.toString(), ActionsTableBinder.class.getName()}, {XlsNodeTypes.XLS_RETURNS.toString(), ReturnsTableBinder.class.getName()}, {XlsNodeTypes.XLS_CONSTANTS.toString(), ConstantsTableBinder.class.getName()}};
    }

    private static class SyntaxNodeExceptionHolder {
        private List<SyntaxNodeException> syntaxNodeExceptions = new ArrayList<SyntaxNodeException>();

        private SyntaxNodeExceptionHolder() {
        }

        private void addModuleContextError(SyntaxNodeException e) {
            this.syntaxNodeExceptions.add(e);
        }

        private void processModuleContextErrors(IBindingContext bindingContext) {
            for (SyntaxNodeException e : this.syntaxNodeExceptions) {
                bindingContext.addError(e);
            }
            this.syntaxNodeExceptions.clear();
        }
    }

    class XlsBinderExecutableMethodBind
    implements RecursiveOpenMethodPreBinder {
        TableSyntaxNode tableSyntaxNode;
        RulesModuleBindingContext moduleContext;
        OpenL openl;
        XlsModuleOpenClass module;
        IMemberBoundNode[] childrens;
        int index;
        OpenMethodHeader openMethodHeader;
        boolean preBindeding = false;
        List<RecursiveOpenMethodPreBinder> recursiveOpenMethodPreBinderMethods = null;
        SyntaxNodeExceptionHolder syntaxNodeExceptionHolder;

        public XlsBinderExecutableMethodBind(XlsModuleOpenClass module, OpenL openl, TableSyntaxNode tableSyntaxNode, IMemberBoundNode[] childrens, int index, OpenMethodHeader openMethodHeader, RulesModuleBindingContext moduleContext, SyntaxNodeExceptionHolder syntaxNodeExceptionHolder) {
            this.tableSyntaxNode = tableSyntaxNode;
            this.moduleContext = moduleContext;
            this.module = module;
            this.openl = openl;
            this.childrens = childrens;
            this.index = index;
            this.openMethodHeader = openMethodHeader;
            this.syntaxNodeExceptionHolder = syntaxNodeExceptionHolder;
        }

        @Override
        public void addRecursiveOpenMethodPreBinderMethod(RecursiveOpenMethodPreBinder method) {
            if (this.recursiveOpenMethodPreBinderMethods == null) {
                this.recursiveOpenMethodPreBinderMethods = new ArrayList<RecursiveOpenMethodPreBinder>();
            }
            this.recursiveOpenMethodPreBinderMethods.add(method);
        }

        @Override
        public OpenMethodHeader getHeader() {
            return this.openMethodHeader;
        }

        public String getDisplayName(int mode) {
            return this.openMethodHeader.getDisplayName(mode);
        }

        public IOpenClass getType() {
            return this.openMethodHeader.getType();
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public IMethodSignature getSignature() {
            return this.openMethodHeader.getSignature();
        }

        public String getName() {
            return this.openMethodHeader.getName();
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            throw new UnsupportedOperationException();
        }

        public IMemberMetaInfo getInfo() {
            return this.openMethodHeader.getInfo();
        }

        public boolean isStatic() {
            return this.openMethodHeader.isStatic();
        }

        public boolean isConstructor() {
            return false;
        }

        public IOpenClass getDeclaringClass() {
            return this.module;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBind() {
            try {
                this.preBindeding = true;
                try {
                    IMemberBoundNode memberBoundNode;
                    this.moduleContext.pushErrors();
                    this.childrens[this.index] = memberBoundNode = XlsBinder.this.beginBind(this.tableSyntaxNode, this.module, this.openl, this.moduleContext);
                    if (memberBoundNode != null) {
                        try {
                            memberBoundNode.addTo((ModuleOpenClass)this.module);
                        }
                        catch (Exception | LinkageError e) {
                            SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)this.tableSyntaxNode);
                            XlsBinder.this.processError(error, this.tableSyntaxNode, this.moduleContext);
                        }
                    }
                }
                finally {
                    List syntaxNodeExceptions = this.moduleContext.popErrors();
                    for (SyntaxNodeException e : syntaxNodeExceptions) {
                        this.syntaxNodeExceptionHolder.addModuleContextError(e);
                    }
                }
                if (this.recursiveOpenMethodPreBinderMethods != null) {
                    for (RecursiveOpenMethodPreBinder recursiveOpenMethodPreBinderMethod : this.recursiveOpenMethodPreBinderMethods) {
                        recursiveOpenMethodPreBinderMethod.preBind();
                    }
                }
            }
            finally {
                this.preBindeding = false;
            }
        }

        @Override
        public boolean isPreBinding() {
            return this.preBindeding;
        }
    }
}

