/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.rules.lang.xls.binding.DTColumnsDefinitionType;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.types.IUriMember;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;

public class DTColumnsDefinition
implements IUriMember {
    private Map<String, List<IParameterDeclaration>> localParameters;
    private IOpenMethodHeader header;
    private CompositeMethod compositeMethod;
    private DTColumnsDefinitionType type;
    private String uri;

    public DTColumnsDefinition(DTColumnsDefinitionType type, Map<String, List<IParameterDeclaration>> localParameters, IOpenMethodHeader header, CompositeMethod compositeMethod, TableSyntaxNode tableSyntaxNode) {
        this.localParameters = localParameters;
        this.compositeMethod = compositeMethod;
        this.header = header;
        this.type = type;
        this.uri = tableSyntaxNode.getUri();
    }

    public CompositeMethod getCompositeMethod() {
        return this.compositeMethod;
    }

    public int getNumberOfTitles() {
        return this.localParameters.size();
    }

    public List<IParameterDeclaration> getLocalParameters(String title) {
        List<IParameterDeclaration> value = this.localParameters.get(title);
        if (value != null) {
            return Collections.unmodifiableList(value);
        }
        return Collections.emptyList();
    }

    public Collection<IParameterDeclaration> getLocalParameters() {
        return this.localParameters.values().stream().flatMap(Collection::stream).filter(e -> e != null && e.getName() != null).collect(Collectors.toCollection(ArrayList::new));
    }

    public Set<String> getTitles() {
        return Collections.unmodifiableSet(this.localParameters.keySet());
    }

    public IOpenMethodHeader getHeader() {
        return this.header;
    }

    public DTColumnsDefinitionType getType() {
        return this.type;
    }

    public boolean isCondition() {
        return DTColumnsDefinitionType.CONDITION.equals((Object)this.type);
    }

    public boolean isAction() {
        return DTColumnsDefinitionType.ACTION.equals((Object)this.type);
    }

    public boolean isReturn() {
        return DTColumnsDefinitionType.RETURN.equals((Object)this.type);
    }

    @Override
    public String getUri() {
        return this.uri;
    }
}

