/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.DTColumnsDefinitionType;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;

public class XlsDefinitions {
    private Collection<DTColumnsDefinition> dtColumnsDefinitions = new LinkedHashSet<DTColumnsDefinition>();

    private static final boolean theSame(DTColumnsDefinition dtColumnDefinition1, DTColumnsDefinition dtColumnDefinition2) {
        int i;
        String dtColumnDefinition2Code;
        if (!Objects.equals((Object)dtColumnDefinition1.getType(), (Object)dtColumnDefinition2.getType())) {
            return false;
        }
        if (dtColumnDefinition1.getNumberOfTitles() != dtColumnDefinition2.getNumberOfTitles()) {
            return false;
        }
        if (dtColumnDefinition1.getHeader().getSignature().getNumberOfParameters() != dtColumnDefinition2.getHeader().getSignature().getNumberOfParameters()) {
            return false;
        }
        String dtColumnDefinition1Code = dtColumnDefinition1.getCompositeMethod().getMethodBodyBoundNode().getSyntaxNode().getModule().getCode();
        if (!Objects.equals(dtColumnDefinition1Code, dtColumnDefinition2Code = dtColumnDefinition2.getCompositeMethod().getMethodBodyBoundNode().getSyntaxNode().getModule().getCode())) {
            return false;
        }
        HashMap<String, IOpenClass> map = new HashMap<String, IOpenClass>();
        for (i = 0; i < dtColumnDefinition1.getHeader().getSignature().getNumberOfParameters(); ++i) {
            map.put(dtColumnDefinition1.getHeader().getSignature().getParameterName(i), dtColumnDefinition1.getHeader().getSignature().getParameterType(i));
        }
        for (i = 0; i < dtColumnDefinition2.getHeader().getSignature().getNumberOfParameters(); ++i) {
            IOpenClass type = (IOpenClass)map.get(dtColumnDefinition2.getHeader().getSignature().getParameterName(i));
            if (type != null && type.equals(dtColumnDefinition2.getHeader().getSignature().getParameterType(i))) continue;
            return false;
        }
        Set<String> titles1 = dtColumnDefinition1.getTitles();
        Set<String> titles2 = dtColumnDefinition1.getTitles();
        for (String title : titles1) {
            if (!titles2.contains(title)) {
                return false;
            }
            List<IParameterDeclaration> parameterDeclarations1 = dtColumnDefinition1.getLocalParameters(title);
            List<IParameterDeclaration> parameterDeclarations2 = dtColumnDefinition2.getLocalParameters(title);
            if (parameterDeclarations1.size() != parameterDeclarations2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < parameterDeclarations1.size(); ++i2) {
                IParameterDeclaration parameterDeclaration1 = parameterDeclarations1.get(0);
                IParameterDeclaration parameterDeclaration2 = parameterDeclarations2.get(0);
                if (parameterDeclaration1 == null || parameterDeclaration2 == null) {
                    if (parameterDeclaration1 == null && parameterDeclaration2 == null) continue;
                    return false;
                }
                if (Objects.equals(parameterDeclaration1.getName(), parameterDeclaration2.getName()) && Objects.equals(parameterDeclaration1.getType(), parameterDeclaration2.getType())) continue;
                return false;
            }
        }
        return true;
    }

    public void addDtColumnsDefinition(DTColumnsDefinition dtColumnsDefinition) {
        if (this.dtColumnsDefinitions.contains(dtColumnsDefinition)) {
            return;
        }
        for (DTColumnsDefinition cd : this.dtColumnsDefinitions) {
            if (!XlsDefinitions.theSame(cd, dtColumnsDefinition)) continue;
            return;
        }
        this.dtColumnsDefinitions.add(dtColumnsDefinition);
    }

    public void addAllDtColumnsDefinitions(Collection<DTColumnsDefinition> dtColumnsDefinitions) {
        for (DTColumnsDefinition dtColumnsDefinition : dtColumnsDefinitions) {
            this.addDtColumnsDefinition(dtColumnsDefinition);
        }
    }

    public Collection<DTColumnsDefinition> getDtColumnsDefinitions() {
        return Collections.unmodifiableCollection(this.dtColumnsDefinitions);
    }

    public Collection<DTColumnsDefinition> getConditionDefinitions() {
        return this.dtColumnsDefinitions.stream().filter(e -> DTColumnsDefinitionType.CONDITION.equals((Object)e.getType())).collect(Collectors.toList());
    }

    public Collection<DTColumnsDefinition> getActionDefinitions() {
        return this.dtColumnsDefinitions.stream().filter(e -> DTColumnsDefinitionType.ACTION.equals((Object)e.getType())).collect(Collectors.toList());
    }

    public Collection<DTColumnsDefinition> getReturnDefinitions() {
        return this.dtColumnsDefinitions.stream().filter(e -> DTColumnsDefinitionType.RETURN.equals((Object)e.getType())).collect(Collectors.toList());
    }

    public void addAll(XlsDefinitions xlsModuleDefinitions) {
        this.addAllDtColumnsDefinitions(xlsModuleDefinitions.dtColumnsDefinitions);
    }
}

